<?php
/*
Plugin Name: Chronos CountDown
Description: You can use it as Countdown for WebSites with Maintenance mode enabled, for Events and Products launch or as expiry date for Offers and Discounts
Version: 1.2
Author: Lambert Group
Author URI: https://1.envato.market/OZ5Zr
Text Domain: chronos-countdown
*/

ini_set('display_errors', 0);
$chronos_countdown_path = trailingslashit(dirname(__FILE__));  //empty

//all the messages
$chronos_countdown_messages = array(
		'version' => __( '<div class="error">Chronos CountDown - WebSites/Products Launch plugin requires WordPress 3.0 or newer. <a href="https://codex.wordpress.org/Upgrading_WordPress">Please update!</a></div>', 'chronos-countdown' ),
		'empty_img' => __( 'Image - required', 'chronos-countdown' ),
		'empty_name' => __( 'Name - required', 'chronos-countdown' ),
		'invalid_request' => __( 'Invalid Request!', 'chronos-countdown' ),
		'generate_for_this_countdown' => __( 'You can start customizing this CountDown.', 'chronos-countdown' ),
		'data_saved' => __( 'Data Saved!', 'chronos-countdown' )
	);


global $wp_version;

if ( !version_compare($wp_version,"3.0",">=")) {
	die ( __($chronos_countdown_messages['version'], 'chronos-countdown' ) );
}




function chronos_countdown_activate() {
	//db creation, create admin options etc.
	global $wpdb;

	$currentY=date("Y");
	$currentM=date("n");
	$currentD=date("j");
	$currentH=date("H");
	$currentMin=date("i");
	$currentS=date("s");

	$chronos_countdown_collate = ' COLLATE utf8_general_ci';

	$sql0 = "CREATE TABLE `" . $wpdb->prefix . "chronos_countdown_countdowns` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
			`name` VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY ( `id` )
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql1 = "CREATE TABLE `" . $wpdb->prefix . "chronos_countdown_settings` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `endDate_date` varchar(255) NOT NULL DEFAULT '".($currentY+1).','.$currentM.','.$currentD."',
  `endDate_hours` smallint(5) unsigned NOT NULL DEFAULT '".$currentH."',
  `endDate_minutes` smallint(5) unsigned NOT NULL DEFAULT '".$currentMin."',
  `endDate_seconds` smallint(5) unsigned NOT NULL DEFAULT '".$currentS."',
  `servertime` varchar(8) NOT NULL DEFAULT 'true',
  `enableMaintenanceMode` varchar(8) NOT NULL DEFAULT 'false',
  `pageBgImage` text,
  `pageBgYouTube` text,
  `pageBgVimeo` text,
	`pageBgMp4` text,
	`pageBgAdditionalCss` varchar(255) NOT NULL DEFAULT '',
	`texturePath` text,
  `pluginFontFamily` varchar(255) NOT NULL DEFAULT 'PT Serif, serif',
  `pluginFontFamilyGoogleLink` varchar(255) NOT NULL DEFAULT 'https://fonts.googleapis.com/css?family=PT+Serif:400,700',
	`elementWidth` smallint(5) unsigned NOT NULL DEFAULT '120',
	`elementHeight` smallint(5) unsigned NOT NULL DEFAULT '150',
	`elementBgColor` varchar(8) NOT NULL DEFAULT 'FFF000',
	`elementFontSize` smallint(5) unsigned NOT NULL DEFAULT '100',
	`elementFontColor` varchar(8) NOT NULL DEFAULT '000CCC',
	`elementLabelFontSize` smallint(5) unsigned NOT NULL DEFAULT '30',
	`elementLabelColor` varchar(8) NOT NULL DEFAULT 'FF0000',
	`elementLabelTopPadding` smallint(5) NOT NULL DEFAULT '120',
	`elementsDotsSeparatorColor` varchar(8) NOT NULL DEFAULT 'FFF000',
	`countDownTopPadding` smallint(5) NOT NULL DEFAULT '120',
	`countDownBottomPadding` smallint(5) NOT NULL DEFAULT '80',
	`clockFace` varchar(255) NOT NULL DEFAULT 'DailyCounter',
	`language` varchar(255) NOT NULL DEFAULT 'english',
	`videoProportionWidth` smallint(5) unsigned NOT NULL DEFAULT '16',
  `lineSeparatorImg` text,
  `logo` text,
  `logoLink` text,
  `logoTarget` varchar(8) NOT NULL DEFAULT '_blank',
  `socialBgOFF` text,
  `socialBgON` text,
  `complete` text,
  `autoReset24h` varchar(8) NOT NULL DEFAULT 'false',
  `h2Text` text,
  `h2Size` smallint(5) unsigned NOT NULL DEFAULT '36',
  `h2Color` varchar(8) NOT NULL DEFAULT 'FFFFFF',
  `h2Weight` varchar(255) NOT NULL DEFAULT 'bold',
  `h2TopMargin` smallint(5) NOT NULL DEFAULT '60',
  `h3Text` text,
  `h3Size` smallint(5) unsigned NOT NULL DEFAULT '24',
  `h3Color` varchar(8) NOT NULL DEFAULT '6f6f6f',
  `h3Weight` varchar(255) NOT NULL DEFAULT 'normal',
  `h3TopMargin` smallint(5) NOT NULL DEFAULT '40',
  `h4Text` text,
  `h4Size` smallint(5) unsigned NOT NULL DEFAULT '14',
  `h4Color` varchar(8) NOT NULL DEFAULT '6f6f6f',
  `h4Weight` varchar(255) NOT NULL DEFAULT 'normal',
  `h4TopMargin` smallint(5) NOT NULL DEFAULT '15',
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql2 = "CREATE TABLE `". $wpdb->prefix . "chronos_countdown_playlist` (
	  `id` int(10) unsigned NOT NULL auto_increment,
	  `countdownid` int(10) unsigned NOT NULL,
	  `img` text,
	  `title` text,
	  `data-link` text,
	  `data-target` varchar(8),
	  `ord` int(10) unsigned NOT NULL,
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";


	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql0.$chronos_countdown_collate);
	dbDelta($sql1.$chronos_countdown_collate);
	dbDelta($sql2.$chronos_countdown_collate);



	//initialize the countdowns table with the first countdown type
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."chronos_countdown_countdowns;" );
	if (!$rows_count) {
		$wpdb->insert(
			$wpdb->prefix . "chronos_countdown_countdowns",
			array(
				'name' => 'First CountDown'
			),
			array(
				'%s'
			)
		);
	}

	// initialize the settings
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."chronos_countdown_settings;" );
	if (!$rows_count) {
		chronos_countdown_insert_settings_record(1);
	}

}


function chronos_countdown_insert_settings_record($countdown_id) {
	global $wpdb;
	$wpdb->insert(
			$wpdb->prefix . "chronos_countdown_settings",
			array(
				'socialBgOFF' => plugins_url() . '/chronos_countdown/chronos_countdown/countdown_images/social_icons/socialCircleOFF.png',
				'socialBgON' => plugins_url() . '/chronos_countdown/chronos_countdown/countdown_images/social_icons/socialCircleON.png',
				'lineSeparatorImg' => plugins_url() . '/chronos_countdown/chronos_countdown/countdown_images/line.png',
				'texturePath' => plugins_url() . '/chronos_countdown/chronos_countdown/countdown_images/patternFullScreenBg_2.png',
				'h2Text' => 'UNDER CONSTRUCTION!',
				'h3Text' => 'Let\'s meet in:',
				'h4Text' => 'Until then, enjoy our social channels',
				'pluginFontFamily' => '\'PT Serif\', serif'
			),
			array(
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s'
			)
		);
}


function chronos_countdown_init_sessions() {
	global $wpdb;
	if (is_admin()) {
		if (!session_id()) {
			session_start();

			//initialize the session
			if (!isset($_SESSION['xid'])) {
				$safe_sql="SELECT * FROM (".$wpdb->prefix ."chronos_countdown_countdowns) LIMIT 0, 1";
				$row = $wpdb->get_row($safe_sql,ARRAY_A);
				$_SESSION['xid'] = $row['id'];
				$_SESSION['xname'] = $row['name'];
			}
		}
	}
}


function chronos_countdown_load_styles() {
	global $wpdb;
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/chronos_countdown/i', $page)) {

			wp_enqueue_style('lbg-jquery-ui-custom_css', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/pepper-grinder/jquery-ui.min.css');
			wp_enqueue_style('chronos-countdown-css', plugins_url('css/styles.css', __FILE__));
			wp_enqueue_style('chronos-countdown-colorpicker-css', plugins_url('css/colorpicker/colorpicker.css', __FILE__));

			wp_enqueue_style('thickbox');

		}
	} else if (!is_admin()) { //loads css in front-end
		wp_enqueue_style('chronos-countdown-flipclock-css', plugins_url('chronos_countdown/css/flipclock.css', __FILE__));
		wp_enqueue_style('chronos-countdown-site-css', plugins_url('chronos_countdown/css/chronos_countdown.css', __FILE__));
	}
}

function chronos_countdown_load_scripts() {
	global $is_IE;
	$page = (isset($_GET['page'])) ? $_GET['page'] : '';
	if(preg_match('/chronos_countdown/i', $page)) {
		//loads scripts in admin
			wp_enqueue_script('jquery');

			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');

			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');

			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');
			wp_enqueue_script('jquery-effects-transfer');

			wp_register_script('lbg-colorpicker', plugins_url('js/colorpicker/colorpicker.js', __FILE__));
			wp_enqueue_script('lbg-colorpicker');

			wp_register_script('lbg-admin-toggle', plugins_url('js/myToggle.js', __FILE__));
			wp_enqueue_script('lbg-admin-toggle');

			wp_enqueue_script('media-upload'); // before w.p 3.5
			wp_enqueue_media();// from w.p 3.5
			wp_enqueue_script('thickbox');
	} else if (!is_admin()) { //loads scripts in front-end

		wp_enqueue_script('jquery');

		wp_register_script('lbg-flipclock', plugins_url('chronos_countdown\js\flipclock.min.js', __FILE__));
		wp_enqueue_script('lbg-flipclock');

		wp_register_script('lbg-chronoscountdown', plugins_url('chronos_countdown\js\chronos_countdown.js', __FILE__));
		wp_enqueue_script('lbg-chronoscountdown');


	}


}



// adds the menu pages
function chronos_countdown_plugin_menu() {
	add_menu_page('CHRONOS-COUNTDOWN Admin Interface', 'CHRONOS COUNTDOWN', 'edit_posts', 'chronos_countdown', 'chronos_countdown_overview_page',
	plugins_url('images/plg_icon.png', __FILE__));
	add_submenu_page( 'chronos_countdown', 'CHRONOS-COUNTDOWN Overview', 'Overview', 'edit_posts', 'chronos_countdown', 'chronos_countdown_overview_page');
	add_submenu_page( 'chronos_countdown', 'CHRONOS-COUNTDOWN Manage CountDowns', 'Manage CountDowns', 'edit_posts', 'chronos_countdown_Manage_CountDowns', 'chronos_countdown_manage_countdowns_page');
	add_submenu_page( 'chronos_countdown', 'CHRONOS-COUNTDOWN Manage CountDowns Add New', 'Add New', 'edit_posts', 'chronos_countdown_Add_New', 'chronos_countdown_manage_countdowns_add_new_page');
	add_submenu_page( 'chronos_countdown_Manage_CountDowns', 'CHRONOS-COUNTDOWN CountDown Settings', 'CountDown Settings', 'edit_posts', 'chronos_countdown_Settings', 'chronos_countdown_settings_page');
	add_submenu_page( 'chronos_countdown_Manage_CountDowns', 'CHRONOS-COUNTDOWN CountDown Playlist', 'Playlist', 'edit_posts', 'chronos_countdown_Playlist', 'chronos_countdown_playlist_page');
	add_submenu_page( 'chronos_countdown', 'CHRONOS-COUNTDOWN Help', 'Help', 'edit_posts', 'chronos_countdown_Help', 'chronos_countdown_help_page');
}


//HTML content for overview page
function chronos_countdown_overview_page()
{
	global $chronos_countdown_path;
	include_once($chronos_countdown_path . 'tpl/overview.php');
}

//HTML content for Manage Banners
function chronos_countdown_manage_countdowns_page()
{
	global $wpdb;
	global $chronos_countdown_messages;
	global $chronos_countdown_path;

	//delete countdown
	if (isset($_GET['id'])) {

		//delete from wp_chronos_countdown_countdowns
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."chronos_countdown_countdowns WHERE id = %d",$_GET['id']));

		//delete from wp_chronos_countdown_settings
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."chronos_countdown_settings WHERE id = %d",$_GET['id']));

		//delete from wp_chronos_countdown_playlist
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."chronos_countdown_playlist WHERE countdownid = %d",$_GET['id']));

		//initialize the session
		$safe_sql="SELECT * FROM (".$wpdb->prefix ."chronos_countdown_countdowns) ORDER BY id";
		$row = $wpdb->get_row($safe_sql,ARRAY_A);
		$row=chronos_countdown_unstrip_array($row);
		if ($row['id']) {
			$_SESSION['xid']=$row['id'];
			$_SESSION['xname']=$row['name'];
		}
	}

	if (array_key_exists('duplicate_id', $_GET) && $_GET['duplicate_id']!='') {
			//countdowns
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."chronos_countdown_countdowns ( `name` ) SELECT `name` FROM (".$wpdb->prefix ."chronos_countdown_countdowns) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);
			$countdownid=$wpdb->insert_id;

			//settings
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."chronos_countdown_settings ( `endDate_date`, `endDate_hours`, `endDate_minutes`, `endDate_seconds`, `servertime`, `enableMaintenanceMode`, `pageBgImage`, `pageBgYouTube`, `pageBgVimeo`, `pageBgMp4`, `pageBgAdditionalCss`, `texturePath`, `pluginFontFamily`, `pluginFontFamilyGoogleLink`, `elementWidth`, `elementHeight`, `elementBgColor`, `elementFontSize`, `elementFontColor`, `elementLabelFontSize`, `elementLabelColor`, `elementLabelTopPadding`, `elementsDotsSeparatorColor`, `countDownTopPadding`, `countDownBottomPadding`, `clockFace`, `language`, `videoProportionWidth`, `lineSeparatorImg`, `logo`, `logoLink`, `logoTarget`, `socialBgOFF`, `socialBgON`, `complete`, `autoReset24h`, `h2Text`, `h2Size`, `h2Color`, `h2Weight`, `h2TopMargin`, `h3Text`, `h3Size`, `h3Color`, `h3Weight`, `h3TopMargin`, `h4Text`, `h4Size`, `h4Color`, `h4Weight`, `h4TopMargin` ) SELECT `endDate_date`, `endDate_hours`, `endDate_minutes`, `endDate_seconds`, `servertime`, `enableMaintenanceMode`, `pageBgImage`, `pageBgYouTube`, `pageBgVimeo`, `pageBgMp4`, `pageBgAdditionalCss`, `texturePath`, `pluginFontFamily`, `pluginFontFamilyGoogleLink`, `elementWidth`, `elementHeight`, `elementBgColor`, `elementFontSize`, `elementFontColor`, `elementLabelFontSize`, `elementLabelColor`, `elementLabelTopPadding`, `elementsDotsSeparatorColor`, `countDownTopPadding`, `countDownBottomPadding`, `clockFace`, `language`, `videoProportionWidth`, `lineSeparatorImg`, `logo`, `logoLink`, `logoTarget`, `socialBgOFF`, `socialBgON`, `complete`, `autoReset24h`, `h2Text`, `h2Size`, `h2Color`, `h2Weight`, `h2TopMargin`, `h3Text`, `h3Size`, `h3Color`, `h3Weight`, `h3TopMargin`, `h4Text`, `h4Size`, `h4Color`, `h4Weight`, `h4TopMargin`  FROM (".$wpdb->prefix ."chronos_countdown_settings) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);

			//playlist
			$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."chronos_countdown_playlist) WHERE countdownid = %d",$_GET['duplicate_id'] );
			$result = $wpdb->get_results($safe_sql,ARRAY_A);
			foreach ( $result as $row_playlist ) {
				$row_playlist=chronos_countdown_unstrip_array($row_playlist);

				$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."chronos_countdown_playlist ( `countdownid` ,`img` ,`title` ,`data-link` ,`data-target` ,`ord` ) SELECT ".$countdownid." ,`img` ,`title` ,`data-link` ,`data-target` ,`ord` FROM (".$wpdb->prefix ."chronos_countdown_playlist) WHERE id = %d",$row_playlist['id'] );
				$wpdb->query($safe_sql);
				$photoid=$wpdb->insert_id;

			}



			//maintenance mode
			$safe_sql=$wpdb->prepare( "SELECT enableMaintenanceMode FROM (".$wpdb->prefix ."chronos_countdown_settings) WHERE id = %d",$_GET['duplicate_id'] );
			$row = $wpdb->get_row($safe_sql,ARRAY_A);
			$row=chronos_countdown_unstrip_array($row);
			if ($row['enableMaintenanceMode']=='true') {
				$wpdb->update(
					$wpdb->prefix .'chronos_countdown_settings',
					array( 'enableMaintenanceMode' => 'false' ),
					array( 'id' => $_GET['duplicate_id'] ),
					array( '%s' ),
					array( '%d' )
				);
			}

	}

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."chronos_countdown_countdowns) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($chronos_countdown_path . 'tpl/countdowns.php');

}


//HTML content for Manage Banners - Add New
function chronos_countdown_manage_countdowns_add_new_page()
{
	global $wpdb;
	global $chronos_countdown_messages;
	global $chronos_countdown_path;

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add New') {
		$errors_arr=array();
		if (empty($_POST['name']))
			$errors_arr[]=$chronos_countdown_messages['empty_name'];

		if (count($errors_arr)) {
				include_once($chronos_countdown_path . 'tpl/add_countdown.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		  	<?php } else { // no errors
					$wpdb->insert(
						$wpdb->prefix . "chronos_countdown_countdowns",
						array(
							'name' => sanitize_text_field($_POST['name'])
						),
						array(
							'%s'
						)
					);
					//insert default CountDown Settings for this new CountDown
					chronos_countdown_insert_settings_record($wpdb->insert_id);
					?>
						<div class="wrap">
							<div id="lbg_logo">
								<h2>Manage CountDowns - Add New CountDown</h2>
				 			</div>
							<div id="message" class="updated"><p><?php esc_html_e($chronos_countdown_messages['data_saved'], 'chronos-countdown' );?></p><p><?php esc_html_e($chronos_countdown_messages['generate_for_this_countdown'], 'chronos-countdown' );?></p></div>
							<div>
								<p>&raquo; <a href="?page=chronos_countdown_Add_New">Add New (CountDown)</a></p>
								<p>&raquo; <a href="?page=chronos_countdown_Manage_CountDowns">Back to Manage CountDowns</a></p>
							</div>
						</div>
		  	<?php }
	} else {
		include_once($chronos_countdown_path . 'tpl/add_countdown.php');
	}

}


//HTML content for countdownsettings
function chronos_countdown_settings_page()
{
	global $wpdb;
	global $chronos_countdown_messages;
	global $chronos_countdown_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Update Settings') {
		//maintenance mode
		if ($_POST['enableMaintenanceMode']=='true') {
			$wpdb->query("UPDATE ".$wpdb->prefix ."chronos_countdown_settings SET enableMaintenanceMode='false' WHERE 1 = 1");
		}

		$_GET['xmlf']='';
		$except_arr=array('Submit','name','pll_ajax_backend','page_scroll_to_id_instances');

			$wpdb->update(
				$wpdb->prefix .'chronos_countdown_countdowns',
				array(
				'name' => sanitize_text_field($_POST['name'])
				),
				array( 'id' => $_SESSION['xid'] )
			);
			$_SESSION['xname']=stripslashes($_POST['name']);


			foreach ($_POST as $key=>$val){
				if (in_array($key,$except_arr)) {
					unset($_POST[$key]);
				}
			}

			$wpdb->update(
				$wpdb->prefix .'chronos_countdown_settings',
				$_POST,
				array( 'id' => $_SESSION['xid'] )
			);
			?>
			<div id="message" class="updated"><p><?php esc_html_e($chronos_countdown_messages['data_saved'], 'chronos-countdown' );?></p></div>
	<?php
		chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
	}


	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."chronos_countdown_settings) WHERE id = %d",$_SESSION['xid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=chronos_countdown_unstrip_array($row);
	$_POST = $row;
	$_POST=chronos_countdown_unstrip_array($_POST);

	include_once($chronos_countdown_path . 'tpl/settings_form.php');

}

function chronos_countdown_playlist_page()
{
	global $wpdb;
	global $chronos_countdown_messages;
	global $chronos_countdown_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}


	if (array_key_exists('xmlf', $_GET) && $_GET['xmlf']=='add_playlist_record') {
		if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add Record') {
			$errors_arr=array();


		if (count($errors_arr)) {
			include_once($chronos_countdown_path . 'tpl/add_playlist_record.php'); ?>
			<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  	<?php } else { // no upload errors
				$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."chronos_countdown_playlist WHERE countdownid = %d",$_SESSION['xid'] ) );

				$wpdb->insert(
					$wpdb->prefix . "chronos_countdown_playlist",
					array(
						'countdownid' => sanitize_text_field($_POST['countdownid']),
						'img' => sanitize_text_field($_POST['img']),
						'title' => sanitize_text_field($_POST['title']),
						'data-link' => sanitize_text_field($_POST['data-link']),
						'data-target' => sanitize_text_field($_POST['data-target']),
						'ord' => sanitize_text_field($max_ord)
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%d'
					)
				);

	  			if (isset($_POST['setitfirst'])) {
					$sql_arr=array();
					$ord_start=$max_ord;
					$ord_stop=1;
					$elem_id=$wpdb->insert_id;
					$ord_direction='+1';

					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=ord+1  WHERE countdownid = %d and ord>=".$ord_stop." and ord<".$ord_start, $_SESSION['xid']);
					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=%d WHERE id=%d",$ord_stop,$elem_id);

					foreach ($sql_arr as $sql)
						$wpdb->query($sql);
				}
				?>
					<div class="wrap">
						<div id="lbg_logo">
							<h2>Social Channels for CountDown: <span style="color:#FF0000; font-weight:bold;"><?php echo strip_tags($_SESSION['xname'])?> - ID #<?php echo strip_tags($_SESSION['xid'])?></span> - Add New</h2>
			 			</div>
						<div id="message" class="updated"><p><?php esc_html_e($chronos_countdown_messages['data_saved'], 'chronos-countdown' );?></p></div>
						<div>
							<p>&raquo; <a href="?page=chronos_countdown_Playlist&xmlf=add_playlist_record">Add New</a></p>
							<p>&raquo; <a href="?page=chronos_countdown_Playlist">Back to Social Channels List</a></p>
						</div>
					</div>
	  	<?php
				chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
			}
		} else {
			include_once($chronos_countdown_path . 'tpl/add_playlist_record.php');
		}

	} else {
		if (array_key_exists('duplicate_id', $_GET) && $_GET['duplicate_id']!='') {
			$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."chronos_countdown_playlist WHERE countdownid = %d",$_SESSION['xid'] ) );
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."chronos_countdown_playlist ( `countdownid` ,`img` ,`title` , `data-link` ,`data-target` ,`ord` ) SELECT `countdownid` ,`img` ,`title` ,`data-link` ,`data-target` ,".$max_ord." FROM (".$wpdb->prefix ."chronos_countdown_playlist) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);
			$lastID=$wpdb->insert_id;

			chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
			echo "<script>location.href='?page=chronos_countdown_Playlist&id=".$_SESSION['xid']."&name=".$_SESSION['xname']."'</script>";
		}

		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."chronos_countdown_playlist) WHERE countdownid = %d ORDER BY ord",$_SESSION['xid'] );
		$result = $wpdb->get_results($safe_sql,ARRAY_A);

		include_once($chronos_countdown_path . 'tpl/playlist.php');
	}
}





function chronos_countdown_help_page()
{
	global $chronos_countdown_path;
	include_once($chronos_countdown_path . 'tpl/help.php');
}

function chronos_countdown_generate_preview_code($countdownID) {
	global $wpdb;

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."chronos_countdown_settings) WHERE id = %d",$countdownID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=chronos_countdown_unstrip_array($row);


	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."chronos_countdown_playlist) WHERE countdownid = %d ORDER BY ord",$countdownID );
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	$playlist_str='';
	foreach ( $result as $row_playlist ) {

		$row_playlist=chronos_countdown_unstrip_array($row_playlist);

		$img_over='';
		if ($row_playlist['img']!='') {
			if (strpos($row_playlist['img'], 'wp-content',9)===false)
				list($width, $height, $type, $attr) = getimagesize($row_playlist['img']);
			else
				list($width, $height, $type, $attr) = getimagesize( ABSPATH.substr($row_playlist['img'],strpos($row_playlist['img'], 'wp-content',9)) );
			$img_over='<img src="'.$row_playlist['img'].'" width="'.$width.'" height="'.$height.'" alt="'.$row_playlist['title'].'"  title="'.$row_playlist['title'].'" />';
		}


		$playlist_str.='<li><a href="'.$row_playlist['data-link'].'" target="'.$row_playlist['data-target'].'">'.$img_over.'</a></li>';

	}

	$currentY=date("Y");
	$currentM=date("n");
	$currentD=date("j");
	$currentH=date("H");
	$currentMin=date("i");
	$currentS=date("s");

	$servertime='';
	if ($row["servertime"]=='true') {
		$servertime=$currentY.','.$currentM.','.$currentD.','.$currentH.','.$currentMin.','.$currentS;
	}

	$the_logo='';
	if ($row["logo"]!='') {
		$the_logo='<div class="logoDiv">'.(($row["logoLink"]!='')?'<a href="'.$row["logoLink"].'" target="'.$row["logoTarget"].'">':'').'<img src="'.$row["logo"].'" alt="logo" border="0" />'.(($row["logoLink"]!='')?'</a>':'').'</div>';
	}

	$the_h2='';
	if ($row["h2Text"]!='') {
		$the_h2='<h2>'.$row["h2Text"].'</h2>';
	}

	$the_h3='';
	if ($row["h3Text"]!='') {
		$the_h3='<h3>'.$row["h3Text"].'</h3>';
	}

	$the_h4='';
	if ($row["h4Text"]!='') {
		$the_h4='<h4>'.$row["h4Text"].'</h4>';
	}

	$the_social='';
	if ($playlist_str!='') {
		$the_social='<div class="socialIconsDiv">'
            .$the_h4.
			'<ul class="socialIcons">'.$playlist_str.'</ul>
		 </div>';
	}

	$the_bg='';
	if ($row["pageBgImage"]!='' || $row["pageBgYouTube"]!='' || $row["pageBgVimeo"]!='' || $row["pageBgMp4"]!='') {
			if ($row["pageBgImage"]!='') {
					if (strpos($row["pageBgImage"], 'wp-content')===false)
									list($width, $height, $type, $attr) = getimagesize($row["pageBgImage"]);
					else {
									if (strpos($row["pageBgImage"], 'http')===0) {
													list($width, $height, $type, $attr) = getimagesize($row["pageBgImage"]);
									} else {
													list($width, $height, $type, $attr) = getimagesize( ABSPATH.substr($row["pageBgImage"],strpos($row["pageBgImage"], 'wp-content')) );
									}
					}

					$the_bg='<img class="chronos_countdown_backgroundImage" src="'.$row["pageBgImage"].'" alt="" width="'.$width.'" height="'.$height.'" style="width:'.$width.'px; height:'.$height.'px;" />';
			}
			if ($row["pageBgYouTube"]!='') {
					$the_bg='<div class="setAsBg"><iframe width="100%" height="100%" src="https://www.youtube.com/embed/'.$row["pageBgYouTube"].'?autoplay=1&cc_load_policy=1&rel=0&loop=1&playlist='.$row["pageBgYouTube"].'&controls=0&showinfo=0&playsinline=1&webkit-playsinline=1&background=1&mute=1" frameborder="0"></iframe></div>';
			}
			if ($row["pageBgVimeo"]!='') {
					$the_bg='<div class="setAsBg"><iframe src="https://player.vimeo.com/video/'.$row["pageBgVimeo"].'?title=0&amp;byline=0&amp;portrait=0&amp;autoplay=1&amp;loop=1&amp;background=1" width="100%" height="100%" frameborder="0"></iframe></div>';
			}
			if ($row["pageBgMp4"]!='') {
					$the_bg='<div class="setAsBg"><video id="chronos_countdown_backgroundVideo" src="'.$row["pageBgMp4"].'" loop playsinline autoplay muted>Your browser does not support the video tag.</video>
					</div>';
			}

	}
	$the_launchingDate=$row["endDate_date"].','.$row["endDate_hours"].','.$row["endDate_minutes"].','.$row["endDate_seconds"];
	if (strpos(get_site_url(),'lambertgroupproductions.com')!=false) {
		$new_currentY=$currentY;
		$new_currentM=$currentM;
		if ($new_currentM==12) {
			$new_currentM=1;
			$new_currentY++;
		} else {
			$new_currentM++;
		}
		$the_launchingDate=$new_currentY.','.$new_currentM.',15,'.$row["endDate_hours"].','.$row["endDate_minutes"].','.$row["endDate_seconds"];
	}

	$str_to_return='<link href="'.$row["pluginFontFamilyGoogleLink"].'" rel="stylesheet" type="text/css">
	<script>
		jQuery(function() {
			jQuery("#chronos_countdown_'.$row["id"].'").chronos_countdown({
				launchingDate:"'.$the_launchingDate.'",
				nowDate:"'.$servertime.'",
				pluginFontFamily:"'.$row["pluginFontFamily"].'",
				pluginFontFamilyGoogleLink:"'.$row["pluginFontFamilyGoogleLink"].'",
				textureOverBg:"'.$row["texturePath"].'",
				lineSeparatorImg:"'.$row["lineSeparatorImg"].'",
				elementWidth:'.$row["elementWidth"].',
				elementHeight:'.$row["elementHeight"].',
				elementBgColor:"#'.$row["elementBgColor"].'",
				elementFontSize:'.$row["elementFontSize"].',
				elementFontColor:"#'.$row["elementFontColor"].'",
				elementLabelFontSize:'.$row["elementLabelFontSize"].',
				elementLabelColor:"#'.$row["elementLabelColor"].'",
				elementLabelTopPadding:'.$row["elementLabelTopPadding"].',
				elementsDotsSeparatorColor:"#'.$row["elementsDotsSeparatorColor"].'",
				countDownTopPadding:'.$row["countDownTopPadding"].',
				countDownBottomPadding:'.$row["countDownBottomPadding"].',
				clockFace:"'.$row["clockFace"].'",
				language:"'.$row["language"].'",
				videoProportionWidth:'.$row["videoProportionWidth"].',
				socialBgOFF:"'.$row["socialBgOFF"].'",
				socialBgON:"'.$row["socialBgON"].'",
				complete:'.(($row["complete"]!='')?$row["complete"]:'""').',
				autoReset24h:'.$row["autoReset24h"].',
				h2Size:'.$row["h2Size"].',
				h2Color:"#'.$row["h2Color"].'",
				h2Weight:"'.$row["h2Weight"].'",
				h2TopMargin:'.$row["h2TopMargin"].',
				h3Size:'.$row["h3Size"].',
				h3Color:"#'.$row["h3Color"].'",
				h3Weight:"'.$row["h3Weight"].'",
				h3TopMargin:'.$row["h3TopMargin"].',
				h4Size:'.$row["h4Size"].',
				h4Color:"#'.$row["h4Color"].'",
				h4Weight:"'.$row["h4Weight"].'",
				h4TopMargin:'.$row["h4TopMargin"].'
			});
		});
	</script>
    <div id="chronos_countdown_'.$row["id"].'">'.$the_logo.$the_h2.$the_h3.
                '<div class="chronos_countdown_clock" ></div>'
		 .$the_social.$the_bg.'
		 <div class="texture_over_bg"></div>
	</div>';
	return str_replace("\r\n", '', $str_to_return);
}


function chronos_countdown_shortcode($atts, $content=null) {
	global $wpdb;

	shortcode_atts( array('settings_id'=>''), $atts);
	if ($atts['settings_id']=='')
		$atts['settings_id']=1;

	return chronos_countdown_generate_preview_code($atts['settings_id']);

}

function chronos_countdown_plugin_redirect()
{
	global $wpdb;
	if(!is_admin()){
		if(!is_user_logged_in()) {
			$safe_sql="SELECT id,enableMaintenanceMode,servertime FROM (".$wpdb->prefix ."chronos_countdown_settings)";
			$result = $wpdb->get_results($safe_sql,ARRAY_A);
			foreach ( $result as $row ) {
				if ($row['enableMaintenanceMode']=='true') {
					if ($row['servertime']=="true") {
						chronos_countdown_writePreviewAndMaintenanceFile($row['id'],'tpl/maintenance_mode.html');
					}
					include(plugin_dir_path(__FILE__).'tpl/maintenance_mode.html');
					exit();
				}
			}
		}
	}
}


register_activation_hook(__FILE__,"chronos_countdown_activate"); //activate plugin and create the database
add_action('init', 'chronos_countdown_init_sessions');	// initialize sessions
add_action('init', 'chronos_countdown_load_styles');	// loads required styles
add_action('init', 'chronos_countdown_load_scripts');			// loads required scripts
add_action('admin_menu', 'chronos_countdown_plugin_menu'); // create menus
add_shortcode('chronos_countdown', 'chronos_countdown_shortcode');				// CHRONOS-COUNTDOWN shortcode
add_action( 'template_redirect', 'chronos_countdown_plugin_redirect');


/** OTHER FUNCTIONS **/

//stripslashes for an entire array
function chronos_countdown_unstrip_array($array){
	if (is_array($array)) {
		foreach($array as &$val){
			if(is_array($val)){
				$val = unstrip_array($val);
			} else {
				$val = stripslashes($val);

			}
		}
	}
	return $array;
}


/* ajax update playlist record */

add_action('admin_head', 'chronos_countdown_update_playlist_record_javascript');

function chronos_countdown_update_playlist_record_javascript() {
	global $wpdb;
	//Set Your Nonce
	$chronos_countdown_update_playlist_record_ajax_nonce = wp_create_nonce("chronos_countdown_update_playlist_record-special-string");
	$chronos_countdown_preview_record_ajax_nonce = wp_create_nonce("chronos_countdown_preview_record-special-string");

	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/chronos_countdown/i', $page)) {
?>




<script type="text/javascript" >

//delete the entire record
function chronos_countdown_delete_entire_record (delete_id) {
	if (confirm('Are you sure?')) {
		jQuery("#chronos_countdown_sortable").sortable('disable');
		jQuery("#"+delete_id).css("display","none");
		jQuery("#chronos_countdown_updating_witness").css("display","block");
		var data = "action=chronos_countdown_update_playlist_record&security=<?php echo esc_js($chronos_countdown_update_playlist_record_ajax_nonce); ?>&updateType=chronos_countdown_delete_entire_record&delete_id="+delete_id;
		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			jQuery("#chronos_countdown_sortable").sortable('enable');
			jQuery("#chronos_countdown_updating_witness").css("display","none");
		});
	}
}




function chronos_countdown_process_val(val,cssprop) {
	retVal=parseInt(val.substring(0, val.length-2));
	if (cssprop=="top")
		retVal=retVal-148;
	return retVal;
}



function chronos_countdown_showDialogPreview(theCountDownID) {  //load content and open dialog
	var data ="action=chronos_countdown_preview_record&security=<?php echo esc_js($chronos_countdown_preview_record_ajax_nonce); ?>&theCountDownID="+theCountDownID;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		jQuery('#previewDialogIframe').attr('src','<?php echo plugins_url("tpl/preview.html?d=".time(), __FILE__)?>');
		jQuery("#previewDialog").dialog("open");
	});
}



jQuery(document).ready(function($) {
	/*PREVIEW DIALOG BOX*/
	jQuery( "#previewDialog" ).dialog({
	  minWidth:1200,
	  minHeight:500,
	  title:"CountDown Preview",
	  modal: true,
	  autoOpen:false,
	  hide: "fade",
	  resizable: false,
	  open: function() {
	  },
	  close: function() {
		jQuery('#previewDialogIframe').attr('src','');
	  }
	});

	/* THE PLAYLIST */
	if (jQuery('#chronos_countdown_sortable').length) {
		jQuery( '#chronos_countdown_sortable' ).sortable({
			placeholder: "ui-state-highlight",
			start: function(event, ui) {
	            ord_start = ui.item.prevAll().length + 1;
	        },
			update: function(event, ui) {
	        	jQuery("#chronos_countdown_sortable").sortable('disable');
	        	jQuery("#chronos_countdown_updating_witness").css("display","block");
				var ord_stop=ui.item.prevAll().length + 1;
				var elem_id=ui.item.attr("id");
				var data = "action=chronos_countdown_update_playlist_record&security=<?php echo esc_js($chronos_countdown_update_playlist_record_ajax_nonce); ?>&updateType=change_ord&ord_start="+ord_start+"&ord_stop="+ord_stop+"&elem_id="+elem_id;
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
					jQuery("#chronos_countdown_sortable").sortable('enable');
					jQuery("#chronos_countdown_updating_witness").css("display","none");
				});
			}
		});
	}



	<?php
		$rows_count = $wpdb->get_var( $wpdb->prepare("SELECT COUNT(*) FROM ". $wpdb->prefix . "chronos_countdown_playlist WHERE countdownid = %d ORDER BY ord",$_SESSION['xid'] ) );
		for ($i=1;$i<=$rows_count;$i++) {
	?>
				jQuery('#upload_img_button_chronos_countdown_<?php echo esc_js($i)?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							document.forms["form-playlist-chronos_countdown-"+<?php echo esc_js($i)?>].img.value=attachment.url;
							jQuery('#img_'+<?php echo esc_js($i)?>).attr('src',attachment.url);
						});
						// Finally, open the modal
						file_frame.open();
				});




	jQuery("#form-playlist-chronos_countdown-<?php echo esc_js($i)?>").submit(function(event) {

		/* stop form from submitting normally */
		event.preventDefault();

		//show loading image
		jQuery('#ajax-message-<?php echo esc_js($i)?>').html('<img src="<?php echo plugins_url('chronos_countdown/images/ajax-loader.gif', dirname(__FILE__))?>" />');
		var data ="action=chronos_countdown_update_playlist_record&security=<?php echo esc_js($chronos_countdown_update_playlist_record_ajax_nonce); ?>&"+jQuery("#form-playlist-chronos_countdown-<?php echo esc_js($i)?>").serialize();

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			var new_img = '';
			if (document.forms["form-playlist-chronos_countdown-<?php echo esc_js($i)?>"].img.value!='')
				new_img=document.forms["form-playlist-chronos_countdown-<?php echo esc_js($i)?>"].img.value;
			jQuery('#top_image_'+document.forms["form-playlist-chronos_countdown-<?php echo esc_js($i)?>"].id.value).attr('src',new_img);
			jQuery('#ajax-message-<?php echo esc_js($i)?>').html(response);
		});
	});
	<?php } ?>

});
</script>
<?php
		}
	}
}


add_action('wp_ajax_chronos_countdown_update_playlist_record', 'chronos_countdown_update_playlist_record_callback');

function chronos_countdown_update_playlist_record_callback() {

	check_ajax_referer( 'chronos_countdown_update_playlist_record-special-string', 'security' );
	global $wpdb;
	global $chronos_countdown_messages;
	$errors_arr=array();

	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='chronos_countdown_delete_entire_record') {
		$delete_id=$_POST['delete_id'];
		$safe_sql=$wpdb->prepare("SELECT * FROM ".$wpdb->prefix."chronos_countdown_playlist WHERE id = %d",$delete_id);
		$row = $wpdb->get_row($safe_sql, ARRAY_A);
		$row=chronos_countdown_unstrip_array($row);

		//delete the entire record
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."chronos_countdown_playlist WHERE id = %d",$delete_id));
		//update the order for the rest ord=ord-1 for > ord
		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=ord-1 WHERE countdownid = %d and  ord>".$row['ord'],$_SESSION['xid']));
		chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
	}

	//update elements order
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='change_ord') {
		$sql_arr=array();
		$ord_start=$_POST['ord_start'];
		$ord_stop=$_POST['ord_stop'];
		$elem_id=(int)$_POST['elem_id'];
		$ord_direction='+1';
		if ($ord_start<$ord_stop)
			$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=ord-1  WHERE countdownid = %d and ord>".$ord_start." and ord<=".$ord_stop, $_SESSION['xid']);
		else
			$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=ord+1  WHERE countdownid = %d and ord>=".$ord_stop." and ord<".$ord_start, $_SESSION['xid']);
		$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."chronos_countdown_playlist SET ord=%d WHERE id=%d", $ord_stop,$elem_id);

		foreach ($sql_arr as $sql) {
			$wpdb->query($sql);
		}

		chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
	}




	//submit update
	$theid=isset($_POST['id'])?$_POST['id']:0;
	if($theid>0 && !count($errors_arr)) {
		//update playlist
		$wpdb->update(
			$wpdb->prefix .'chronos_countdown_playlist',
				array(
				'img' => sanitize_text_field($_POST['img']),
				'title' => sanitize_text_field($_POST['title']),
				'data-link' => sanitize_text_field($_POST['data-link']),
				'data-target' => sanitize_text_field($_POST['data-target'])
				),
			array( 'id' => $theid )
		);


		chronos_countdown_writePreviewAndMaintenanceFile($_SESSION['xid'],'tpl/maintenance_mode.html');
		?>
			<div id="message" class="updated"><p><?php esc_html_e($chronos_countdown_messages['data_saved'], 'chronos-countdown' );?></p></div>
	<?php
	} else if (!isset($_POST['updateType'])) {
		$errors_arr[]=$chronos_countdown_messages['invalid_request'];
	}

	if (count($errors_arr)) { ?>
		<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	<?php }

	die(); // this is required to return a proper result
}





function chronos_countdown_writePreviewAndMaintenanceFile($theCountDownID,$theFileName) {
	global $wpdb;
	$safe_sql=$wpdb->prepare( "SELECT enableMaintenanceMode,pageBgAdditionalCss FROM (".$wpdb->prefix ."chronos_countdown_settings) WHERE id = %d",$theCountDownID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=chronos_countdown_unstrip_array($row);

	$aux_val='<html>
					<head>
			<link href="'.plugins_url('chronos_countdown/css/flipclock.css', __FILE__).'" rel="stylesheet" type="text/css">
			<link href="'.plugins_url('chronos_countdown/css/chronos_countdown.css', __FILE__).'" rel="stylesheet" type="text/css">


			<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.0.1/jquery.min.js" type="text/javascript"></script>
			<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/jquery-ui.min.js"></script>
			<script src="'.plugins_url('chronos_countdown/js/flipclock.min.js', __FILE__).'" type="text/javascript"></script>
			<script src="'.plugins_url('chronos_countdown/js/chronos_countdown.js', __FILE__).'" type="text/javascript"></script>
					</head>
					<body'.(($row['pageBgAdditionalCss']!='')?' style="'.$row['pageBgAdditionalCss'].';"':'').'>';

	$aux_val.=chronos_countdown_generate_preview_code($theCountDownID);
	$aux_val.="</body>
				</html>";
	$filename=plugin_dir_path(__FILE__) . $theFileName;
	if ($theFileName=='tpl/preview.html') {
		$fp = fopen($filename, 'w+');
		$fwrite = fwrite($fp, $aux_val);
	} else {
		if ($row['enableMaintenanceMode']=='true') {
			$fp = fopen($filename, 'w+');
			$fwrite = fwrite($fp, $aux_val);
		}
	}

}






add_action('wp_ajax_chronos_countdown_preview_record', 'chronos_countdown_preview_record_callback');

function chronos_countdown_preview_record_callback() {
	check_ajax_referer( 'chronos_countdown_preview_record-special-string', 'security' );

	chronos_countdown_writePreviewAndMaintenanceFile($_POST['theCountDownID'],'tpl/preview.html');

	die(); // this is required to return a proper result
}



?>
