<?php
namespace SabaiApps\Directories\Component\System\Helper;

use SabaiApps\Directories\Application;

class NoImageHelper
{
    protected $_defaultUrl;

    public function help(Application $application, $srcOnly = false)
    {
        if (!$url = $this->url($application)) {
            // 240x180 px transparent png
            $url = $application->Filter(
                'core_no_image_src',
                'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAPAAAAC0CAQAAAAAlWljAAABH0lEQVR42u3RAQ0AAAzCsOPf9HVAOglrTtPFAsACLMACLMACLMCABViABViABViAAQuwAAuwAAuwAAswYAEWYAEWYAEWYMACLMACLMACLMCABViABViABViABRiwAAuwAAuwAAswYAEWYAEWYAEWYMACLMACLMACLMACDFiABViABViABRiwAAuwAAuwAAuwAAMWYAEWYAEWYAEGLMACLMACLMACDFiABViABViABViAAQuwAAuwAAuwAAMWYAEWYAEWYAEGLMACLMACLMACLMCABViABViABViAAQuwAAuwAAuwAAswYAEWYAEWYAEWYMACLMACLMACLMCABViABViABViABRiwAAuwAAuwAAswYAEWYAEWYAEWYMACrNYe6J4AtdAWxOcAAAAASUVORK5CYII='
            );
        }

        return $srcOnly ? $url : '<img class="drts-no-image" src="' . $application->H($url) . '" alt="" />';
    }

    public function url(Application $application)
    {
        if (!isset($this->_defaultUrl)) {
            $this->_defaultUrl = $application->Filter('system_no_image_url', false);
        }
        return $this->_defaultUrl;
    }
}
