<?php
namespace SabaiApps\Directories\Component\Field\Widget;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Field\IField;

class CheckboxesWidget extends AbstractWidget
{
    protected function _fieldWidgetInfo()
    {
        return [
            'label' => __('Checkboxes', 'directories'),
            'field_types' => ['choice'],
            'accept_multiple' => true,
            'default_settings' => [
                'columns' => 3,
                'sort' => false,
                'popup' => false,
                'height' => 0,
            ],
        ];
    }

    public function fieldWidgetSettingsForm($fieldType, Entity\Model\Bundle $bundle, array $settings, array $parents = [], array $rootParents = [])
    {
        return [
            'columns'  => [
                '#type' => 'select',
                '#title' => __('Number of columns', 'directories'),
                '#options' => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 6 => 6, 12 => 12],
                '#default_value' => $settings['columns'],
            ],
            'popup' => [
                '#title' => __('Show option list in popup', 'directories'),
                '#type' => 'checkbox',
                '#default_value' => !empty($settings['popup']),
            ],
            'height' => [
                '#title' => __('Option list height', 'directories'),
                '#type' => 'slider',
                '#min_value' => 0,
                '#max_value' => 500,
                '#min_text' => __('Auto', 'directories'),
                '#field_suffix' => 'px',
                '#integer' => true,
                '#default_value' => $settings['height'],
                '#states' => [
                    'visible' => [
                        sprintf('[name="%s"]', $this->_application->Form_FieldName(array_merge($parents, ['columns']))) => ['value' => 1],
                        sprintf('[name="%s"]', $this->_application->Form_FieldName(array_merge($parents, ['popup']))) => ['type' => 'checked', 'value' => 1],
                    ],
                ],
            ],
            'sort' => [
                '#title' => __('Sort by label', 'directories'),
                '#type' => 'checkbox',
                '#default_value' => !empty($settings['sort']),
            ],
        ];
    }

    public function fieldWidgetForm(IField $field, array $settings, $value = null, Entity\Type\IEntity $entity = null, array $parents = [], $language = null)
    {
        $options = $this->_application->Field_ChoiceOptions($field, !empty($settings['sort']), $language);
        if (isset($value)) {
            $default_value = empty($value) ? null : array_values($value);
        } else {
            $default_value = empty($options['default']) ? null : $options['default']; 
        }
        $form = array(
            '#type' => 'checkboxes',
            '#options' => $options['options'],
            '#max_selection' => $field->getFieldMaxNumItems(),
            '#default_value' => $default_value,
            '#columns' => $settings['columns'],
        );
        if (!empty($settings['popup'])) {
            $form['#type'] = 'select';
            $form['#multiple'] = true;
            $form['#multiselect'] = true;
            $form['#multiselect_height'] = !empty($settings['height']) && $settings['columns'] == 1 ? $settings['height'] : 0;
            $form['#placeholder'] = sprintf(__('Select %s', 'directories'), $field->getFieldLabel());
        } else {
            if (!empty($options['icons'])) {
                $form['#option_no_escape'] = true;
                foreach (array_keys($form['#options']) as $value) {
                    $form['#options'][$value] = $this->_application->H($form['#options'][$value]);
                    if (!empty($options['icons'][$value])) {
                        $form['#options'][$value] = '<i class="fa-fw ' . $options['icons'][$value] . '"></i> ' . $form['#options'][$value];
                    }
                }
            }
        }
        
        return $form;
    }
}