<?php
/*
Plugin Name: Dominion
Plugin URI: https://codecanyon.net/
Description: WP Domain Checker with WPBakery Page Builder
Version: 1.2
Author: Fluent-Themes 
Author URI: https://codecanyon.net/user/fluent-themes
Text Domain: dominion
Domain Path: /languages
*/

#-----------------------------------------------------------------
# Required Functions
#-----------------------------------------------------------------

require_once 'modules/require_functions.php';
include_once 'modules/admin-functions.php';

if( !class_exists('Vc_Google_Fonts') ) {
	include_once('modules/google_fonts/google_fonts.php');
}

/**
 * Current Plugin Version
 */
if ( ! defined( 'DOMINION_PLUGIN_VERSION' ) ) {
	define( 'DOMINION_PLUGIN_VERSION', '1.0.0' );
}

//Load Plugin Text Domain
function dominion_load_textdomain() {
  load_plugin_textdomain( 'dominion', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'dominion_load_textdomain' );


#-----------------------------------------------------------------
# Heading Shortcode
#-----------------------------------------------------------------
require_once 'modules/headings/heading_1/heading_1_shortcodes.php';
require_once 'modules/headings/heading_2/heading_2_shortcodes.php';
require_once 'modules/headings/heading_3/heading_3_shortcodes.php';
require_once 'modules/headings/heading_4/heading_4_shortcodes.php';
require_once 'modules/headings/heading_5/heading_5_shortcodes.php';
require_once 'modules/headings/heading_6/heading_shortcodes.php';

#-----------------------------------------------------------------
# Domain Checker Functions
#-----------------------------------------------------------------
require_once 'modules/domain_search/domain_search_1/domain_checker.php';
require_once 'modules/domain_search/domain_search_2/domain_checker.php';
require_once 'modules/domain_search/domain_search_3/domain_checker.php';
require_once 'modules/domain_search/domain_search_4/domain_checker.php';
require_once 'modules/domain_search/domain_search_5/domain_checker.php';
require_once 'modules/domain_search/domain_search_6/domain_checker.php';
require_once 'modules/domain_search/domain_search_8/domain_checker.php';
require_once 'modules/domain_search/domain_search_9/domain_checker.php';
require_once 'modules/domain_search/domain_search_10/domain_checker.php';
require_once 'modules/domain_search/domain_search_11/domain_checker.php';
require_once 'modules/domain_search/domain_search_12/domain_checker.php';

#-----------------------------------------------------------------
# Domain Search Shortcode
#-----------------------------------------------------------------
require_once 'modules/domain_search/domain_search_1/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_2/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_3/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_4/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_5/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_6/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_7/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_8/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_9/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_10/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_11/doamin_search_shortcodes.php';
require_once 'modules/domain_search/domain_search_12/doamin_search_shortcodes.php';

// Register Jquery Scripts.
add_action( 'wp_enqueue_scripts', 'register_dominion_plugin_jquery' );
/**
 * Register style sheet.
 */
function register_dominion_plugin_jquery() {
	$bootstrap_switch = get_option( 'bootstrap_switch' );
	wp_enqueue_script( 'dominion-custom', plugins_url( 'the_dominion/modules/js/dominion-plugin-custom.js' ), array('jquery'), '1.0', true );
	wp_enqueue_script( 'animations', plugins_url( 'the_dominion/modules/js/animations/animations.min.js' ), array('jquery'), '2.1', true );
	if ($bootstrap_switch == 'bootstrap_on'){
	wp_enqueue_script( 'bootstrap', plugins_url( 'the_dominion/modules/js/bootstrap.min.js' ), array('jquery'), '3.6.6', true );
	}
	wp_enqueue_script( 'jQuery.appear', plugins_url( 'the_dominion/modules/js/animations/appear.min.js' ), array('jquery'), '1.0', true );
	if (wp_script_is( 'recaptchav2', 'registered')) {
       return;
	} else {
		wp_register_script('recaptchav2', '//www.google.com/recaptcha/api.js?onload=recaptchaCallback&render=explicit', array(), '2.0', 'true');	
	}
}

#-----------------------------------------------------------------
# Adding Styles in the theme for this plugin
#-----------------------------------------------------------------
// Register style sheet.
add_action( 'wp_enqueue_scripts', 'register_dominion_plugin_styles' );

/**
 * Register style sheet.
 */
function register_dominion_plugin_styles() {
	global $post;
	$bootstrap_switch = get_option( 'bootstrap_switch' );
	wp_enqueue_style( 'dominion-style', plugins_url( 'the_dominion/modules/css/style.css' ) );
	wp_enqueue_style( 'animations', plugins_url( 'the_dominion/modules/css/animations/animations.min.css' ) );
	if ($bootstrap_switch == 'bootstrap_on'){
	wp_enqueue_style( 'bootstrap', plugins_url( 'the_dominion/modules/css/bootstrap.min.css' ) );
	}

#-----------------------------------------------------------------
# Heading Css
#-----------------------------------------------------------------
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_1') ) {
		wp_enqueue_style( 'dominion-heading-1-css', plugins_url( 'the_dominion/modules/headings/heading_1/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_2') ) {
		wp_enqueue_style( 'dominion-heading-2-css', plugins_url( 'the_dominion/modules/headings/heading_2/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_3') ) {
		wp_enqueue_style( 'dominion-heading-3-css', plugins_url( 'the_dominion/modules/headings/heading_3/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_4') ) {
		wp_enqueue_style( 'dominion-heading-4-css', plugins_url( 'the_dominion/modules/headings/heading_4/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_5') ) {
		wp_enqueue_style( 'dominion-heading-5-css', plugins_url( 'the_dominion/modules/headings/heading_5/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_heading_6') ) {
		wp_enqueue_style( 'dominion-heading-6-css', plugins_url( 'the_dominion/modules/headings/heading_6/css/style.css' ) );
	}

#-----------------------------------------------------------------
# Domain Search CSS
#-----------------------------------------------------------------
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_1') ) {
		wp_enqueue_style( 'dominion-domain-search-1-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_1/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_2') ) {
		wp_enqueue_style( 'dominion-domain-search-2-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_2/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_3') ) {
		wp_enqueue_style( 'dominion-domain-search-3-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_3/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_4') ) {
		wp_enqueue_style( 'dominion-domain-search-4-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_4/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_5') ) {
		wp_enqueue_style( 'dominion-domain-search-5-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_5/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_6') ) {
		wp_enqueue_style( 'dominion-domain-search-6-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_6/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_7') ) {
		wp_enqueue_style( 'dominion-domain-search-7-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_7/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_8') ) {
		wp_enqueue_style( 'dominion-domain-search-8-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_8/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_9') ) {
		wp_enqueue_style( 'dominion-domain-search-9-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_9/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_10') ) {
		wp_enqueue_style( 'dominion-domain-search-10-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_10/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_11') ) {
		wp_enqueue_style( 'dominion-domain-search-11-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_11/css/style.css' ) );
	}
	if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'dominion_shortcodes_domain_search_12') ) {
		wp_enqueue_style( 'dominion-domain-search-12-css', plugins_url( 'the_dominion/modules/domain_search/domain_search_12/css/style.css' ) );
	}
}

/*All Recaptcha functions below*/
function dominion_url_get_contents($Url) {
    if (!function_exists('curl_init')){ 
        die('CURL is not installed!');
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $Url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

function dominion_handle_recaptcha() {
?>
	<script type="text/javascript">
	var recaptchaCallback = function() {

		var forms = document.getElementsByTagName('form');
		var pattern = /(^|\s)g-recaptcha(\s|$)/;
		for (var i = 0; i < forms.length; i++) {
			var divs = forms[i].getElementsByTagName('div');
			for (var j = 0; j < divs.length; j++) {
				var sitekey = divs[j].getAttribute('data-sitekey');
				if (divs[j].className && divs[j].className.match(pattern) && sitekey) {
						grecaptcha.render(divs[j], {
						'sitekey': sitekey,
						'theme': divs[j].getAttribute('data-theme'),
						'type': divs[j].getAttribute('data-type'),
						'size': divs[j].getAttribute('data-size'),
						'tabindex': divs[j].getAttribute('data-tabindex'),
						'callback': divs[j].getAttribute('data-callback'),
						'expired-callback': divs[j].getAttribute('data-expired-callback')
					});
					break;
				}
			}
		}
	}	

	</script>
<?php
}