<?php
/* -----------------------------------------------------------------------------
 * Extra Settings in Settings > Design Settings Page
 * -------------------------------------------------------------------------- */
add_action('admin_enqueue_scripts', 'dominion_custom_admin_css'); // add css to admin page
function dominion_custom_admin_css() {
	wp_enqueue_style( 'dominion-animations-new', plugins_url( 'the_dominion/modules/css/dominion-admin-style.css' ) );
}

add_action('admin_menu', 'dominion_about_settings_submenu_page');
function dominion_about_settings_submenu_page() {
    add_submenu_page(
        'options-general.php',
        'Dominion Domain Checker',
        'Dominion Domain Checker',
        'manage_options',
        'dominion-about',
        'dominion_about_submenu_page_callback' );
}

function dominion_about_submenu_page_callback() {

//must check that the user has the required permission 
    if (!current_user_can('manage_options'))
    {
      wp_die( esc_html__('You do not have sufficient permissions to access this page.', 'dominion') );
    }

    // variables for the field and option names 
    $data_field_name = 'bootstrap_switch';

    // Read in existing option value from database
    $design_opt_val = get_option( $data_field_name );

    if( isset($_POST[ $data_field_name ])) {
        // Read their posted value
        $design_opt_val = $_POST[ $data_field_name ];

        // Save the posted value in the database
        update_option( $data_field_name, $design_opt_val );

        // Put a "settings saved" message on the screen
?>
<div class="updated">
	<p><strong><?php esc_html_e('Settings saved.', 'dominion' ); ?></strong></p>
</div>
<?php } ?>
<div class="wrap panto-page-welcome about-wrap">
	<h1 class="title"><?php echo sprintf( esc_html__( 'Welcome to Dominion - Version %s', 'dominion' ), preg_replace( '/^(\d+)(\.\d+)?(\.\d)?/', '$1$2', DOMINION_PLUGIN_VERSION ) ) ?></h1>
	<div class="about-text"><?php esc_html_e('Congratulations! You are about to use most powerful plugin for Domain Checker.', 'dominion') ?></div>
	<div class="wp-badge vc-page-logo"><?php esc_html_e('Version ', 'dominion');?><?php echo DOMINION_PLUGIN_VERSION; ?></div>
	<hr />
	<form method="post" action="">
		<p class="p_radio_options">
		<input type="radio" name="<?php echo esc_attr($data_field_name); ?>" value="<?php esc_attr_e('bootstrap_on', 'dominion'); ?>" <?php if($design_opt_val=='bootstrap_on'){echo 'checked';} ?>> <?php echo esc_html_e('Bootstrap ON', 'dominion'); ?><br>
		<input type="radio" name="<?php echo esc_attr($data_field_name); ?>" value="<?php esc_attr_e('bootstrap_off', 'dominion'); ?>" <?php if(($design_opt_val=='bootstrap_off') || (!$design_opt_val)){echo 'checked';} ?>> <?php echo esc_html_e('Bootstrap OFF (Default)', 'dominion'); ?>
		</p>

		<p class="submit">
		<input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('Save Changes', 'dominion') ?>" />
		</p>
		<div class="clear"></div>
	</form>
</div>
<?php
}