<?php
/*-----------------------------------------------------------------------------------*/
/* Start Using dominion Shortcodes in the Visual Composer */
/*-----------------------------------------------------------------------------------*/
add_action( 'init', 'dominion_domain_search_10_vc_shortcodes' );
function dominion_domain_search_10_vc_shortcodes() {
/****************
Domain Search - 8
****************/
vc_map( array(
      "name" => esc_html__("FT- Domain Search - 8", 'dominion'),
      "base" => "dominion_shortcodes_domain_search_10",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'dominion'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Displays Domain Search - 8', 'dominion'),
      "params" => array(
		  array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Parallax Image", 'dominion'),
            "param_name" => "image_one",
            "value" => '',
            "description" => esc_html__('Attach image.', 'dominion'),
         ),
		array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Title", 'dominion'),
            "param_name" => "title",
            "value" => '',
            "description" => esc_html__('Title', 'dominion')
         ),
		 array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Title Tag", 'dominion'),			
			"param_name" => "title_tag",
			"value" => 
				array(						   
					esc_html__('Default', 'dominion')=>'h3',
					esc_html__('H1', 'dominion')=>'h1',
					esc_html__('H2', 'dominion')=>'h2',			   			   
					esc_html__('H3', 'dominion')=>'h3',			   			   
					esc_html__('H4', 'dominion')=>'h4',			   			   
					esc_html__('H5', 'dominion')=>'h5',
					esc_html__('H6', 'dominion')=>'h6',			   			   
					esc_html__('Div', 'dominion')=>'div',			   			   
					esc_html__('P', 'dominion')=>'p',			   			   
					esc_html__('Span', 'dominion')=>'span' 
				)		
		),
		array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Sub Title", 'dominion'),
            "param_name" => "sub_title",
            "value" => '',
            "description" => esc_html__('Sub Title', 'dominion')
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Search Field Place Holder Text", 'dominion'),
            "param_name" => "search_pholder",
            "value" => '',
            "description" => esc_html__('Example place holder: Enter your Domain Name Here.', 'dominion')
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Search Button Label", 'dominion'),
            "param_name" => "button_label",
            "value" => '',
            "description" => esc_html__('Example: Search', 'dominion')
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Switch On Transfer Domain (for WHMCS only)", 'dominion'),
            "param_name" => "transfer_true",
			"value" => array(
				  "" => "false"
			   ),
			"description" => esc_html__("Check if you want to use this form as Transfer Domain form with WHMCS", 'dominion'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Search Action URL", 'dominion'),
            "param_name" => "search_action_url",
            "value" => '',
            "description" => esc_html__('Use this field, if you do not want Ajax Search to Work and the Ajax Search option is switched off. YOUR_WHMCS_SITE_URL/cart.php?a=add&domain=register&query=', 'dominion')
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Enable Ajax Domain Search", 'dominion'),
            "param_name" => "ajax_search",
			"value" => array(
				  "" => "true"
			   ),
			"description" => esc_html__("It will show the Domain Search result below the Search Form.", 'dominion'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Drop-Down Options (Example: .com)", 'dominion'),
            "param_name" => "domain",
            "description" => esc_html__('Start each option on new line','dominion')
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Ajax Search Purchase Button Label", 'dominion'),
            "param_name" => "purchase_btn_name",
            "value" => '',
            "description" => esc_html__('Example: Buy Now Or Purchase Now', 'dominion')
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Ajax Search Purchase Button URL", 'dominion'),
            "param_name" => "purchase_btn_url",
            "value" => '',
            "description" => esc_html__('The URL of the page where users can Purchase this domain', 'dominion')
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Enable Google reCAPTCHA v2", 'dominion'),
            "param_name" => "recaptcha",
			"value" => array(
				  "" => "false"
			   ),
			"description" => esc_html__("reCAPTCHA can work with Ajax search only. You need to have your Google reCAPTCHA v2 site key to use Google reCAPTCHA v2.", 'dominion'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Google reCAPTCHA v2 Site Key", 'dominion'),
            "param_name" => "recaptcha_sitekey",
            "value" => '',
            "description" => esc_html__('Input your Google reCAPTCHA v2 site key. You can get a key from here: ', 'dominion').''.esc_url('https://www.google.com/recaptcha/admin/create').''
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Google reCAPTCHA v2 Server Side Key", 'dominion'),
            "param_name" => "recaptcha_serversidekey",
            "value" => '',
            "description" => esc_html__('Input your Google reCAPTCHA v2 Server Side key. You can get a key from here: ', 'dominion').''.esc_url('https://www.google.com/recaptcha/admin/create').''
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Crossed Shaped Section Top", 'dominion'),
            "param_name" => "crossed_top",
			"value" => array(
				  "" => "false"
			   ),
			"description" => '',
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Crossed Shaped Section Bottom", 'dominion'),
            "param_name" => "crossed_bottom",
			"value" => array(
				  "" => "false"
			   ),
			"description" => '',
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Width of Domain Input Field for Desktop", 'dominion'),
            "param_name" => "input_width",
            "value" => '',
            "description" => esc_html__('Example: 420px', 'dominion')
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Width of Domain Input Field for Mobile and Tabs", 'dominion'),
            "param_name" => "input_width_mobile",
            "value" => '',
            "description" => esc_html__('Example: 220px', 'dominion')
         ),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Want to make this feature Animated?", 'dominion'),
            "param_name" => "animate",
			"std"		=> "no",
			"value" => array(
				  "Yes" => "yes"
			   ),
			"description" => '',
         ),
		 array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Animation Style", 'dominion'),			
			"param_name" => "animation_style",
			'dependency' => array(
				 'element' => 'animate',
				 'value' =>'yes',
			 ),
			"value" => 
				array(						   
					esc_html__('Fade In', 'dominion')=>'fade-in',
					esc_html__('Fade In Left', 'dominion')=>'fade-in-left',
					esc_html__('Fade In Left Big', 'dominion')=>'fade-in-left-big',
					esc_html__('Fade In Right', 'dominion')=>'fade-in-right',			   			   
					esc_html__('Fade In Right Big', 'dominion')=>'fade-in-right-big',			   			   
					esc_html__('Fade In Up', 'dominion')=>'fade-in-up',			   			   
					esc_html__('Fade In Up Big', 'dominion')=>'fade-in-up-big',			   			   
					esc_html__('Fade In Down', 'dominion')=>'fade-in-down',
					esc_html__('Fade In Down Big', 'dominion')=>'fade-in-down-big',
					esc_html__('Bounce In', 'dominion')=>'bounce-in',
					esc_html__('Bounce In Left', 'dominion')=>'bounce-in-left',
					esc_html__('Bounce In Right', 'dominion')=>'bounce-in-right',			   			   
					esc_html__('Bounce In Up', 'dominion')=>'bounce-in-up',			   			   
					esc_html__('Bounce In Down', 'dominion')=>'bounce-in-down',
					esc_html__('Flip In X', 'dominion')=>'flip-in-x',
					esc_html__('Flip In Y', 'dominion')=>'flip-in-y',
					esc_html__('Light Speed In', 'dominion')=>'light-speed-in',
					esc_html__('Rotate In', 'dominion')=>'rotate-in',
					esc_html__('Rotate In Left', 'dominion')=>'rotate-in-left',
					esc_html__('Rotate In Right', 'dominion')=>'rotate-in-right',			   			   
					esc_html__('Rotate In Up', 'dominion')=>'rotate-in-up',			   			   
					esc_html__('Rotate In Down', 'dominion')=>'rotate-in-down',
					esc_html__('Roll In', 'dominion')=>'roll-in',
					esc_html__('Zoom In', 'dominion')=>'zoom-in',
					esc_html__('Zoom In Left', 'dominion')=>'zoom-in-left',
					esc_html__('Zoom In Right', 'dominion')=>'zoom-in-right',			   			   
					esc_html__('Zoom In Up', 'dominion')=>'zoom-in-up',			   			   
					esc_html__('Zoom In Down', 'dominion')=>'zoom-in-down',
					esc_html__('Slide In Left', 'dominion')=>'slide-in-left',
					esc_html__('Slide In Right', 'dominion')=>'slide-in-right',			   			   
					esc_html__('Slide In Up', 'dominion')=>'slide-in-up',			   			   
					esc_html__('Slide In Down', 'dominion')=>'slide-in-down',
					esc_html__('Top To Bottom', 'dominion')=>'top-to-bottom',
					esc_html__('Bottom To Top', 'dominion')=>'bottom-to-top',
					esc_html__('Left To Right', 'dominion')=>'left-to-right',
					esc_html__('Right To Left', 'dominion')=>'right-to-left',
					esc_html__('Appear from center', 'dominion')=>'appear'
				)		
		),
		 array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Animate Delay Time", 'dominion'),            
			"param_name" => "anim_delay",
			'dependency' => array(
				 'element' => 'animate',
				 'value' =>'yes',
			 ),
			"description" => esc_html__( "Insert delay time  (e.g 100)", 'dominion' ),
		),
		 array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Unique Class Name (Required)", 'dominion'),            
			"param_name" => "unique_class_name",
			"group" => esc_html__( "Color Options", 'dominion' ),
			"description" => esc_html__( "Insert a unique class name to use color features  (e.g unique_cls_1)", 'dominion' ),
		),
		array(
			'type' => 'google_fonts',
			"heading" => esc_html__("Title Font Options", 'dominion'),
			'param_name' => 'title_font_family',
			"group" => esc_html__( "Font Options", 'dominion' ),            
			'value' => 'font_family:Open%20Sans|font_style:normal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select Font Family.', 'dominion' ),
					'font_style_description' => esc_html__( 'Select Font Style.', 'dominion' ),
				)
			)                   
		),			 		 		 	
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Title Font Size", 'dominion'),     
			"param_name" => "title_font_size", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => esc_html__( "Insert title font size (e.g 22px)", 'dominion' ),
		),	
		array(   
			"type" => "dropdown",         
			"class" => "",      
			"heading" => esc_html__("Title Font Weight", 'dominion'),	
			"param_name" => "title_font_weight",
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"value" => 
			array(			
				esc_html__('Choose font weight', 'dominion')=>'300',
				esc_html__('300', 'dominion')=>'300',
				esc_html__('400', 'dominion')=>'400',		
				esc_html__('500', 'dominion')=>'500',			
				esc_html__('600', 'dominion')=>'600',	
				esc_html__('700', 'dominion')=>'700',	
				esc_html__('800', 'dominion')=>'800',		
				esc_html__('900', 'dominion')=>'900'     
			)	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Title Line Height", 'dominion'),     
			"param_name" => "title_line_height", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => esc_html__( "Insert line height (e.g 22px)", 'dominion' ),
		),
		array(
			'type' => 'google_fonts',
			"heading" => esc_html__("Sub Title Font Options", 'dominion'),
			'param_name' => 'sub_title_font_family',
			"group" => esc_html__( "Font Options", 'dominion' ),            
			'value' => 'font_family:Open%23Sans|font_style:normal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select Font Family.', 'dominion' ),
					'font_style_description' => esc_html__( 'Select Font Style.', 'dominion' ),
				)
			)                   
		),			 		 		 	
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Sub Title Font Size", 'dominion'),     
			"param_name" => "sub_title_font_size", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => esc_html__( "Insert client_name font size (e.g 22px)", 'dominion' ),
		),	
		array(   
			"type" => "dropdown",         
			"class" => "",      
			"heading" => esc_html__("Sub Title Font Weight", 'dominion'),	
			"param_name" => "sub_title_font_weight",
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"value" => 
			array(			
				esc_html__('Choose font weight', 'dominion')=>'300',
				esc_html__('300', 'dominion')=>'300',
				esc_html__('400', 'dominion')=>'400',		
				esc_html__('500', 'dominion')=>'500',			
				esc_html__('600', 'dominion')=>'600',	
				esc_html__('700', 'dominion')=>'700',	
				esc_html__('800', 'dominion')=>'800',		
				esc_html__('900', 'dominion')=>'900'     
			)	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Sub Title Line Height", 'dominion'),     
			"param_name" => "sub_title_line_height", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => esc_html__( "Insert line height (e.g 22px)", 'dominion' ),
		),
		array(          
			"type" => "colorpicker",  
			"class" => "",     
			"heading" => esc_html__("Choose Title Color", 'dominion'),	
			"param_name" => "title_color",
			"group" => esc_html__( "Color Options", 'dominion' ), 
			"value" => '',       
			"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array( 
			"type" => "colorpicker", 
			"class" => "",            
			"heading" => esc_html__("Sub Title Color", 'dominion'),			
			"param_name" => "sub_title_color", 
			"group" => esc_html__( "Color Options", 'dominion' ),
			"value" => '',            
			"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')		
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Input Box Text Color", 'dominion'),	
		"param_name" => "input_text_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Input Box Placeholder Color", 'dominion'),	
		"param_name" => "input_placeholder_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Input Box Background Color", 'dominion'),	
		"param_name" => "input_bg_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Button Text Color", 'dominion'),	
		"param_name" => "button_text_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Button Text Hover Color", 'dominion'),	
		"param_name" => "button_text_hover_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Button Background Color", 'dominion'),	
		"param_name" => "button_bg_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Button Background Hover Color", 'dominion'),	
		"param_name" => "button_bg_hover_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Domain Available Result Text Color", 'dominion'),	
		"param_name" => "result_positive_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Domain NOT Available Result Text Color", 'dominion'),	
		"param_name" => "result_negative_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Background Color", 'dominion'),	
		"param_name" => "bg_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Background Hover Color", 'dominion'),	
		"param_name" => "bg_hover_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Padding", 'dominion'),     
			"param_name" => "padding",
			"group" => esc_html__( "Padding & Margin", 'dominion' ),            			
			"description" => esc_html__( "Insert Padding (e.g 22px) OR (e.g 5px 8px 2px 10px) for Top-Right-Bottom-Left", 'dominion' ),
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Margin", 'dominion'),     
			"param_name" => "margin",
			"group" => esc_html__( "Padding & Margin", 'dominion' ),            			
			"description" => esc_html__( "Insert Margin (e.g 22px) OR (e.g 5px 8px 2px 10px) for Top-Right-Bottom-Left", 'dominion' ),
		),
      )
   )
);
}