<?php
function domain_search_2_load_styles() {
	global $post;
	if ((is_a($post, 'WP_Post') && has_shortcode($post->post_content, 'dominion_shortcodes_domain_search_2'))) {
	$dominion_translation = array(
	'req_domain_text' => esc_html__( 'Please enter your domain.', 'dominion' ),
	'recaptcha_text' =>  esc_html__( 'Please verify that you are not a robot.', 'dominion' )
	);
	wp_enqueue_style( 'domain_search_2_dc_styles', plugins_url( 'css/main.css', __FILE__ ) );
	wp_enqueue_script( 'domain_search_2_dc_script', plugins_url( 'js/script.js', __FILE__ ), array('jquery'));
 	wp_localize_script( 'domain_search_2_dc_script', 'dominion_search_2_script', $dominion_translation );
	wp_localize_script( 'domain_search_2_dc_script', 'domain_search_2_ajax', array(
        'ajaxurl'       => admin_url( 'admin-ajax.php' ),
        'domain_search_2_nonce'     => wp_create_nonce( 'domain_search_2_nonce' ))
    );
	}
}
add_action( 'wp_enqueue_scripts', 'domain_search_2_load_styles' );
add_action( 'admin_enqueue_scripts', 'domain_search_2_load_styles' );


function domain_search_2_display_func(){
	check_ajax_referer( 'domain_search_2_nonce', 'security' );

if(isset($_POST['domain']))
{	
 $purchase_btn_url = $_POST['purchase_btn_url'];
	$domainext_domain_search_2 = $_POST['domainext_domain_search_2'];
	$domainname = $_POST['domain'].$_POST['domainext_domain_search_2'];
	$purchase_btn_name = $_POST['purchase_btn_name'];
	if($domainext_domain_search_2){
		$domain = str_replace(array('www.', 'http://', 'https://'), NULL, $domainname);
	}else{
		$domain = str_replace(array('www.', 'http://', 'https://'), NULL, $_POST['domain']);
	}

	
	if($purchase_btn_name){
	if($purchase_btn_url){
		$purchasedomain = '<br/> <a href="'.esc_url($purchase_btn_url).''.esc_attr($domain).'" class="ft-btn ft-btn-success" target="_blank">'.esc_attr($purchase_btn_name).'</a></div>';
	}else{
		$purchasedomain = '<br/> <a href="" class="ft-btn ft-btn-success">'.esc_attr($purchase_btn_name).'</a></div>';
	}
	}
	$split = explode('.', $domain);

		if(count($split) == 1) {
			$domain = $domain.".com";
		}
	$domain = preg_replace("/[^-a-zA-Z0-9.]+/", "", $domain);
	if(strlen($domain) > 0)
	{

		include ('DomainAvailability.php');
		$Domains = new DomainAvailability();
		$available = $Domains->is_available($domain);
		$custom_found_result_text = esc_html__('Congratulations! ', 'dominion').'<b>'.esc_attr($domain).'</b>'.esc_html__(' is available!', 'dominion');
    	$custom_not_found_result_text = esc_html__('Sorry! ', 'dominion').'<b>'.esc_attr($domain).'</b>'.esc_html__(' is already taken!', 'dominion');
		
		if ($available == '1') {
				$result = array('status'=>1,'domain'=>$domain, 'text'=> '<div class="ft-available">'.$custom_found_result_text.' '.$purchasedomain.' ');
		    	echo json_encode($result);
		} elseif ($available == '0') {
				$result = array('status'=>0,'domain'=>$domain, 'text'=> '<div class="ft-not-available">'.$custom_not_found_result_text.'</div>');
		    	echo json_encode($result);
		}elseif ($available == '2'){
				$result = array('status'=>0,'domain'=>$domain, 'text'=> '<div class="ft-not-available">'.esc_html__('WHOIS server not found for that TLD ', 'dominion').'</div>');
		    	echo json_encode($result);
		}
		
	}
	else
	{
		echo esc_html__('Please enter the domain name', 'dominion');
	}
}
die();
}

add_action('wp_ajax_domain_search_2_display','domain_search_2_display_func');
add_action('wp_ajax_nopriv_domain_search_2_display','domain_search_2_display_func');