<?php
class DomainAvailability {

	/**
	 * This function checks if the supplied domain name is registered
	 * @param string $domain The domain that will be checked for registration.
	 * @return boolean true means the domain is NOT registered
	 */
	public function is_available($domain) {

		// make the domain lowercase
		$domain = strtolower($domain);

		// Set the timeout (in seconds) for the socket open function.
		$timeout = 10;



		/**
		 * This array contains the list of WHOIS servers and the "domain not found" string
		 * to be searched for to check if the domain is available for registration.
		 *
		 * NOTE: The "domain not found" string may change at any time for any reason.
		 */
		 $whois_arr = array(
			"com" =>  array("whois.verisign-grs.com", "No match for"),
			"eu.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"uk.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"br.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"cn.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"gb.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"hu.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"no.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"qc.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"sa.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"se.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"us.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"uy.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"za.com" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"net" =>  array("whois.verisign-grs.com", "No match for "),
			"uk.net" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"gb.net" => array("whois.centralnic.com", "DOMAIN NOT FOUND"),
			"org" =>  array("whois.pir.org", "NOT FOUND"),
			"org.au" => array("whois.auda.org.au", "NOT FOUND"),
			"org.uk" => array("nominet.uk", "No match for"),
			"co.uk" =>  array("whois.nic.uk", "No match for "),
			"io" =>  array("whois.nic.io", "NOT FOUND"),
			"computer" => array( "whois.donuts.co", "Domain not found."),
			"ac" => array("whois.nic.ac","NOT FOUND"),
			"academy" => array("whois.donuts.co","Domain not found."),
			"actor" => array("whois.unitedtld.com","Domain not found."),
			"ae" => array("whois.aeda.net.ae","No Data Found"),
			"aero" => array("whois.aero","NOT FOUND"),
			"af" => array("whois.nic.af","No matching result"),
			"ag" => array("whois.nic.ag","NOT FOUND"),
			"agency" => array("whois.donuts.co","Domain not found."),
			"ai" => array("whois.ai","If you would like to register this"),
			"am" => array("whois.amnic.net","No match"),
			"archi" => array("whois.ksregistry.net","not found..."),
			"arpa" => array("whois.iana.org","% This query returned 1 objects."),
			"as" => array("whois.nic.as","Domain Status: Available"),
			"asia" => array("whois.nic.asia","NOT FOUND"),
			"associates" => array("whois.donuts.co","Domain not found."),
			"at" => array("whois.nic.at","% nothing found"),
			"au" => array("whois.audns.net.au","NOT FOUND"),
			"aw" => array("whois.nic.aw"," is free"),
			"ax" => array("whois.ax","No records matching "),
			"az" => array("whois.az","does not exist"), // not responding
			"bar" => array("whois.nic.bar","DOMAIN NOT FOUND"),
			"bargains" => array("whois.donuts.co","Domain not found."),
			"be" => array("whois.dns.be","AVAILABLE"),
			"berlin" => array("whois.nic.berlin","The queried object does not exist"),
			"bg" => array("whois.register.bg","does not exist in database!"),
			"bi" => array("whois1.nic.bi","No matching result"),
			"bike" => array("whois.donuts.co","Domain not found."),
			"biz" => array("whois.biz","No Data Found"),
			"bj" => array("whois.nic.bj","No matching found"),
			"blackfriday" => array("whois.uniregistry.net","is available for registration"),
			"blog" => array("whois.nic.blog","This domain name has not been registered"),
			"bn" => array("whois.bn","No records matching"),
			"boutique" => array("whois.donuts.co","Domain not found."),
			"build" => array("whois.nic.build","No Data Found"),
			"builders" => array("whois.donuts.co","Domain not found."),
			"bw" => array("whois.nic.net.bw","Domain Status: No Object Found"),
			"by" => array("whois.cctld.by","No match"),
			"ca" => array("whois.cira.ca","is available"),
			"cab" => array("whois.donuts.co","Domain not found."),
			"camera" => array("whois.donuts.co","Domain not found."),
			"camp" => array("whois.donuts.co","Domain not found."),
			"captial" => array("whois.donuts.co","Domain not found."),
			"cards" => array("whois.donuts.co","Domain not found."),
			"careers" => array("whois.donuts.co","Domain not found."),
			"cat" => array("whois.cat","No results found."),
			"catering" => array("whois.donuts.co","Domain not found."),
			"cc" => array("ccwhois.verisign-grs.com","No match for"),
			"center" => array("whois.donuts.co","Domain not found."),
			"ceo" => array("whois.nic.ceo","DOMAIN NOT FOUND"),
			"cf" => array("whois.dot.cf","Invalid query or domain name not known in Dot CF Domain Registry"),
			"ch" => array("whois.nic.ch","The domain name is not registered."),
			"cheap" => array("whois.donuts.co","Domain not found."),
			"christmas" => array("whois.uniregistry.net","is available for registration"),
			"ci" => array("whois.nic.ci","no matching found"),
			"cl" => array("whois.nic.cl",": no existe"),
			"cleaning" => array("whois.donuts.co","Domain not found."),
			"clothing" => array("whois.donuts.co","Domain not found."),
			"club" => array("whois.nic.club","No Data Found:"),
			"cn" => array("whois.cnnic.cn","no matching record."),
			"co" => array("whois.nic.co","There were no records matching your WHOIS query."),
			"codes" => array("whois.donuts.co","Domain not found."),
			"coffee" => array("whois.donuts.co","Domain not found."),
			"college" => array("whois.centralnic.com","DOMAIN NOT FOUND"),
			"cologne" => array("whois-fe1.pdt.cologne.tango.knipp.de","no matching objects found"),
			"community" => array("whois.donuts.co","Domain not found."),
			"company" => array("whois.donuts.co","Domain not found."),
			"construction" => array("whois.donuts.co","Domain not found."),
			"contractors" => array("whois.donuts.co","Domain not found."),
			"cooking" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"cool" => array("whois.donuts.co","Domain not found."),
			"coop" => array("whois.nic.coop","DOMAIN NOT FOUND"),
			"country" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"cruises" => array("whois.donuts.co","Domain not found."),
			"cx" => array("whois.nic.cx","No matching result"),
			"cz" => array("whois.nic.cz","NO RECORD FOUND."),
			"dating" => array("whois.donuts.co","Domain not found."),
			"de" => array("whois.denic.de","Status: free"),
			"democrat" => array("whois.unitedtld.com","Domain not found."),
			"desi" => array("whois.ksregistry.net","not found..."),
			"diamonds" => array("whois.donuts.co","Domain not found."),
			"directory" => array("whois.donuts.co","Domain not found."),
			"dk" => array("whois.dk-hostmaster.dk","No entries found for the selected source."),
			"dm" => array("whois.nic.dm","domain not found"),
			"domains" => array("whois.donuts.co","Domain not found."),
			"download" => array("whois.nic.download","No Data Found"),
			"dz" => array("whois.nic.dz","NO OBJECT FOUND!"),
			"ec" => array("whois.nic.ec","Status: Not Registered"),
			"edu" => array("whois.educause.edu","NO MATCH:"),
			"edu.au" => array("whois.audns.net.au","NOT FOUND"),
			"edu.cn" => array("whois.cnnic.net.cn","No matching record"),
			"edu.es" => array("whois.crsnic.net","No match for"),
			"education" => array("whois.donuts.co","Domain not found."),
			"ee" => array("whois.tld.ee","Domain not found."),
			"email" => array("whois.donuts.co","Domain not found."),
			"engineering" => array("whois.donuts.co","Domain not found."),
			"engineer" => array("whois.nic.engineer","Domain not found"),
			"enterprises" => array("whois.donuts.co","Domain not found."),
			"equipment" => array("whois.donuts.co","Domain not found."),
			"estate" => array("whois.donuts.co","Domain not found."),
			"eu" => array("whois.eu","Status: AVAILABLE"),
			"eus" => array("whois.eus.coreregistry.net","no matching objects found"),
			"events" => array("whois.donuts.co","Domain not found."),
			"expert" => array("whois.donuts.co","Domain not found."),
			"exposed" => array("whois.donuts.co","Domain not found."),
			"express" => array("whois.donuts.co","Domain not found"),
			"fans" => array("whois.nic.fans","DOMAIN NOT FOUND"),
			"farm" => array("whois.donuts.co","Domain not found."),
			"feedback" => array("whois.centralnic.com","DOMAIN NOT FOUND"),
			"fi" => array("whois.fi","Domain not found"),
			"fish" => array("whois.donuts.co","Domain not found."),
			"fishing" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"fitness" => array("whois.donuts.co","Domain not found"),
			"fit" => array("whois.nic.fit","queried object does not exist"),
			"flights" => array("whois.donuts.co","Domain not found."),
			"florist" => array("whois.donuts.co","Domain not found."),
			"fo" => array("whois.nic.fo","DOMAIN NOT FOUND."),
			"foo" => array("domain-registry-whois.l.google.com","Domain not found"),
			"football" => array("whois.donuts.co","Domain not found"),
			"foundation" => array("whois.donuts.co","Domain not found."),
			"fr" => array("whois.nic.fr","No entries found"),
			"frogans" => array("whois-frogans.nic.fr","Requested Domain cannot be found"),
			"fund" => array("whois.donuts.co","Domain not found"),
			"furniture" => array("whois.donuts.co","Domain not found"),
			"futbol" => array("whois.unitedtld.com","Domain not found."),
			"ga" => array("whois.gal.coreregistry.net","no matching objects found"),
			"gal" => array("whois.donuts.co","Domain not found."),
			"gd" => array("whois.nic.gd","DOMAIN NOT FOUND"),
			"gg" => array("whois.gg","Domain Status: No Object Found"),
			"gi" => array("whois2.afilias-grs.net","NOT FOUND"),
			"gift" => array("whois.uniregistry.net","is available for registration"),
			"gl" => array("whois.nic.gl", "No matching result"),
			"glass" => array("whois.donuts.co", "Domain not found."),
			"gmail" => array("domain-registry-whois.l.google.com","Domain not found."),
			"gop" => array("whois-cl01.mm-registry.com", "Status: Not Registered"),
			"gov" => array("whois.nic.gov", "No match for"),
			"gov.br" => array("whois.nic.br", "No match for"),
			"gov.cn" => array("whois.cnnic.net.cn", "No matching record"),
			"gov.ec" => array("whois.lac.net", "No match found"),
			"gov.il" => array("whois.isoc.org.il", "No data was found"),
			"gov.in" => array("whois.inregistry.in", "NOT FOUND"),
			"gov.mm" => array("whois.nic.mm", "No domains matched"),
			"gov.mx" => array("whois.nic.mx", "Object_Not_Found"),
			"gov.sg" => array("whois.nic.net.sg", "Domain Not Found"),
			"gov.tr" => array("whois.metu.edu.tr", "No match found"),
			"gov.za" => array("whois.co.za", "No information available"),
			"graphics" => array("whois.donuts.co","Domain not found."),
			"gripe" => array("whois.donuts.co","Domain not found."),
			"gs" => array("whois.nic.gs","No matching found"),
			"guitars" => array("whois.uniregistry.net","is available for registration"),
			"guru" => array("whois.donuts.co","Domain not found."),
			"gy" => array("whois.registry.gy","No matching result"),
			"haus" => array("whois.unitedtld.com","Domain not found."),
			"hk" => array("whois.hkirc.hk","The domain has not been registered."),
			"hn" => array("whois.nic.hn","Domain Status: No Object Found"),
			"holiday" => array("whois.donuts.co","Domain not found."),
			"horse" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"house" => array("whois.donuts.co","Domain not found."),
			"hr" => array("whois.dns.hr","Domain is not registered"),
			"ht" => array("whois.nic.ht","No matching result"),
			"hu" => array("whois.nic.hu","No match"),
			"id" => array("whois.pandi.or.id","DOMAIN NOT FOUND"),
			"ie" => array("whois.domainregistry.ie","Not Registered"),
			"il" => array("whois.isoc.org.il","No data was found"),
			"im" => array("whois.nic.im","was not found."),
			"immobilien" => array("whois.unitedtld.com","Domain not found."),
			"in" => array("whois.inregistry.net","NOT FOUND"),
			"industries" => array("whois.donuts.co","Domain not found."),
			"institute" => array("whois.donuts.co","Domain not found."),
			"int" => array("whois.iana.org","This query returned 0 objects."),
			"international" => array("whois.donuts.co","Domain not found."),
			"iq" => array("whois.cmc.iq","Domain Status: No Object Found"),
			"ir" => array("whois.nic.ir","No entries found in the selected source"),
			"is" => array("whois.isnic.is","No entries found for query"),
			"it" => array("whois.nic.it","AVAILABLE"),
			"je" => array("whois.je","Domain Status: No Object Found"),
			"jobs" => array("jobswhois.verisign-grs.com","No match for"),
			"jp" => array("whois.jprs.jp","There is no corresponding data!!"),
			"kaufen" => array("whois.unitedtld.com","Domain not found."),
			"ke" => array("whois.kenic.or.ke","Status: Not Registered"),
			"kg" => array("whois.domain.kg","Data not found. This domain is available for registration."),
			"ki" => array("whois.nic.ki","Domain Status: No Object Found"),
			"kitchen" => array("whois.donuts.co","Domain not found."),
			"kiwi" => array("whois.dot-kiwi.com","Status: Not Registered"),
			"koeln" => array("whois-fe1.pdt.koeln.tango.knipp.de","no matching objects found"),
			"kr" => array("whois.kr","domain was not found in the registry."),
			"kz" => array("whois.nic.kz","is not registered."),
			"la" => array("whois.nic.la","DOMAIN NOT FOUND"),
			"land" => array("whois.donuts.co","Domain not found."),
			"lease" => array("whois.donuts.co","Domain not found."),
			"li" => array("whois.nic.li","The domain name is not registered"),
			"lighting" => array("whois.donuts.co","Domain not found."),
			"limo" => array("whois.donuts.co","Domain not found."),
			"link" => array("whois.uniregistry.net","is available for registration"),
			"london" => array("whois-lon.mm-registry.com","Status: Not Registered"),
			"lt" => array("whois.domreg.lt","Laisvas"),
			"lu" => array("whois.dns.lu","No such domain"),
			"luxury" => array("whois.nic.luxury","No Data Found"),
			"lv" => array("whois.nic.lv","Status: free"),
			"ly" => array("whois.nic.ly","Not found"),
			"ma" => array("whois.iam.net.ma","No Objects Found"),
			"management" => array("whois.donuts.co","Domain not found."),
			"mango" => array("whois.mango.coreregistry.net","no matching objects found"),
			"marketing" => array("whois.donuts.co","Domain not found."),
			"md" => array("whois.nic.md","No match for"),
			"me" => array("whois.nic.me","NOT FOUND"),
			"media" => array("whois.donuts.co","Domain not found."),
			"menu" => array("whois.nic.menu","No Data Found"),
			"mg" => array("whois.nic.mg","Domain Status: Available"),
			"miami" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"mk" => array("whois.marnet.mk","is not registered"),
			"ml" => array("whois.dot.ml","domain name not known"),
			"mn" => array("whois.nic.mn","NOT FOUND"),
			"mo" => array("whois.monic.mo","No match for"),
			"mobi" => array("whois.dotmobiregistry.net","NOT FOUND"),
			"moda" => array("whois.unitedtld.com","Domain not found."),
			"monash" => array("whois.nic.monash","No Data Found"),
			"monash" => array("whois.nic.monash","No Data Found"),
			"mp" => array("whois.nic.mp","MATCH"), // not responding
			"ms" => array("whois.nic.ms","Domain Status: No matching result"),
			"mu" => array("whois.nic.mu","Domain Status: No matching result"),
			"museum" => array("whois.museum","NOT FOUND."),
			"mx" => array("whois.mx","Object_Not_Found"),
			"my" => array("whois.domainregistry.my","does not exist in database"),
			"na" => array("whois.na-nic.com.na","No matching result"),
			"name" => array("whois.nic.name","No match for domain"),
			"nc" => array("whois.nc","No entries found in the .nc database"),
			"nf" => array("whois.nic.nf","No matching result"),
			"ng" => array("whois.nic.net.ng","No Object Found"),
			"ninja" => array("whois.unitedtld.com","Domain not found."),
			"nl" => array("whois.domain-registry.nl","is free"),
			"no" => array("whois.norid.no","% No match"),
			"nu" => array("whois.iis.nu","not found."),
			"nz" => array("whois.srs.net.nz","220 Available"),
			"om" => array("whois.registry.om","No Data Found"),
			"onl" => array("whois.afilias-srs.net","NOT FOUND"),
			"paris" => array("whois-paris.nic.fr","did not return any results"),
			"partners" => array("whois.donuts.co","Domain not found."),
			"parts" => array("whois.donuts.co","Domain not found."),
			"pe" => array("kero.yachay.pe","Status: Not Registered"),
			"pf" => array("whois.registry.pf","No contact information for this domain."),
			"photo" => array("whois.uniregistry.net","is available for registration"),
			"photography" => array("whois.donuts.co","Domain not found."),
			"photos" => array("whois.donuts.co","Domain not found."),
			"pics" => array("whois.uniregistry.net","is available for registration"),
			"pictures" => array("whois.donuts.co","Domain not found."),
			"pl" => array("whois.dns.pl","No information available"),
			"plumbing" => array("whois.donuts.co","Domain not found."),
			"pm" => array("whois.nic.pm","No entries found"),
			"post" => array("whois.dotpostregistry.net","NOT FOUND"),
			"pr" => array("whois.nic.pr","NOT FOUND."),
			"pro" => array("whois.dotproregistry.net","NOT FOUND"),
			"productions" => array("whois.donuts.co","Domain not found."),
			"properties" => array("whois.donuts.co","Domain not found."),
			"pt" => array("whois.dns.pt","No results matched your search"),
			"pub" => array("whois.unitedtld.com","Domain not found."),
			"pw" => array("whois.nic.pw","DOMAIN NOT FOUND"),
			"qa" => array("whois.registry.qa","No Data Found"),
			"quebec" => array("whois.quebec.rs.corenic.net","no matching objects found"),
			"re" => array("whois.nic.re","No entries found"),
			"recipes" => array("whois.donuts.co","Domain not found."),
			"reisen" => array("whois.donuts.co","Domain not found."),
			"rentals" => array("whois.donuts.co","Domain not found."),
			"repair" => array("whois.donuts.co","Domain not found."),
			"report" => array("whois.donuts.co","Domain not found."),
			"rest" => array("whois.centralnic.com","DOMAIN NOT FOUND"),
			"reviews" => array("whois.unitedtld.com","Domain not found."),
			"rich" => array("whois.afilias-srs.net","NOT FOUND"),
			"ro" => array("whois.rotld.ro","No entries found"),
			"rocks" => array("whois.unitedtld.com","Domain not found."),
			"rodeo" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"rs" => array("whois.rnids.rs","Domain is not registered"),
			"ru" => array("whois.tcinet.ru","No entries found"),
			"ruhr" => array("whois.nic.ruhr","No results found"),
			"sa" => array("whois.nic.net.sa","No Match for"),
			"saarland" => array("whois.ksregistry.net","not found..."),
			"sb" => array("whois.nic.net.sb","No matching result"),
			"sc" => array("whois2.afilias-grs.net","NOT FOUND"),
			"se" => array("whois.iis.se","not found."),
			"services" => array("whois.donuts.co","Domain not found."),
			"sexy" => array("whois.uniregistry.net","is available for registration"),
			"sg" => array("whois.sgnic.sg","Domain Not Found"),
			"sh" => array("whois.nic.sh","NOT FOUND"),
			"shoes" => array("whois.donuts.co","Domain not found."),
			"si" => array("whois.arnes.si","No entries found"),
			"singles" => array("whois.donuts.co","Domain not found."),
			"sk" => array("whois.sk-nic.sk","Domain not found."),
			"sm" => array("whois.nic.sm","No entries found."),
			"sn" => array("whois.nic.sn","did not return any results"),
			"so" => array("whois.nic.so","No matching result"),
			"social" => array("whois.unitedtld.com","Domain not found."),
			"solar" => array("whois.donuts.co","Domain not found."),
			"solutions" => array("whois.donuts.co","Domain not found."),
			"soy" => array("domain-registry-whois.l.google.com","Domain not found"),
			"st" => array("whois.nic.st","No entries found"),
			"su" => array("whois.tcinet.ru","No entries found"),
			"supplies" => array("whois.donuts.co","Domain not found."),
			"supply" => array("whois.donuts.co","Domain not found."),
			"support" => array("whois.donuts.co","Domain not found."),
			"sx" => array("whois.sx","Not found"),
			"sy" => array("whois.tld.sy","Domain Status: Available"),
			"systems" => array("whois.donuts.co","Domain not found."),
			"tattoo" => array("whois.uniregistry.net","is available for registration"),
			"tc" => array("whois.meridiantld.net","Domain Status: No Object Found"),
			"technology" => array("whois.donuts.co","Domain not found."),
			"tel" => array("whois.nic.tel","No Data Found"),
			"tf" => array("whois.nic.tf","No entries found"),
			"th" => array("whois.thnic.co.th","No match for"),
			"tienda" => array("whois.donuts.co","Domain not found."),
			"tips" => array("whois.donuts.co","Domain not found."),
			"tk" => array("whois.dot.tk","Invalid query or domain name not known"),
			"tl" => array("whois.nic.tl","No matching result"),
			"tm" => array("whois.nic.tm","is available for purchase"),
			"tn" => array("whois.ati.tn","is available"),
			"to" => array("whois.tonic.to","No match for"),
			"today" => array("whois.donuts.co","Domain not found."),
			"tools" => array("whois.donuts.co","Domain not found."),
			"town" => array("whois.donuts.co","Domain not found."),
			"toys" => array("whois.donuts.co","Domain not found."),
			"tr" => array("whois.nic.tr","No match found for"),
			"training" => array("whois.donuts.co","Domain not found."),
			"travel" => array("whois.nic.travel","No Data found:"),
			"tv" => array("tvwhois.verisign-grs.com","No match for"),
			"tw" => array("whois.twnic.net.tw","No Found"),
			"tz" => array("whois.tznic.or.tz","No entries found."),
			"ua" => array("whois.ua","No entries found"),
			"ug" => array("whois.co.ug","No entries found for the selected source(s)."),
			"uk" => array("whois.nic.uk","This domain name has not been registered."),
			"university" => array("whois.donuts.co","Domain not found."),
			"us" => array("whois.nic.us","No Data Found"),
			"uy" => array("whois.nic.org.uy","No match for"),
			"black" => array("whois.afilias.net","NOT FOUND"),
			"blue" => array("whois.afilias.net","NOT FOUND"),
			"info" => array("whois.afilias.net","NOT FOUND"),
			"kim" => array("whois.afilias.net","NOT FOUND"),
			"pink" => array("whois.afilias.net","NOT FOUND"),
			"red" => array("whois.afilias.net","NOT FOUND"),
			"shiksha" => array("whois.afilias.net","NOT FOUND"),
			"uz" => array("whois.cctld.uz","not found in database"),
			"vacations" => array("whois.donuts.co","Domain not found."),
			"vc" => array("whois2.afilias-grs.net","NOT FOUND"),
			"ve" => array("whois.nic.ve","No match for"),
			"vegas" => array("whois.afilias-srs.net","NOT FOUND"),
			"ventures" => array("whois.donuts.co","Domain not found."),
			"vg" => array("ccwhois.ksregistry.net","DOMAIN NOT FOUND"),
			"viajes" => array("whois.donuts.co","Domain not found."),
			"villas" => array("whois.donuts.co","Domain not found."),
			"vision" => array("whois.donuts.co","Domain not found."),
			"vodka" => array("whois-dub.mm-registry.com","Status: Not Registered"),
			"voting" => array("whois.voting.tld-box.at","No match"),
			"voyage" => array("whois.donuts.co","Domain not found."),
			"vu" => array("vunic.vu","is available"),
			"wang" => array("whois.gtld.knet.cn","No match"),
			"watch" => array("whois.donuts.co","Domain not found."),
			"wed" => array("whois.nic.wed","This domain name has not been registered"),
			"wf" => array("whois.nic.wf","No entries found in the AFNIC Database."),
			"wien" => array("whois.nic.wien","available"),
			"wiki" => array("whois.nic.wiki","DOMAIN NOT FOUND"),
			"works" => array("whois.donuts.co","Domain not found."),
			"ws" => array("whois.website.ws","No match for"),
			"xxx" => array("whois.nic.xxx","NOT FOUND"),
			"xyz" => array("whois.nic.xyz","DOMAIN NOT FOUND"),
			"yoga" => array("whois.nic.yoga","queried object does not exist"),
			"youtube" => array("domain-registry-whois.l.google.com","Domain not found."),
			"yt" => array("whois.nic.yt","No entries found"),
			"ryukyu" => array("whois.nic.ryukyu", "DOMAIN NOT FOUND"),
			"zm" => array("whois.nic.zm","No matching result"),
			"zone" => array( "whois.donuts.co","Domain not found."),
			"gmbh" => array("whois.donuts.co","Domain not found"),
			"com.ar" => array("whois.nic.ar","No entries found."),
			"com.ng" => array("whois.nic.net.ng","Domain Status: No Object Found"),
			"srl" => array("whois.afilias-srs.net","Domain Status: No Object Found"),
			"scot" => array("whois.nic.scot","No results found"),
			"br" => array("whois.nic.br","Domain available for registration"),
			"engineer" => array("whois.nic.engineer","Domain not found"),
			"gifts" => array("whois.nic.gifts","Domain not found"),
			"quebec" => array("whois.nic.quebec","No results found"),
			"restaurant" => array("whois.nic.restaurant","Domain not found"),
			"sarl" => array("whois.nic.sarl","Domain not found"),
			"click" => array("whois.nic.click","is available for registration"),
			"host" => array("whois.nic.host","DOMAIN NOT FOUND"),
			"hosting" => array("whois.nic.hosting","is available for registration"),
			"trade" => array("whois.nic.trade","No Data Found"),
			"career" => array("whois.nic.career","No match for domain"),
			"diet" => array("whois.nic.diet","is available for registration"),
			"help" => array("whois.nic.help","is available for registration"),
			"jobs" => array("jobswhois.verisign-grs.com","No match for"),
			"property" => array("whois.nic.property","is available for registration"),
			"beer" => array("whois.nic.beer","has not been registered"),
			"direct" => array("whois.nic.direct","Domain not found"),
			"place" => array("whois.nic.place","Domain not found"),
			"surf" => array("whois.nic.surf","has not been registered."),
			"healthcare" => array("whois.donuts.co","Domain not found"),
			"army" => array("whois.unitedtld.com","Domain not found"),
			"navy" => array("whois.unitedtld.com","Domain not found"),
			"airforce" => array("whois.unitedtld.com","Domain not found"),
			"vet" => array("whois.unitedtld.com","Domain not found"),
			"za" => array("whois.co.za","Available")
		);
	
		// gethostbyname returns the same string if it cant find the domain,
		// we do a further check to see if it is a false positive
		// get the TLD of the domain
			$tld = $this->get_tld($domain);

			// If an entry for the TLD exists in the whois array
			if (isset($whois_arr[$tld][0])) {
				// set the hostname for the whois server
				$whois_server = $whois_arr[$tld][0];

				// set the "domain not found" string
				$bad_string = $whois_arr[$tld][1];
			} else {
				// TODO: REFACTOR THIS
				// TLD is not in the whois array, die
				//throw new Exception("WHOIS server not found for that TLD");
				return '2';
			}

			$status = $this->checkDomainNameAvailabilty($domain,$whois_server,$bad_string);

			return $status;
}
	

	/**
	 * Extracts the TLD from a domain, supports URLS with "www." at the beginning.
	 *
	 * @author  Helge Sverre <email@helgesverre.com>
	 *
	 * @param string $domain The domain that will get it's TLD extracted
	 * @return string The TLD for $domain
	 */

	public function get_tld ($domain) {
		$split = explode('.', $domain);

		if(count($split) === 0) {
			throw new Exception('Invalid domain extension');
			
		}
		return end($split);
	}

	public function checkDomainNameAvailabilty($domain_name, $whois_server, $find_text){
 
    // Open a socket connection to the whois server
    $con = fsockopen($whois_server, 43);
    if (!$con) return false;
 
    // Send the requested domain name
    fputs($con, $domain_name."\r\n");
 
    // Read and store the server response
    $response = " :";
    while(!feof($con))
        $response .= fgets($con,128); 
 
    // Close the connection
    fclose($con);
 
    // Check the Whois server response
    if (strpos($response, $find_text))
	return '1';
    else
    return '0';
	}
}