<?php
/*-----------------------------------------------------------------------------------*/
/* Start Using dominion Shortcodes in the Visual Composer */
/*-----------------------------------------------------------------------------------*/
add_action( 'init', 'dominion_heading_6_vc_shortcodes' );
function dominion_heading_6_vc_shortcodes() {
/****************
Heading - 6
****************/
vc_map( array(
      "name" => esc_html__("FT- Heading - 6", 'dominion'),
      "base" => "dominion_shortcodes_heading_6",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'dominion'),
      'description' => esc_html__('Custom Heading Style - 4', 'dominion'),
      "params" => array(
		array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Heading 1", 'dominion'),
            "param_name" => "heading_1",
            "value" => '',
            "description" => esc_html__('Feature Title', 'dominion')
         ),
		 array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Heading 1 Tag", 'dominion'),			
			"param_name" => "heading_1_tag",
			"value" => 
				array(						   
					esc_html__('Default', 'dominion')=>'h3',
					esc_html__('H1', 'dominion')=>'h1',
					esc_html__('H2', 'dominion')=>'h2',			   			   
					esc_html__('H3', 'dominion')=>'h3',			   			   
					esc_html__('H4', 'dominion')=>'h4',			   			   
					esc_html__('H5', 'dominion')=>'h5',
					esc_html__('H6', 'dominion')=>'h6',			   			   
					esc_html__('Div', 'dominion')=>'div',			   			   
					esc_html__('P', 'dominion')=>'p',			   			   
					esc_html__('Span', 'dominion')=>'span' 
				)		
		),
		array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Heading 2", 'dominion'),
            "param_name" => "heading_2",
            "value" => '',
            "description" => esc_html__('Heading 2', 'dominion')
        ),
		array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Heading 2 Tag", 'dominion'),			
			"param_name" => "heading_2_tag",
			"value" => 
				array(						   
					esc_html__('Default', 'dominion')=>'h3',
					esc_html__('H1', 'dominion')=>'h1',
					esc_html__('H2', 'dominion')=>'h2',			   			   
					esc_html__('H3', 'dominion')=>'h3',			   			   
					esc_html__('H4', 'dominion')=>'h4',			   			   
					esc_html__('H5', 'dominion')=>'h5',
					esc_html__('H6', 'dominion')=>'h6',			   			   
					esc_html__('Div', 'dominion')=>'div',			   			   
					esc_html__('P', 'dominion')=>'p',			   			   
					esc_html__('Span', 'dominion')=>'span' 
				)		
		),
		array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Text", 'dominion'),
            "param_name" => "text",
            "value" => '',
            "description" => esc_html__('Text below the title', 'dominion')
        ),
		array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Text Transform", 'dominion'),			
			"param_name" => "transform",
			"value" => 
				array(						   
					esc_html__('Uppercase', 'dominion')=>'uppercase',
					esc_html__('Capitalize', 'dominion')=>'capitalize',
					esc_html__('Lowercase', 'dominion')=>'lowercase'		   			   
				)		
		),
		array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Text Align", 'dominion'),			
			"param_name" => "align",
			"value" => 
				array(						   
					esc_html__('Left', 'dominion')=>'left',
					esc_html__('Right', 'dominion')=>'right',
					esc_html__('Center', 'dominion')=>'center'		   			   
				)		
		),
		array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Want to show divider?", 'dominion'),
            "param_name" => "divider",
			"std"		=> "no",
			"value" => array(
				  "Yes" => "yes"
			   ),
			"description" => '',
         ),
		 array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Divider Width", 'dominion'),            
			"param_name" => "divider_width",
			'dependency' => array(
				 'element' => 'divider',
				 'value' =>'yes',
			 ),
			"description" => 'Divider Width (e.g 50px)'        
		),
		array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Divider Height", 'dominion'),            
			"param_name" => "divider_height",
			'dependency' => array(
				 'element' => 'divider',
				 'value' =>'yes',
			 ),
			"description" => 'Divider Height (e.g 3px)'        
		),
		array(          
			"type" => "colorpicker",  
			"class" => "",     
			"heading" => esc_html__("Divider Color", 'dominion'),	
			"param_name" => "divider_color",
			'dependency' => array(
				 'element' => 'divider',
				 'value' =>'yes',
			 ),
			"value" => '',       
			"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Divider Margin Top", 'dominion'),            
			"param_name" => "divider_margin_top",
			'dependency' => array(
				 'element' => 'divider',
				 'value' =>'yes',
			 ),
			"description" => 'Divider Margin Top (e.g 5px)'        
		),
		array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Divider Margin Bottom", 'dominion'),            
			"param_name" => "divider_margin_bottom",
			'dependency' => array(
				 'element' => 'divider',
				 'value' =>'yes',
			 ),
			"description" => 'Divider Margin Bottom (e.g 20px)'        
		),
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Want to make this feature Animated?", 'dominion'),
            "param_name" => "animate",
			"std"		=> "no",
			"value" => array(
				  "Yes" => "yes"
			   ),
			"description" => '',
         ),
		 array(            
			"type" => "dropdown",                        
			"class" => "",            
			"heading" => esc_html__("Animation Style", 'dominion'),			
			"param_name" => "animation_style",
			'dependency' => array(
				 'element' => 'animate',
				 'value' =>'yes',
			 ),
			"value" => 
				array(						   
					esc_html__('Fade In', 'dominion')=>'fade-in',
					esc_html__('Fade In Left', 'dominion')=>'fade-in-left',
					esc_html__('Fade In Left Big', 'dominion')=>'fade-in-left-big',
					esc_html__('Fade In Right', 'dominion')=>'fade-in-right',			   			   
					esc_html__('Fade In Right Big', 'dominion')=>'fade-in-right-big',			   			   
					esc_html__('Fade In Up', 'dominion')=>'fade-in-up',			   			   
					esc_html__('Fade In Up Big', 'dominion')=>'fade-in-up-big',			   			   
					esc_html__('Fade In Down', 'dominion')=>'fade-in-down',
					esc_html__('Fade In Down Big', 'dominion')=>'fade-in-down-big',
					esc_html__('Bounce In', 'dominion')=>'bounce-in',
					esc_html__('Bounce In Left', 'dominion')=>'bounce-in-left',
					esc_html__('Bounce In Right', 'dominion')=>'bounce-in-right',			   			   
					esc_html__('Bounce In Up', 'dominion')=>'bounce-in-up',			   			   
					esc_html__('Bounce In Down', 'dominion')=>'bounce-in-down',
					esc_html__('Flip In X', 'dominion')=>'flip-in-x',
					esc_html__('Flip In Y', 'dominion')=>'flip-in-y',
					esc_html__('Light Speed In', 'dominion')=>'light-speed-in',
					esc_html__('Rotate In', 'dominion')=>'rotate-in',
					esc_html__('Rotate In Left', 'dominion')=>'rotate-in-left',
					esc_html__('Rotate In Right', 'dominion')=>'rotate-in-right',			   			   
					esc_html__('Rotate In Up', 'dominion')=>'rotate-in-up',			   			   
					esc_html__('Rotate In Down', 'dominion')=>'rotate-in-down',
					esc_html__('Roll In', 'dominion')=>'roll-in',
					esc_html__('Zoom In', 'dominion')=>'zoom-in',
					esc_html__('Zoom In Left', 'dominion')=>'zoom-in-left',
					esc_html__('Zoom In Right', 'dominion')=>'zoom-in-right',			   			   
					esc_html__('Zoom In Up', 'dominion')=>'zoom-in-up',			   			   
					esc_html__('Zoom In Down', 'dominion')=>'zoom-in-down',
					esc_html__('Slide In Left', 'dominion')=>'slide-in-left',
					esc_html__('Slide In Right', 'dominion')=>'slide-in-right',			   			   
					esc_html__('Slide In Up', 'dominion')=>'slide-in-up',			   			   
					esc_html__('Slide In Down', 'dominion')=>'slide-in-down',
					esc_html__('Top To Bottom', 'dominion')=>'top-to-bottom',
					esc_html__('Bottom To Top', 'dominion')=>'bottom-to-top',
					esc_html__('Left To Right', 'dominion')=>'left-to-right',
					esc_html__('Right To Left', 'dominion')=>'right-to-left',
					esc_html__('Appear from center', 'dominion')=>'appear'
				)		
		),
		 array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Animate Delay Time", 'dominion'),            
			"param_name" => "anim_delay",
			'dependency' => array(
				 'element' => 'animate',
				 'value' =>'yes',
			 ),
			"description" => 'Insert delay time  (e.g 100)'        
		),
		 array(            
			"type" => "textfield",                        
			"class" => "",            
			"heading" => esc_html__("Unique Class Name (Required)", 'dominion'),            
			"param_name" => "unique_class_name",
			"group" => esc_html__( "Color Options", 'dominion' ),
			"description" => 'Insert a unique class name to use different color features for different pricing tables  (e.g unique_cls_1)'        
		),
		array(
			'type' => 'google_fonts',
			"heading" => esc_html__("Heading 1 Font Options", 'dominion'),
			'param_name' => 'heading_1_font_family',
			"group" => esc_html__( "Font Options", 'dominion' ),            
			'value' => 'font_family:Open%21Sans|font_style:normal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select Font Family.', 'dominion' ),
					'font_style_description' => esc_html__( 'Select Font Style.', 'dominion' ),
				)
			)                   
		),			 		 		 	
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Heading 1 Font Size", 'dominion'),     
			"param_name" => "heading_1_font_size", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => 'Insert Heading 1 font size (e.g 22px)'     
		),	
		array(   
			"type" => "dropdown",         
			"class" => "",      
			"heading" => esc_html__("Heading 1 Font Weight", 'dominion'),	
			"param_name" => "heading_1_font_weight",
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"value" => 
			array(			
				esc_html__('Choose font weight', 'dominion')=>'300',
				esc_html__('300', 'dominion')=>'300',
				esc_html__('400', 'dominion')=>'400',		
				esc_html__('500', 'dominion')=>'500',			
				esc_html__('600', 'dominion')=>'600',	
				esc_html__('700', 'dominion')=>'700',	
				esc_html__('800', 'dominion')=>'800',		
				esc_html__('900', 'dominion')=>'900'     
			)	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Heading 1 Line Height", 'dominion'),     
			"param_name" => "heading_1_line_height", 
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"description" => 'Insert line height (e.g 22px)'     
		),
		array(
			'type' => 'google_fonts',
			"heading" => esc_html__("Heading 2 Font Options", 'dominion'),
			'param_name' => 'heading_2_font_family',
			"group" => esc_html__( "Font Options", 'dominion' ),            
			'value' => 'font_family:Open%21Sans|font_style:normal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select Font Family.', 'dominion' ),
					'font_style_description' => esc_html__( 'Select Font Style.', 'dominion' ),
				)
			)                   
		),	 		 	
		array(      
		"type" => "textfield",            
		"class" => "",     
		"heading" => esc_html__("Heading 2 Font Size", 'dominion'),     
		"param_name" => "heading_2_font_size",
		"group" => esc_html__( "Font Options", 'dominion' ),            
		"description" => 'Insert title font size (e.g 22px)'      
		),	
		array(         
			"type" => "dropdown",         
			"class" => "",         
			"heading" => esc_html__("Heading 2 Font Weight", 'dominion'),	
			"param_name" => "heading_2_font_weight",
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"value" => 
			array(		
				esc_html__('Choose font weight', 'dominion')=>'300',
				esc_html__('300', 'dominion')=>'300',
				esc_html__('400', 'dominion')=>'400',		
				esc_html__('500', 'dominion')=>'500',		
				esc_html__('600', 'dominion')=>'600',			   	
				esc_html__('700', 'dominion')=>'700',		
				esc_html__('800', 'dominion')=>'800',		
				esc_html__('900', 'dominion')=>'900'    
			)	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Heading 2 Line Height", 'dominion'),     
			"param_name" => "heading_2_line_height",
			"group" => esc_html__( "Font Options", 'dominion' ),            			
			"description" => 'Insert line height (e.g 22px)'     
		),
		array(
			'type' => 'google_fonts',
			"heading" => esc_html__("Text Font Options", 'dominion'),
			'param_name' => 'text_font_family',
			"group" => esc_html__( "Font Options", 'dominion' ),            
			'value' => 'font_family:Open%21Sans|font_style:normal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select Font Family.', 'dominion' ),
					'font_style_description' => esc_html__( 'Select Font Style.', 'dominion' ),
				)
			)                   
		),	 		 	
		array(      
		"type" => "textfield",            
		"class" => "",     
		"heading" => esc_html__("Text Font Size", 'dominion'),     
		"param_name" => "text_font_size",
		"group" => esc_html__( "Font Options", 'dominion' ),            
		"description" => 'Insert title font size (e.g 22px)'      
		),	
		array(         
			"type" => "dropdown",         
			"class" => "",         
			"heading" => esc_html__("Text Font Weight", 'dominion'),	
			"param_name" => "text_font_weight",
			"group" => esc_html__( "Font Options", 'dominion' ),            
			"value" => 
			array(		
				esc_html__('Choose font weight', 'dominion')=>'300',
				esc_html__('300', 'dominion')=>'300',
				esc_html__('400', 'dominion')=>'400',		
				esc_html__('500', 'dominion')=>'500',		
				esc_html__('600', 'dominion')=>'600',			   	
				esc_html__('700', 'dominion')=>'700',		
				esc_html__('800', 'dominion')=>'800',		
				esc_html__('900', 'dominion')=>'900'    
			)	
		),
		array(     
			"type" => "textfield",             
			"class" => "",         
			"heading" => esc_html__("Text Line Height", 'dominion'),     
			"param_name" => "text_line_height",
			"group" => esc_html__( "Font Options", 'dominion' ),            			
			"description" => 'Insert line height (e.g 22px)'     
		),
		array(          
			"type" => "colorpicker",  
			"class" => "",     
			"heading" => esc_html__("Choose Heading 1 Color", 'dominion'),	
			"param_name" => "heading_1_color",
			"group" => esc_html__( "Color Options", 'dominion' ), 
			"value" => '',       
			"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
			"type" => "colorpicker",  
			"class" => "",     
			"heading" => esc_html__("Choose Heading 1 Hover Color", 'dominion'),	
			"param_name" => "heading_1_hover_color",
			"group" => esc_html__( "Color Options", 'dominion' ), 
			"value" => '',       
			"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Heading 2 Color", 'dominion'),	
		"param_name" => "heading_2_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Heading 2 Hover Color", 'dominion'),	
		"param_name" => "heading_2_hover_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Text Color", 'dominion'),	
		"param_name" => "text_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		),
		array(          
		"type" => "colorpicker",     
		"class" => "",       
		"heading" => esc_html__("Choose Text Hover Color", 'dominion'),	
		"param_name" => "text_hover_color",
		"group" => esc_html__( "Color Options", 'dominion' ),            
        "value" => '',     
		"description" => esc_html__("Do not choose any color from here if you want to use the default color.", 'dominion')	
		)		
      )
   )
);
}