<?php

/******
 Function Google Fonts Applied On All Custom Elements
*******/

function dominion_get_fonts_data( $fontsString ) {   
 
	// Font data Extraction
	$fieldSettings = array();
	if( !class_exists('Vc_Google_Fonts') ) {
	$googleFontsParam = new Ft_Google_Fonts();
	$fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_ft_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';
	} else {
	$googleFontsParam = new Vc_Google_Fonts();
	$fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';
	}
	return $fontsData;
	
}

function dominion_google_fonts_styles( $fontsData ) {
      
	// Inline styles
	$inline_style = '';   
	$fontFamily = array();
	if (is_array($fontsData)) {
	$fontFamily = explode( ':', $fontsData['values']['font_family'] );
	}
	if(isset($fontFamily[0])){
	$styles[] = 'font-family:' . $fontFamily[0];
	if (is_array($fontsData)) {
	$fontStyles = explode( ':', $fontsData['values']['font_style'] );
	}
	if ( is_array( $styles ) && is_array( $fontStyles ) && isset($fontStyles[2]) ) {
	$styles[] = 'font-style:' . $fontStyles[2];
	}
	  
	foreach( $styles as $attribute ){           
		$inline_style .= $attribute.'; ';       
	}   
	}
	 
	return $inline_style;
         
}

function dominion_enqueue_google_fonts( $fontsData ) {
         
	// Get extra subsets for settings (latin/cyrillic/etc)
	$settings = get_option( 'wpb_js_google_fonts_subsets' );
	if ( is_array( $settings ) && ! empty( $settings ) ) {
		$subsets = '&subset=' . implode( ',', $settings );
	} else {
		$subsets = '';
	}
	 
	// We also need to enqueue font from googleapis
	if ( isset( $fontsData['values']['font_family'] ) ) {
		if( !class_exists('Vc_Google_Fonts') ) {
		wp_enqueue_style( 
			'ft_google_fonts_' . ft_build_safe_css_class( $fontsData['values']['font_family'] ), 
			'//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets
		);
		} else {
		wp_enqueue_style( 
			'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), 
			'//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets
		);
		}
	}
         
}