<?php
/*
Plugin Name: LambertGroup - Chameleon HTML5 Audio Player With/Without Playlist
Description: This plugin will allow you to insert a HTML5 Audio Player With/Without Playlist.
Version: 3.3
Author: Lambert Group
Author URI: https://1.envato.market/OZ5Zr
Text Domain: lbg-audio1-html5
*/

$lbg_audio1_html5_path = trailingslashit(dirname(__FILE__));  //empty

//all the messages
$lbg_audio1_html5_messages = array(
		'version' => __( '<div class="error">LambertGroup - Chameleon HTML5 Audio Player With/Without Playlist plugin requires WordPress 3.0 or newer. <a href="https://codex.wordpress.org/Upgrading_WordPress">Please update!</a></div>', 'lbg-audio1-html5' ),
		'data_saved' => __( 'Data Saved!', 'lbg-audio1-html5' ),
		'empty_name' => __( 'Name - required', 'lbg-audio1-html5' ),
		'empty_mp3' => __( 'MP3 - required', 'lbg-audio1-html5' ),
		'empty_ogg' => __( 'OGG - required', 'lbg-audio1-html5' ),
		'empty_player' => __( 'Select Player - required', 'lbg-audio1-html5' ),
		'empty_folder' => __( 'Folder Path - required', 'lbg-audio1-html5' ),
		'invalid_request' => __( 'Invalid Request!', 'lbg-audio1-html5' ),
		'generate_for_this_player' => __( 'You can start customizing this player.', 'lbg-audio1-html5' ),
		'duplicate_complete' => __( 'Duplication process is complete!', 'lbg-audio1-html5' ),
		'folder_read' => __( 'The playlist was generated! Go to "Manage Players" and check the "Playlist" for the selected player', 'lbg-audio1-html5' ),
		'no_mp3' => __( 'No MP3 files in this folder!', 'lbg-audio1-html5' ),
	);


global $wp_version;

if ( !version_compare($wp_version,"3.0",">=")) {
	die (__($lbg_audio1_html5_messages['version'], 'lbg-audio1-html5' ));
}




function lbg_audio1_html5_activate() {
	//db creation, create admin options etc.
	global $wpdb;

	$lbg_audio1_html5_collate = ' COLLATE utf8_general_ci';

	$sql0 = "CREATE TABLE `" . $wpdb->prefix . "lbg_audio1_html5_players` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
			`name` VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY ( `id` )
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql1 = "CREATE TABLE `" . $wpdb->prefix . "lbg_audio1_html5_settings` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `skin` varchar(255) NOT NULL DEFAULT 'whiteControllers',
  `initialVolume` float unsigned NOT NULL DEFAULT '1',
  `autoPlay` varchar(8) NOT NULL DEFAULT 'true',
	`centerPlugin` varchar(8) NOT NULL DEFAULT 'false',
  `loop` varchar(8) NOT NULL DEFAULT 'true',
  `shuffle` varchar(8) NOT NULL DEFAULT 'false',
  `preload` varchar(10) NOT NULL DEFAULT 'metadata',
  `float` varchar(10) NOT NULL DEFAULT 'none',
  `playlistOver` varchar(8) NOT NULL DEFAULT 'false',
  `playerPadding` smallint(5) unsigned NOT NULL DEFAULT '5',
  `playerBg` varchar(10) NOT NULL DEFAULT '000000',
  `bufferEmptyColor` varchar(10) NOT NULL DEFAULT '929292',
  `bufferFullColor` varchar(10) NOT NULL DEFAULT '454545',
  `seekbarColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `volumeOffColor` varchar(10) NOT NULL DEFAULT '454545',
  `volumeOnColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `timerColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `songAuthorTitleColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `showRewindBut` varchar(8) NOT NULL DEFAULT 'true',
  `showPlayBut` varchar(8) NOT NULL DEFAULT 'true',
  `showPreviousBut` varchar(8) NOT NULL DEFAULT 'true',
  `showNextBut` varchar(8) NOT NULL DEFAULT 'true',
  `showPlaylistBut` varchar(8) NOT NULL DEFAULT 'true',
  `showVolumeBut` varchar(8) NOT NULL DEFAULT 'true',
  `showVolumeSliderBut` varchar(8) NOT NULL DEFAULT 'true',
  `showTimer` varchar(8) NOT NULL DEFAULT 'true',
  `showSeekBar` varchar(8) NOT NULL DEFAULT 'true',
  `showAuthor` varchar(8) NOT NULL DEFAULT 'true',
  `showTitle` varchar(8) NOT NULL DEFAULT 'true',
  `showPlaylist` varchar(8) NOT NULL DEFAULT 'true',
  `showPlaylistOnInit` varchar(8) NOT NULL DEFAULT 'true',
  `playlistTopPos` smallint(5) unsigned NOT NULL DEFAULT '2',
  `playlistBgColor` varchar(10) NOT NULL DEFAULT '000000',
  `playlistRecordBgOffColor` varchar(10) NOT NULL DEFAULT '000000',
  `playlistRecordBgOnColor` varchar(10) NOT NULL DEFAULT '333333',
  `playlistRecordBottomBorderOffColor` varchar(10) NOT NULL DEFAULT '333333',
  `playlistRecordBottomBorderOnColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `playlistRecordTextOffColor` varchar(10) NOT NULL DEFAULT '777777',
  `playlistRecordTextOnColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
  `numberOfThumbsPerScreen` smallint(5) unsigned NOT NULL DEFAULT '5',
  `playlistPadding` smallint(5) unsigned NOT NULL DEFAULT '4',
  `continuouslyPlayOnAllPages` varchar(8) NOT NULL DEFAULT 'false',
  `showPlaylistNumber` varchar(8) NOT NULL DEFAULT 'true',
  `isSliderInitialized` varchar(8) NOT NULL DEFAULT 'false',
  `isProgressInitialized` varchar(8) NOT NULL DEFAULT 'false',
	`delay` float unsigned NOT NULL DEFAULT '0.5',
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql2 = "CREATE TABLE `". $wpdb->prefix . "lbg_audio1_html5_playlist` (
	  `id` int(10) unsigned NOT NULL auto_increment,
	  `playerid` int(10) unsigned NOT NULL,
	  `mp3` text NOT NULL,
	  `ogg` text,
	  `title` text,
	  `author` text,
	  `ord` int(10) unsigned NOT NULL,
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql0.$lbg_audio1_html5_collate);
	dbDelta($sql1.$lbg_audio1_html5_collate);
	dbDelta($sql2.$lbg_audio1_html5_collate);


	//initialize the players table with the first player type
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_audio1_html5_players;" );
	if (!$rows_count) {
		$wpdb->insert(
			$wpdb->prefix . "lbg_audio1_html5_players",
			array(
				'name' => 'White Controllers'
			),
			array(
				'%s'
			)
		);
	}

	// initialize the settings
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_audio1_html5_settings;" );
	if (!$rows_count) {
		lbg_audio1_html5_insert_settings_record(1);
	}




}



function lbg_audio1_html5_insert_settings_record($player_id) {
	global $wpdb;
	$wpdb->insert(
			$wpdb->prefix . "lbg_audio1_html5_settings",
			array(
				'skin' => 'whiteControllers'
			),
			array(
				'%s'
			)
		);
}


function lbg_audio1_html5_init_sessions() {
	global $wpdb;
	if (is_admin()) {
		if (!session_id()) {
			session_start();

			//initialize the session
			if (!isset($_SESSION['xid'])) {
				$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_players) LIMIT 0, 1";
				$row = $wpdb->get_row($safe_sql,ARRAY_A);
				$_SESSION['xid'] = $row['id'];
				$_SESSION['xname'] = $row['name'];
			}
		}
	}
}


function lbg_audio1_html5_load_styles() {
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) { //loads css in admin
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/LBG_AUDIO1_HTML5/i', $page)) {

			wp_enqueue_style('lbg-jquery-ui-custom_css', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/pepper-grinder/jquery-ui.min.css');
			wp_enqueue_style('lbg-audio1-html5_css', plugins_url('css/styles.css', __FILE__));
			wp_enqueue_style('lbg-audio1-html5-colorpicker-css', plugins_url('css/colorpicker/colorpicker.css', __FILE__));

			wp_enqueue_style('thickbox');
		}
	} else if (!is_admin()) { //loads css in front-end
		wp_enqueue_style('audio1-html5-site-css', plugins_url('audio1_html5/audio1_html5.css', __FILE__));
	}
}

function lbg_audio1_html5_load_scripts() {
	$page = (isset($_GET['page'])) ? $_GET['page'] : '';
	if(preg_match('/LBG_AUDIO1_HTML5/i', $page)) {
			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');

			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');

			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');
			wp_enqueue_script('jquery-effects-transfer');

			wp_register_script('lbg-admin-colorpicker', plugins_url('js/colorpicker/colorpicker.js', __FILE__));
			wp_enqueue_script('lbg-admin-colorpicker');

			wp_register_script('lbg-admin-toggle', plugins_url('js/myToggle.js', __FILE__));
			wp_enqueue_script('lbg-admin-toggle');

			wp_enqueue_script('media-upload'); // before w.p 3.5
			wp_enqueue_media();// from w.p 3.5
			wp_enqueue_script('thickbox');

	} else if (!is_admin()) { //loads scripts in front-end
			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-effects-core');

		wp_register_script('lbg-mousewheel', plugins_url('audio1_html5/js/jquery.mousewheel.min.js', __FILE__));
		wp_enqueue_script('lbg-mousewheel');

		wp_register_script('lbg-touchSwipe', plugins_url('audio1_html5/js/jquery.touchSwipe.min.js', __FILE__));
		wp_enqueue_script('lbg-touchSwipe');

		wp_register_script('lbg-audio1-html5', plugins_url('audio1_html5/js/audio1_html5.js', __FILE__));
		wp_enqueue_script('lbg-audio1-html5');
	}

}



// adds the menu pages
function lbg_audio1_html5_plugin_menu() {
	add_menu_page('LBG AUDIO1 HTML5 Admin Interface', 'LBG AUDIO1 HTML5', 'edit_posts', 'LBG_AUDIO1_HTML5', 'lbg_audio1_html5_overview_page',
	plugins_url('images/lbg_audio1_icon.png', __FILE__));
	add_submenu_page( 'LBG_AUDIO1_HTML5', 'LBG AUDIO1 HTML5 Overview', 'Overview', 'edit_posts', 'LBG_AUDIO1_HTML5', 'lbg_audio1_html5_overview_page');
	add_submenu_page( 'LBG_AUDIO1_HTML5', 'LBG AUDIO1 HTML5 Manage Players', 'Manage Players', 'edit_posts', 'LBG_AUDIO1_HTML5_Manage_Players', 'lbg_audio1_html5_player_manage_players_page');
	add_submenu_page( 'LBG_AUDIO1_HTML5', 'LBG AUDIO1 HTML5 Manage Players Add New', 'Add New', 'edit_posts', 'LBG_AUDIO1_HTML5_Add_New', 'lbg_audio1_html5_player_manage_players_add_new_page');
	add_submenu_page( 'LBG AUDIO1 HTML5 Manage Players', 'LBG AUDIO1 HTML5 Player Settings', 'Player Settings', 'edit_posts', 'LBG_AUDIO1_HTML5_Settings', 'lbg_audio1_html5_player_settings_page');
	add_submenu_page( 'LBG AUDIO1 HTML5 Manage Players', 'LBG AUDIO1 HTML5 Player Playlist', 'Playlist', 'edit_posts', 'LBG_AUDIO1_HTML5_Playlist', 'lbg_audio1_html5_player_playlist_page');
	add_submenu_page( 'LBG_AUDIO1_HTML5_Settings', 'LBG AUDIO1 HTML5 Player Settings', 'Duplicate Player', 'edit_posts', 'LBG_AUDIO1_HTML5_Duplicate_Player', 'lbg_audio1_html5_duplicate_player_page');
	add_submenu_page( 'LBG_AUDIO1_HTML5', 'LBG AUDIO1 HTML5 Read Folder', 'Generate Playlist From Folder', 'edit_posts', 'LBG_AUDIO1_HTML5_Read_Folder', 'lbg_audio1_html5_player_read_folder_page');
	add_submenu_page( 'LBG_AUDIO1_HTML5', 'LBG AUDIO1 HTML5 Help', 'Help', 'edit_posts', 'LBG_AUDIO1_HTML5_Help', 'lbg_audio1_html5_player_help_page');
}


//HTML content for overview page
function lbg_audio1_html5_overview_page()
{
	global $lbg_audio1_html5_path;
	include_once($lbg_audio1_html5_path . 'tpl/overview.php');
}

//HTML content for Manage Players
function lbg_audio1_html5_player_manage_players_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	//delete player
	if (isset($_GET['id'])) {
		//delete from wp_lbg_audio1_html5_players
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_audio1_html5_players WHERE id = %d",$_GET['id']));

		//delete from wp_lbg_audio1_html5_settings
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_audio1_html5_settings WHERE id = %d",$_GET['id']));

		//delete from wp_lbg_audio1_html5_playlist
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_audio1_html5_playlist WHERE playerid = %d",$_GET['id']));

		//initialize the session
		$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_players) ORDER BY id";
		$row = $wpdb->get_row($safe_sql,ARRAY_A);
		$row=lbg_audio1_html5_unstrip_array($row);
		if ($row['id']) {
			$_SESSION['xid']=$row['id'];
			$_SESSION['xname']=$row['name'];
		}
	}


	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_players) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($lbg_audio1_html5_path . 'tpl/players.php');

}


//HTML content for Manage Players - Add New
function lbg_audio1_html5_player_manage_players_add_new_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add New') {
		$errors_arr=array();
		if (empty($_POST['name']))
			$errors_arr[]=$lbg_audio1_html5_messages['empty_name'];

		if (count($errors_arr)) {
				include_once($lbg_audio1_html5_path . 'tpl/add_player.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		  	<?php } else { // no errors
					$wpdb->insert(
						$wpdb->prefix . "lbg_audio1_html5_players",
						array(
							'name' => sanitize_text_field($_POST['name'])
						),
						array(
							'%s'
						)
					);
					//insert default player settings for this new player
					lbg_audio1_html5_insert_settings_record($wpdb->insert_id);
					?>
						<div class="wrap">
							<div id="lbg_logo">
								<h2><?php esc_html_e('Manage Players - Add New Player', 'lbg-audio1-html5' );?></h2>
				 			</div>
							<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['data_saved'], 'lbg-audio1-html5' );?></p><p><?php esc_html_e($lbg_audio1_html5_messages['generate_for_this_player'], 'lbg-audio1-html5' );?></p></div>
							<div>
								<p>&raquo; <a href="?page=LBG_AUDIO1_HTML5_Add_New">Add New (player)</a></p>
								<p>&raquo; <a href="?page=LBG_AUDIO1_HTML5_Manage_Players">Back to Manage Players</a></p>
							</div>
						</div>
		  	<?php }
	} else {
		include_once($lbg_audio1_html5_path . 'tpl/add_player.php');
	}

}


//HTML content for playersettings
function lbg_audio1_html5_player_settings_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	$wpdb->show_errors();

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Update Player Settings') {
		$_GET['xmlf']='';
		$except_arr=array('Submit','name','pll_ajax_backend','page_scroll_to_id_instances');
			$wpdb->update(
				$wpdb->prefix .'lbg_audio1_html5_players',
				array(
				'name' => sanitize_text_field($_POST['name'])
				),
				array( 'id' => $_SESSION['xid'] )
			);
			$_SESSION['xname']=stripslashes($_POST['name']);


			foreach ($_POST as $key=>$val){
				if (in_array($key,$except_arr)) {
					unset($_POST[$key]);
				}
			}

			$wpdb->update(
				$wpdb->prefix .'lbg_audio1_html5_settings',
				$_POST,
				array( 'id' => $_SESSION['xid'] )
			);

			?>
			<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['data_saved'], 'lbg-audio1-html5' );?></p></div>
	<?php
	}

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_settings) WHERE id = %d",$_SESSION['xid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_audio1_html5_unstrip_array($row);
	$_POST = $row;
	$_POST=lbg_audio1_html5_unstrip_array($_POST);
	include_once($lbg_audio1_html5_path . 'tpl/settings_form.php');

}


function lbg_audio1_html5_player_playlist_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}


	if (array_key_exists('xmlf', $_GET) && $_GET['xmlf']=='add_playlist_record') {
		if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add Record') {
			$errors_arr=array();
			if (empty($_POST['mp3']))
				 $errors_arr[]=$lbg_audio1_html5_messages['empty_mp3'];

			if (count($errors_arr)) {
				include_once($lbg_audio1_html5_path . 'tpl/add_playlist_record.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  <?php } else { // all requested fields are filled



		if (count($errors_arr)) {
			include_once($lbg_audio1_html5_path . 'tpl/add_playlist_record.php'); ?>
			<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  	<?php } else { // no upload errors
				$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."lbg_audio1_html5_playlist WHERE playerid = %d",$_SESSION['xid'] ) );

				$wpdb->insert(
					$wpdb->prefix . "lbg_audio1_html5_playlist",
					array(
						'playerid' => $_POST['playerid'],
						'mp3' => $_POST['mp3'],
						'ogg' => $_POST['ogg'],
						'title' => $_POST['title'],
						'author' => $_POST['author'],
						'ord' => $max_ord
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%d'
					)
				);

	  			if (isset($_POST['setitfirst'])) {
					$sql_arr=array();
					$ord_start=$max_ord;
					$ord_stop=1;
					$elem_id=$wpdb->insert_id;
					$ord_direction='+1';

					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=ord+1  WHERE playerid = %d and ord>=".$ord_stop." and ord<".$ord_start,$_SESSION['xid']);
					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=%d WHERE id=%d",$ord_stop,$elem_id);

					foreach ($sql_arr as $sql)
						$wpdb->query($sql);
				}
				?>
					<div class="wrap">
						<div id="lbg_logo">
							<h2>Playlist for player: <span style="color:#FF0000; font-weight:bold;"><?php esc_html($_SESSION['xname'])?> - ID #<?php esc_html($_SESSION['xid'])?></span> - Add New</h2>
			 			</div>
						<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['data_saved'], 'lbg-audio1-html5' );?></p></div>
						<div>
							<p>&raquo; <a href="?page=LBG_AUDIO1_HTML5_Playlist&xmlf=add_playlist_record">Add New</a></p>
							<p>&raquo; <a href="?page=LBG_AUDIO1_HTML5_Playlist">Back to Playlist</a></p>
						</div>
					</div>
	  	<?php }
	  		}
		} else {
			include_once($lbg_audio1_html5_path . 'tpl/add_playlist_record.php');
		}

	} else {
		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_playlist) WHERE playerid = %d ORDER BY ord",$_SESSION['xid'] );
		$result = $wpdb->get_results($safe_sql,ARRAY_A);

		include_once($lbg_audio1_html5_path . 'tpl/playlist.php');
	}
}


//HTML duplicate player
function lbg_audio1_html5_duplicate_player_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	$wpdb->show_errors();
	//insert player
	$wpdb->insert(
			$wpdb->prefix . "lbg_audio1_html5_players",
			array(
				'name' => 'Duplicate of Audio Player '.$_SESSION['xid']
			),
			array(
				'%s'
			)
		);

	//duplicate settings
	$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."lbg_audio1_html5_settings (`skin`, `initialVolume`, `autoPlay`, `centerPlugin`, `loop`, `preload`, `float`, `playlistOver`, `playerPadding`, `playerBg`, `bufferEmptyColor`, `bufferFullColor`, `seekbarColor`, `volumeOffColor`, `volumeOnColor`, `timerColor`, `songAuthorTitleColor`, `showRewindBut`, `showPlayBut`, `showPreviousBut`, `showNextBut`, `showPlaylistBut`, `showVolumeBut`, `showVolumeSliderBut`, `showTimer`, `showSeekBar`, `showAuthor`, `showTitle`, `showPlaylist`, `showPlaylistOnInit`, `playlistTopPos`, `playlistBgColor`, `playlistRecordBgOffColor`, `playlistRecordBgOnColor`, `playlistRecordBottomBorderOffColor`, `playlistRecordBottomBorderOnColor`, `playlistRecordTextOffColor`, `playlistRecordTextOnColor`, `numberOfThumbsPerScreen`, `playlistPadding`, `showPlaylistNumber`, `isSliderInitialized`, `isProgressInitialized`, `shuffle`, `continuouslyPlayOnAllPages`, `delay`) SELECT `skin`, `initialVolume`, `autoPlay`, `centerPlugin`, `loop`, `preload`, `float`, `playlistOver`, `playerPadding`, `playerBg`, `bufferEmptyColor`, `bufferFullColor`, `seekbarColor`, `volumeOffColor`, `volumeOnColor`, `timerColor`, `songAuthorTitleColor`, `showRewindBut`, `showPlayBut`, `showPreviousBut`, `showNextBut`, `showPlaylistBut`, `showVolumeBut`, `showVolumeSliderBut`, `showTimer`, `showSeekBar`, `showAuthor`, `showTitle`, `showPlaylist`, `showPlaylistOnInit`, `playlistTopPos`, `playlistBgColor`, `playlistRecordBgOffColor`, `playlistRecordBgOnColor`, `playlistRecordBottomBorderOffColor`, `playlistRecordBottomBorderOnColor`, `playlistRecordTextOffColor`, `playlistRecordTextOnColor`, `numberOfThumbsPerScreen`, `playlistPadding`, `showPlaylistNumber`, `isSliderInitialized`, `isProgressInitialized`, `shuffle`, `continuouslyPlayOnAllPages`, `delay` FROM (".$wpdb->prefix ."lbg_audio1_html5_settings) WHERE id = %d",$_SESSION['xid'] );
	$wpdb->query($safe_sql);
	?>
	<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['duplicate_complete'], 'lbg-audio1-html5' );?></p></div>
	<?php

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_players) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($lbg_audio1_html5_path . 'tpl/players.php');


}


function lbg_audio1_read_mp3_meta($mp3) {
	$getID3 = new getID3;
	$fileinformation = $getID3->analyze($mp3);
	$data["song"]='';
  $data["artist"]='';
	if (isset($fileinformation['id3v1'])) {
		  if (array_key_exists("title",$fileinformation['id3v1']['comments'])) {
					$data["song"] = trim($fileinformation['id3v1']['comments']['title'][0]);
			}
			if (array_key_exists("artist",$fileinformation['id3v1']['comments'])) {
					$data["artist"]=trim($fileinformation['id3v1']['comments']['artist'][0]);
			}

			if ($data["artist"]=='' && array_key_exists("band",$fileinformation['id3v1']['comments'])) {
					$data["artist"]=trim($fileinformation['id3v1']['comments']['band'][0]);
			}
	}
	if ($data["song"]==='') {
			if (isset($fileinformation['id3v2'])) {
					if (array_key_exists("title",$fileinformation['id3v2']['comments'])) {
							$data["song"] = trim($fileinformation['id3v2']['comments']['title'][0]);
					}
					if (array_key_exists("artist",$fileinformation['id3v2']['comments'])) {
							$data["artist"]=trim($fileinformation['id3v2']['comments']['artist'][0]);
					}
					if ($data["artist"]=='' && array_key_exists("band",$fileinformation['id3v2']['comments'])) {
							$data["artist"]=trim($fileinformation['id3v2']['comments']['band'][0]);
					}
			}
	}


	 return $data;
}


function lbg_audio1_html5_player_read_folder_page()
{
	global $wpdb;
	global $lbg_audio1_html5_messages;
	global $lbg_audio1_html5_path;

	include_once($lbg_audio1_html5_path . 'getid3/getid3.php');

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	$wpdb->show_errors();

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_players) ORDER BY id";
	$result_player = $wpdb->get_results($safe_sql,ARRAY_A);

	$errors_arr=array();
	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Generate Playlist') {
		if (empty($_POST['playerid']))
			 $errors_arr[]=$lbg_audio1_html5_messages['empty_player'];
		if (empty($_POST['folder_path']))
			 $errors_arr[]=$lbg_audio1_html5_messages['empty_folder'];
		if (count($errors_arr)) { ?>
			<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		<?php } else {
					$sPath = get_home_path().$_POST['folder_path'].'/*.mp3';
					$max_ord = $wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."lbg_audio1_html5_playlist WHERE playerid = %d",$_POST['playerid'] ) );
					$no_of_mp3=0;
					foreach (glob($sPath) AS $mp3) {
						$no_of_mp3++;
						$meta_arr=lbg_audio1_read_mp3_meta($mp3);
						$mp3=substr ( $mp3 , (strlen(get_home_path())) );
						$mp3=get_site_url().'/'.$mp3;

						//check uniqueness
						$wpdb->query( $wpdb->prepare("SELECT * FROM ".$wpdb->prefix."lbg_audio1_html5_playlist WHERE playerid = %d AND mp3 = %s",$_POST['playerid'],$mp3) );
						if ($wpdb->num_rows==0) {
							$max_ord++;
							$wpdb->insert(
								$wpdb->prefix . "lbg_audio1_html5_playlist",
								array(
									'playerid' => $_POST['playerid'],
									'mp3' => $mp3,
									'ogg' => $mp3,
									'title' => $meta_arr["song"],
									'author' => $meta_arr["artist"],
									'ord' => $max_ord
								),
								array(
									'%d',
									'%s',
									'%s',
									'%s',
									'%s',
									'%d'
								)
							);
						}
					}
					echo $the_playlist_code;

		if ($no_of_mp3>0) {
		?>
			<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['folder_read'], 'lbg-audio1-html5' );?></p></div>
		<?php } else { ?>
			<div id="error" class="error"><p><?php esc_html_e($lbg_audio1_html5_messages['no_mp3'], 'lbg-audio1-html5' );?></p></div>
			<?php }
		} //no errors
	}
	include_once($lbg_audio1_html5_path . 'tpl/read_folder.php');


}



function lbg_audio1_html5_player_help_page()
{
	global $lbg_audio1_html5_path;
	include_once($lbg_audio1_html5_path . 'tpl/help.php');
}


function lbg_audio1_html5_generate_preview_code($sliderID,$the_arr) {
	global $wpdb;
	global $post;

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_settings) WHERE id = %d",$sliderID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_audio1_html5_unstrip_array($row);

	$path_to_plugin = plugin_dir_url( __FILE__ );
	$preload_aux='metadata';
	if ($row["preload"])
		$preload_aux=$row["preload"];

	//float
	$float_aux='';
	if ($row["float"]!='none') {
		$float_aux='float:'.$row["float"].';';
		if ($row["float"]=='left')
			$float_aux.=' padding: 5px 20px 0 0;';
		else
			$float_aux.=' padding: 5px 0 0 20px;';
	}

	//playlistOver
	$playlistOver_aux='';
	$player_height=0;
	$playlist_unit_height=31;
	$playlist_height=0;
	$numberOfThumbsPerScreen_aux=$row["numberOfThumbsPerScreen"];
	$playlistPadding_aux=$row["playlistPadding"];
	$playlistTopPos_aux=$row["playlistTopPos"];
	if ($row["playlistOver"]=='false' && $row["showPlaylist"]=='true') {
		$player_height+=20+2*$row["playerPadding"]; //20 - play button height
		if ($row["showSeekBar"]) {
			$player_height+=14; //14 - seekbar height
		}
		if ($row["showAuthor"] || $row["showTitle"]) {
			$player_height+=22;	//22 - title or author height
		}
	}

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_audio1_html5_playlist) WHERE playerid = %d ORDER BY ord",$sliderID );
	$result = $wpdb->get_results($safe_sql,ARRAY_A);

	if ($player_height) {
		$playlist_height=min($numberOfThumbsPerScreen_aux, $wpdb->num_rows)*$playlist_unit_height+2*$playlistPadding_aux+$playlistTopPos_aux;
		$playlistOver_aux="height:".($player_height+$playlist_height)."px;";
	}

	$playlist_str='';
	foreach ( $result as $row_playlist ) {

		$row_playlist=lbg_audio1_html5_unstrip_array($row_playlist);


		$mp3_path=$row_playlist["mp3"];
		$ogg_path=$row_playlist["ogg"];


		$playlist_str.='<ul>
                	<li class="xtitle">'.$row_playlist["title"].'</li>
                    <li class="xauthor">'.$row_playlist["author"].'</li>
                    <li class="xsources_mp3">'.$mp3_path.'</li>
                    <li class="xsources_ogg">'.$ogg_path.'</li>
                </ul>';
	}

	/*** OPTIONAL PARAMETERS START ***/
	$has_additional_parameters=false;
	$mp3_path='';
	$ogg_path='';
	$title_aux='';
	$author_aux='';
	if(array_key_exists('mp3_file', $the_arr) && $the_arr['mp3_file'] != '') {
		$has_additional_parameters=true;
		$mp3_path=$the_arr['mp3_file'];
	}
	if(array_key_exists('ogg_file', $the_arr) && $the_arr['ogg_file'] != '') {
		$has_additional_parameters=true;
		$ogg_path=$the_arr['ogg_file'];
	}
	if(array_key_exists('title', $the_arr) && $the_arr['title'] != '') {
		$title_aux=$the_arr['title'];
	}
	if(array_key_exists('author', $the_arr) && $the_arr['author'] != '') {
		$author_aux=$the_arr['author'];
	}


	if(array_key_exists('mp3_custom_field', $the_arr) && $the_arr['mp3_custom_field'] != '') {
		$has_additional_parameters=true;
		$mp3_path=get_post_meta($post->ID, $the_arr['mp3_custom_field'], true);;
	}
	if(array_key_exists('ogg_custom_field', $the_arr) && $the_arr['ogg_custom_field'] != '') {
		$has_additional_parameters=true;
		$ogg_path=get_post_meta($post->ID, $the_arr['ogg_custom_field'], true);
	}
	if(array_key_exists('title_custom_field', $the_arr) && $the_arr['title_custom_field'] != '') {
		$title_aux=get_post_meta($post->ID, $the_arr['title_custom_field'], true);
	}
	if(array_key_exists('author_custom_field', $the_arr) && $the_arr['author_custom_field'] != '') {
		$author_aux=get_post_meta($post->ID, $the_arr['author_custom_field'], true);
	}

	if ($has_additional_parameters) {
		$playlist_str='<ul>
                	<li class="xtitle">'.$title_aux.'</li>
                    <li class="xauthor">'.$author_aux.'</li>
                    <li class="xsources_mp3">'.$mp3_path.'</li>
                    <li class="xsources_ogg">'.$ogg_path.'</li>
                </ul>';
	}

	/*** OPTIONAL PARAMETERS END ***/

	$new_div_start='';
	$new_div_end='';

	$rand_no=mt_rand (10000,1000000);
	$content='<p style="padding:0;margin:0;"><script>
		jQuery(function() {
			setTimeout(function(){
			jQuery("#lbg_audio1_html5_'.$row["id"].$rand_no.'").audio1_html5({
				skin:"'.$row["skin"].'",
				initialVolume:'.$row["initialVolume"].',
				autoPlay:'.$row["autoPlay"].',
				centerPlugin:'.$row["centerPlugin"].',
				loop:'.$row["loop"].',
				shuffle:'.$row["shuffle"].',
				continuouslyPlayOnAllPages:'.$row["continuouslyPlayOnAllPages"].',
				playerPadding:'.$row["playerPadding"].',
				playerBg:"#'.$row["playerBg"].'",
				bufferEmptyColor:"#'.$row["bufferEmptyColor"].'",
				bufferFullColor:"#'.$row["bufferFullColor"].'",
				seekbarColor:"#'.$row["seekbarColor"].'",
				volumeOffColor:"#'.$row["volumeOffColor"].'",
				volumeOnColor:"#'.$row["volumeOnColor"].'",
				timerColor:"#'.$row["timerColor"].'",
				songAuthorTitleColor:"#'.$row["songAuthorTitleColor"].'",
				showRewindBut:'.$row["showRewindBut"].',
				showPlayBut:'.$row["showPlayBut"].',
				showPreviousBut:'.$row["showPreviousBut"].',
				showNextBut:'.$row["showNextBut"].',
				showPlaylistBut:'.$row["showPlaylistBut"].',
				showVolumeBut:'.$row["showVolumeBut"].',
				showVolumeSliderBut:'.$row["showVolumeSliderBut"].',
				showTimer:'.$row["showTimer"].',
				showSeekBar:'.$row["showSeekBar"].',
				showAuthor:'.$row["showAuthor"].',
				showTitle:'.$row["showTitle"].',
				showPlaylist:'.$row["showPlaylist"].',
				showPlaylistOnInit:'.$row["showPlaylistOnInit"].',
				playlistTopPos:'.$row["playlistTopPos"].',
				playlistBgColor:"#'.$row["playlistBgColor"].'",
				playlistRecordBgOffColor:"#'.$row["playlistRecordBgOffColor"].'",
				playlistRecordBgOnColor:"#'.$row["playlistRecordBgOnColor"].'",
				playlistRecordBottomBorderOffColor:"#'.$row["playlistRecordBottomBorderOffColor"].'",
				playlistRecordBottomBorderOnColor:"#'.$row["playlistRecordBottomBorderOnColor"].'",
				playlistRecordTextOffColor:"#'.$row["playlistRecordTextOffColor"].'",
				playlistRecordTextOnColor:"#'.$row["playlistRecordTextOnColor"].'",
				numberOfThumbsPerScreen:'.$row["numberOfThumbsPerScreen"].',
				playlistPadding:'.$row["playlistPadding"].',
				showPlaylistNumber:'.$row["showPlaylistNumber"].',
				isSliderInitialized:'.$row["isSliderInitialized"].',
				isProgressInitialized:'.$row["isProgressInitialized"].'
			});
			}, '.($row["delay"]*1000).');
		});
	</script>
    '.$new_div_start.'<div class="audio1_html5">
            <audio id="lbg_audio1_html5_'.$row["id"].$rand_no.'" preload="'.$preload_aux.'">
                  <div class="xaudioplaylist">'.$playlist_str.'</div>
              No HTML5 audio playback capabilities for this browser. Use <a href="https://www.google.com/intl/en/chrome/browser/">Chrome Browser!</a>
            </audio>
     </div>
	<br style="clear:both;">'.$new_div_end.'</p>';

	return str_replace("\r\n", '', $content);
}


function lbg_audio1_html5_shortcode($atts, $content=null) {
	global $wpdb;

	shortcode_atts( array(
		'settings_id'=>'',
		'mp3_file'=>'',
		'ogg_file'=>'',
		'title'=>'',
		'author'=>'',
		'mp3_custom_field'=>'',
		'ogg_custom_field'=>'',
		'title_custom_field'=>'',
		'author_custom_field'=>''
	), $atts);
	if ($atts['settings_id']=='')
		$atts['settings_id']=1;


	return lbg_audio1_html5_generate_preview_code($atts['settings_id'],$atts);
}


register_activation_hook(__FILE__,"lbg_audio1_html5_activate"); //activate plugin and create the database
add_action('init', 'lbg_audio1_html5_init_sessions');	// initialize sessions
add_action('init', 'lbg_audio1_html5_load_styles');	// loads required styles
add_action('init', 'lbg_audio1_html5_load_scripts');			// loads required scripts
add_action('admin_menu', 'lbg_audio1_html5_plugin_menu'); // create menus
add_shortcode('lbg_audio1_html5', 'lbg_audio1_html5_shortcode');				// LBG AUDIO1 HTML5 shortcode




/** OTHER FUNCTIONS **/

//stripslashes for an entire array
function lbg_audio1_html5_unstrip_array($array){
	if (is_array($array)) {
		foreach($array as &$val){
			if(is_array($val)){
				$val = unstrip_array($val);
			} else {
				$val = stripslashes($val);

			}
		}
	}
	return $array;
}

/* ajax update playlist record */

add_action('admin_head', 'lbg_audio1_html5_update_playlist_record_javascript');

function lbg_audio1_html5_update_playlist_record_javascript() {
	global $wpdb;
	//Set Your Nonce
	$lbg_audio1_html5_update_playlist_record_ajax_nonce = wp_create_nonce("lbg_audio1_html5_update_playlist_record-special-string");
	$lbg_audio1_html5_preview_record_ajax_nonce = wp_create_nonce("lbg_audio1_html5_preview_record-special-string");

	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
			$page = (isset($_GET['page'])) ? $_GET['page'] : '';
			if(preg_match('/LBG_AUDIO1_HTML5/i', $page)) {
?>



<script type="text/javascript" >
//delete the entire record
function lbg_audio1_html5_delete_entire_record (delete_id) {
	if (confirm('Are you sure?')) {
		jQuery("#lbg_audio1_html5_sortable").sortable('disable');
		jQuery("#"+delete_id).css("display","none");
		//jQuery("#lbg_audio1_html5_sortable").sortable('refresh');
		jQuery("#lbg_audio1_html5_updating_witness").css("display","block");
		var data = "action=lbg_audio1_html5_update_playlist_record&security=<?php echo esc_js($lbg_audio1_html5_update_playlist_record_ajax_nonce); ?>&updateType=lbg_audio1_html5_delete_entire_record&delete_id="+delete_id;
		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			jQuery("#lbg_audio1_html5_sortable").sortable('enable');
			jQuery("#lbg_audio1_html5_updating_witness").css("display","none");
			//alert('Got this from the server: ' + response);
		});
	}
}


function showDialogPreview(theSliderID) {  //load content and open dialog
	var data ="action=lbg_audio1_html5_preview_record&security=<?php echo esc_js($lbg_audio1_html5_preview_record_ajax_nonce); ?>&theSliderID="+theSliderID;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//jQuery("#previewDialog").html(response);
		jQuery('#previewDialogIframe').attr('src','<?php echo plugins_url("tpl/preview.html?d=".time(), __FILE__)?>');
		jQuery("#previewDialog").dialog("open");
	});
}



jQuery(document).ready(function($) {
	/*PREVIEW DIALOG BOX*/
	jQuery( "#previewDialog" ).dialog({
	  minWidth:1200,
	  minHeight:500,
	  title:"Plugin Preview",
	  modal: true,
	  autoOpen:false,
	  hide: "fade",
	  resizable: false,
	  open: function() {
	  },
	  close: function() {
		jQuery('#previewDialogIframe').attr('src','');
	  }
	});	/*	*/


	if (jQuery('#lbg_audio1_html5_sortable').length) {
		jQuery( '#lbg_audio1_html5_sortable' ).sortable({
			placeholder: "ui-state-highlight",
			start: function(event, ui) {
	            ord_start = ui.item.prevAll().length + 1;
	        },
			update: function(event, ui) {
	        	jQuery("#lbg_audio1_html5_sortable").sortable('disable');
	        	jQuery("#lbg_audio1_html5_updating_witness").css("display","block");
				var ord_stop=ui.item.prevAll().length + 1;
				var elem_id=ui.item.attr("id");
				var data = "action=lbg_audio1_html5_update_playlist_record&security=<?php echo esc_js($lbg_audio1_html5_update_playlist_record_ajax_nonce); ?>&updateType=change_ord&ord_start="+ord_start+"&ord_stop="+ord_stop+"&elem_id="+elem_id;
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
					jQuery("#lbg_audio1_html5_sortable").sortable('enable');
					jQuery("#lbg_audio1_html5_updating_witness").css("display","none");
				});
			}
		});
	}


	<?php
		$rows_count = $wpdb->get_var("SELECT COUNT(*) FROM ". $wpdb->prefix . "lbg_audio1_html5_playlist;");
		for ($i=1;$i<=$rows_count;$i++) {
	?>

            	jQuery('#upload_mp3_button_html5Audio1_<?php echo esc_js($i)?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							document.forms["form-playlist-html5-audio1-"+<?php echo esc_js($i)?>]['mp3'].value=attachment.url;
							});
						// Finally, open the modal
						file_frame.open();
				});

				jQuery('#upload_ogg_button_html5Audio1_<?php echo esc_js($i)?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							document.forms["form-playlist-html5-audio1-"+<?php echo esc_js($i)?>]['ogg'].value=attachment.url;
						});
						// Finally, open the modal
						file_frame.open();
				});


	jQuery("#form-playlist-html5-audio1-<?php echo esc_js($i)?>").submit(function(event) {

		/* stop form from submitting normally */
		event.preventDefault();

		//show loading image
		jQuery('#ajax-message-<?php echo esc_js($i)?>').html('<img src="<?php echo plugins_url('lbg-audio1-html5/images/ajax-loader.gif', dirname(__FILE__))?>" />');

		var data ="action=lbg_audio1_html5_update_playlist_record&security=<?php echo esc_js($lbg_audio1_html5_update_playlist_record_ajax_nonce); ?>&"+jQuery("#form-playlist-html5-audio1-<?php echo esc_js($i)?>").serialize();

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			var mov_title = '';
			if (document.forms["form-playlist-html5-audio1-<?php echo esc_js($i)?>"].title.value!='')
				mov_title=document.forms["form-playlist-html5-audio1-<?php echo esc_js($i)?>"].title.value;
			jQuery('#mov_title_'+document.forms["form-playlist-html5-audio1-<?php echo esc_js($i)?>"].id.value).html(mov_title);
			jQuery('#ajax-message-<?php echo esc_js($i)?>').html(response);
		});
	});
	<?php } ?>

});
</script>
<?php
		}
	}
}

add_action('wp_ajax_lbg_audio1_html5_update_playlist_record', 'lbg_audio1_html5_update_playlist_record_callback');

function lbg_audio1_html5_update_playlist_record_callback() {

	check_ajax_referer( 'lbg_audio1_html5_update_playlist_record-special-string', 'security' );
	global $wpdb;
	global $lbg_audio1_html5_messages;
	$errors_arr=array();

	//delete entire record
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='lbg_audio1_html5_delete_entire_record') {
		$delete_id=$_POST['delete_id'];
		$safe_sql=$wpdb->prepare("SELECT * FROM ".$wpdb->prefix."lbg_audio1_html5_playlist WHERE id = %d",$delete_id);
		$row = $wpdb->get_row($safe_sql, ARRAY_A);
		$row=lbg_audio1_html5_unstrip_array($row);


		//delete the entire record
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_audio1_html5_playlist WHERE id = %d",$delete_id));
		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=ord-1 WHERE playerid = %d and  ord>".$row['ord'],$_SESSION['xid']));
	}

	//update elements order
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='change_ord') {
		$sql_arr=array();
		$ord_start=$_POST['ord_start'];
		$ord_stop=$_POST['ord_stop'];
		$elem_id=(int)$_POST['elem_id'];
		$ord_direction='+1';
		if ($ord_start<$ord_stop)
			$sql_arr[]=$wpdb->prepare("UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=ord-1  WHERE playerid = %d and ord>".$ord_start." and ord<=".$ord_stop,$_SESSION['xid']);
		else
			$sql_arr[]=$wpdb->prepare("UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=ord+1  WHERE playerid = %d and ord>=".$ord_stop." and ord<".$ord_start,$_SESSION['xid']);
		$sql_arr[]=$wpdb->prepare("UPDATE ".$wpdb->prefix."lbg_audio1_html5_playlist SET ord=%d WHERE id=%d",$ord_stop,$elem_id);

		foreach ($sql_arr as $sql)
			$wpdb->query($sql);
	}



	//submit update
	if (!isset($_POST['updateType'])) {
		if (empty($_POST['mp3']))
			 $errors_arr[]=$lbg_audio1_html5_messages['empty_mp3'];
	}

	$theid=isset($_POST['id'])?$_POST['id']:0;
	if($theid>0 && !count($errors_arr)) {
		$except_arr=array('Submit'.$theid,'id','ord','action','security','updateType','pll_ajax_backend','page_scroll_to_id_instances');
		foreach ($_POST as $key=>$val){
			if (in_array($key,$except_arr)) {
				unset($_POST[$key]);
			}
		}

		$wpdb->update(
			$wpdb->prefix .'lbg_audio1_html5_playlist',
			$_POST,
			array( 'id' => $theid )
		);
		?>
			<div id="message" class="updated"><p><?php esc_html_e($lbg_audio1_html5_messages['data_saved'], 'lbg-audio1-html5' );?></p></div>
	<?php
	} else if (!isset($_POST['updateType'])) {
		$errors_arr[]=$lbg_audio1_html5_messages['invalid_request'];
	}

	if (count($errors_arr)) { ?>
		<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	<?php }

	die(); // this is required to return a proper result
}



add_action('wp_ajax_lbg_audio1_html5_preview_record', 'lbg_audio1_html5_preview_record_callback');

function lbg_audio1_html5_preview_record_callback() {
	check_ajax_referer( 'lbg_audio1_html5_preview_record-special-string', 'security' );
	$the_arr=array();

	$aux_val='<html>
					<head>
						<link href="'.plugins_url('audio1_html5/audio1_html5.css', __FILE__).'" rel="stylesheet" type="text/css">

						<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js" type="text/javascript"></script>
						<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js"></script>
						<script src="'.plugins_url('audio1_html5/js/jquery.mousewheel.min.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('audio1_html5/js/jquery.touchSwipe.min.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('audio1_html5/js/audio1_html5.js', __FILE__).'" type="text/javascript"></script>

					</head>
					<body style="padding:0px;margin:0px;">';

	$aux_val.=lbg_audio1_html5_generate_preview_code($_POST['theSliderID'],$the_arr);
	$aux_val.="</body>
				</html>";
	$filename=plugin_dir_path(__FILE__) . 'tpl/preview.html';
	$fp = fopen($filename, 'w+');
	$fwrite = fwrite($fp, $aux_val);

	echo $fwrite;

	die(); // this is required to return a proper result
}



?>
