var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	'use strict';

	jQuery( document ).ready( function() {

		// Image Hover Add-on Element View.
		FusionPageBuilder.image_hover_add_on = FusionPageBuilder.ElementView.extend( {

			/**
			 * Modify template attributes.
			 *
			 * @since 1.0
			 * @param {Object} atts - The attributes.
			 * @return {Object} atts - The attributes.
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.params );

				// Unique ID for this particular element instance, can be useful.
				attributes.cid = this.model.get( 'cid' );

				// Create attribute objects
				attributes.attr            = this.buildAttr( atts.params );
				attributes.imageAttr       = this.buildAttrImage( atts.params );
				attributes.captionAttr     = this.buildAttrCaption( atts.params );
				attributes.titleAttr       = this.buildAttrImageTitle( atts.params );
				attributes.descriptionAttr = this.buildAttrImageDescription( atts.params );

				// Any extras that need passed on.
				attributes.content          = atts.params.element_content;
				attributes.image            = atts.params.image;
				attributes.title            = atts.params.title;
				attributes.title_tag        = ( 'undefined' !== typeof atts.params.title_tag ) ? atts.params.title_tag : 'h3';
				attributes.description      = atts.params.description;
				attributes.link_url         = atts.params.link_url;
				attributes.background_color = atts.params.background_color;

				return attributes;
			},

			/**
			 * Modifies values.
			 *
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.width                 = _.fusionGetValueWithUnit( values.width );
				values.title_font_size       = _.fusionGetValueWithUnit( values.title_font_size );
				values.description_font_size = _.fusionGetValueWithUnit( values.description_font_size );
			},

			/**
			 * Builds the attributes array.
			 *
			 * @access public
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {array} Attributes array for wrapper.
			 */
			buildAttr: function( values ) {
				var attr = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fb-image-hover',
						style: ''
					} );

				attr['class'] += ' image-hover-' + values.hover_style;
				attr['class'] += ' imagehover-' + values.hover_style;

				attr['style'] += 'background-color:' + values.background_color + ';';
				attr['style'] += '--background-color:' + values.background_color + ';';

				if ( values.class ) {
					attr['class'] += ' ' + values.class;
				}

				if ( values.id ) {
					attr['id'] = values.id;
				}

				return attr;
			},

			/**
			 * Builds the attributes array.
			 *
			 * @access public
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {array} Attributes array for wrapper.
			 */
			buildAttrImage: function( values ) {
				var attr = {
					class: 'image-hover-img',
					style: '',
					src: '',
					srcset: ''
				};

				attr['src'] = values.image;

				if ( 'undefined' !== typeof values.image_retina ) {
					attr['srcset']  = values.image + ' 1x, ';
					attr['srcset'] += values.image_retina + ' 2x ';
				}

				attr['style'] = 'width:' + values.width + ';';

				return attr;
			},

			/**
			 * Builds the attributes array.
			 *
			 * @access public
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {array} Attributes array for wrapper.
			 */
			buildAttrCaption: function( values ) {
				var attr = {
					class: 'image-hover-img-caption',
					style: ''
				};

				attr['style'] += 'background-color: ' + values.background_color + ';';

				if ( -1 !== values.description.indexOf( '<img' ) ) {
					attr['style'] += 'padding: 0px;';
				}

				return attr;
			},

			/**
			 * Builds the attributes array.
			 *
			 * @access public
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {array} Attributes array for wrapper.
			 */
			buildAttrImageTitle: function( values ) {
				var attr = {
					class: 'image-hover-figtitle',
					style: ''
				};

				attr['style'] += 'font-size:' + values.title_font_size + ';';
				attr['style'] += 'color:' + values.title_color + ' !important;';

				return attr;
			},

			/**
			 * Builds the attributes array.
			 *
			 * @access public
			 * @since 1.0
			 * @param {Object} values - The values.
			 * @return {array} Attributes array for wrapper.
			 */
			buildAttrImageDescription: function( values ) {
				var attr = {
					class: 'image-hover-figdescription',
					style: ''
				};

				attr['style'] += 'font-size:' + values.description_font_size + ';';
				attr['style'] += 'color:' + values.description_color + ' !important;';

				return attr;
			}
		} );
	} );
}( jQuery ) );
