(function ($) {
    'use strict'

    window.jblog_iframe = window.jblog_iframe || {};

    function jblog_elements() {
        if (jblogElements) {
            jblogElements.forEach(function (element) {
                var name = "InlineShortcodeView_jblog_" + element.toLowerCase()

                window[name] = window.InlineShortcodeView.extend({
                    render: function () {
                        var model_id = this.model.get("id");
                        window[name].__super__.render.call(this);
                        vc.frame_window.vc_iframe.addActivity(function () {

                            if ( element.indexOf('Slider_') !== -1 && typeof this.jblog_iframe.slider === 'function') {
                                this.jblog_iframe.slider(model_id)
                            }

                            if ( element.indexOf('Block_') !== -1 && typeof this.jblog_iframe.block === 'function') {
                                this.jblog_iframe.block(model_id)
                            }
                        });
                        return this
                    }
                });
            })
        }
    }

    $(document).ready(function () {
        if (window.InlineShortcodeView) {
            jblog_elements()
        }
    })
})(jQuery);
