(function ($) {
    'use strict'

    $.fn.jblog_slider = function () {
        $(this).each(function () {

            var element = $(this)

            element.find('.jblog_slider_1').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    delay = element.data('delay')

                element.addClass('owl-carousel').owlCarousel({
                    nav: false,
                    items: 1,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    autoHeight: true,
                    loop: true,
                })
            });

            element.find('.jblog_slider_2').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    delay = element.data('delay')

                element.addClass('owl-carousel').owlCarousel({
                    nav: true,
                    navText: false,
                    items: 3,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    autoHeight: true,
                    loop: true,
                    margin: 30,
                    responsive: {
                      0: {items: 1},
                      768: {items: 2},
                      1024: {items: 3}
                    }
                })
            });

            element.find('.jblog_slider_3').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    delay = element.data('delay'),
                    thumbWrapper = element.find('.jeg_slide_thumb'),
                    slideWrapper = element.find('.slide_img'),
                    count = slideWrapper.find('.thumbnail-container').length,
                    index = 1

                if (autoplay) {
                    setInterval(function () {
                        element.find('.jeg_slide_next').trigger('click')
                    }, delay)
                }

                function prepareThumb() {
                    // clone image for nav
                    thumbWrapper.prepend(slideWrapper.html())
                    // set active
                    thumbWrapper.find('.thumbnail-container:nth-child(2)').addClass('active')
                    setTimeout(function () {
                        thumbWrapper.find('.thumbnail-container:nth-child(1),.thumbnail-container:nth-child(2)').css({
                            transform: 'translate3d(0, 0, 0)'
                        })
                    }, 10)
                }

                function prepareSlide() {
                    // move last to first
                    slideWrapper.prepend(slideWrapper.find('.thumbnail-container').last())
                    // set active
                    slideWrapper.find('.thumbnail-container:nth-child(2)').addClass('active')
                    setTimeout(function () {
                        slideWrapper.find('.thumbnail-container:nth-child(1),.thumbnail-container:nth-child(2)').css({
                            transform: 'translate3d(0, 0, 0)'
                        })
                    }, 10)
                }

                function prepareCaption() {
                    element.find('.slide_caption[data-index=0]').addClass('active')
                }

                function nextSlide() {
                    slideWrapper.find('.thumbnail-container.active').removeClass('active').next().css({
                        transform: 'translate3d(0, 0, 0)'
                    }).addClass('active')
                    nextSlideClone()
                }

                function nextSlideClone() {
                    slideWrapper.append(
                        slideWrapper.find('.thumbnail-container').first().css({
                            transform: 'translate3d(100%, 0, 0)'
                        })
                    )
                }

                function nextThumb() {
                    thumbWrapper.find('.thumbnail-container.active').removeClass('active').next().css({
                        transform: 'translate3d(0, 0, 0)'
                    }).addClass('active')
                    nextThumbClone()
                }

                function nextThumbClone() {
                    thumbWrapper.append(
                        thumbWrapper.find('.thumbnail-container').first().css({
                            transform: 'translate3d(100%, 0, 0)'
                        })
                    )
                }

                function updateCaption() {
                    element.find('.slide_caption.active').removeClass('active')
                    element.find('.slide_caption[data-index="' + (index - 1) + '"]').addClass('active')
                }

                function slideInfo() {
                    if (index > count) index = 1
                    if (index < 1) index = count
                    element.find('.jeg_slide_info').text(index + '/' + count)
                }

                function prevSlide() {
                    slideWrapper.find('.thumbnail-container.active').css({
                        transform: 'translate3d(100%, 0, 0)'
                    }).removeClass('active').prev().addClass('active')
                    prevSlideClone()
                }

                function prevSlideClone() {
                    slideWrapper.prepend(
                        slideWrapper.find('.thumbnail-container').last().css({
                            transform: 'translate3d(0, 0, 0)'
                        })
                    )
                }

                function prevThumb() {
                    thumbWrapper.find('.thumbnail-container.active').removeClass('active').css({
                        transform: 'translate3d(100%, 0, 0)'
                    }).prev().addClass('active')
                    prevThumbClone()
                }

                function prevThumbClone() {
                    thumbWrapper.prepend(
                        thumbWrapper.find('.thumbnail-container').last().css({
                            transform: 'translate3d(0, 0, 0)'
                        })
                    )
                }

                prepareThumb()
                prepareSlide()
                prepareCaption()

                element.find('.jeg_slide_next').on('click', function () {
                    index++
                    nextSlide()
                    slideInfo()
                    nextThumb()
                    updateCaption()
                })

                element.find('.jeg_slide_prev').on('click', function () {
                    index--
                    prevSlide()
                    slideInfo()
                    prevThumb()
                    updateCaption()
                })
            });

            element.find('.jblog_slider_4').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    delay = element.data('delay'),
                    navText = element.data('nav-text' )

                element.addClass('owl-carousel')
                .on('initialized.owl.carousel changed.owl.carousel', function(e) {
                    if (!e.namespace)  {
                      return;
                    }
                    var carousel = e.relatedTarget;
                    $('.slide_info').text(carousel.relative(carousel.current()) + 1 + '/' + carousel.items().length);
                  })
                .owlCarousel({
                    items: 1,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    autoHeight: true,
                    loop: true,
                    dots: false,
                    animateOut: 'fadeOut',
                    animateIn: 'fadeIn',
                    smartSpeed: 500,
                    mouseDrag: false,
                    touchDrag: false,
                    pullDrag: false,
                });

                $(element).find('.slide_nav a').on('click', function (e) {
                  e.preventDefault()

                  if ($(this).hasClass('next')) {
                    $(element).trigger('next.owl.carousel')
                  } else {
                    $(element).trigger('prev.owl.carousel')
                  }
                })
            });

            element.find('.jblog_slider_5').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    indexNav = element.find('.jeg_slide_index span'),
                    delay = element.data('delay');

                var slider = element.find('.jeg_slide_items').addClass('owl-carousel').owlCarousel({
                    nav: true,
                    navText: false,
                    items: 1,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    autoHeight: true,
                    loop: true,
                    dots: false,
                    animateOut: 'fadeOut',
                    animateIn: 'fadeIn',
                    smartSpeed: 500,
                    mouseDrag: false,
                    touchDrag: false,
                    pullDrag: false,
                    onChanged: function (e) {
                        var index = e.item.index;
                        indexNav.removeClass('active')

                        if (null != index && index > 0) {
                            $(indexNav.get(index - 2)).addClass('active')
                        }
                    }
                })

                $(indexNav.get(0)).addClass('active')

                indexNav.on('click', function () {
                    indexNav.removeClass('active')

                    var index = $(this).addClass('active').attr('data-index')

                    slider.trigger("to.owl.carousel", [index - 1, 1, true])
                })
            });

            element.find('.jblog_slider_6').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    delay = element.data('delay'),
                    dot = element.data('dots'),
                    nav = element.data('nav'),
                    wrapper = $(this)

                var set_nav_centered = function () {
                  var slider_nav = $(wrapper).find('.owl-nav')

                  if ($(slider_nav).length) {
                    var thumb = $(element).find('.thumbnail-container')
                    var thumb_height = $(thumb[0]).outerHeight()

                    $(slider_nav).each(function () {
                      var nav = $(this)
                      var nav_height = nav.outerHeight()
                      var top = (thumb_height * .5) - (nav_height * .5)
                      nav.css('top', top + 'px')
                    })
                  }
                }

                element.addClass('owl-carousel').owlCarousel({
                    nav: nav,
                    navText: false,
                    items: 4,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    margin: 35,
                    dots: dot,
                    loop: true,
                    responsive: {
                      0: {items: 1},
                      576: {items: 2},
                      768: {items: 3},
                      1024: {items: 4}
                    },
                    onInitialized: function () {
                      set_nav_centered()
                    },
                })
            });

            element.find('.jblog_slider_7').each(function () {
                var element = $(this),
                    autoplay = element.data('autoplay'),
                    items = element.data('item'),
                    delay = element.data('delay')

                element.addClass('owl-carousel').owlCarousel({
                    nav: false,
                    items: items,
                    autoplay: autoplay,
                    autoplayTimeout: delay,
                    margin: 40,
                    loop: true,
                    responsive: {
                      0: {items: 1},
                      576: {items: 2},
                      768: {items: 3},
                      1024: {items: items}
                    }
                })
            });
        });
    }

    $(window).load(function(){
        $('body').jblog_slider();
    });

})(jQuery);

(function ($) {
    'use strict'

    $.fn.jblog_block = function () {
        $(this).each(function () {

            var element = $(this),
                xhrCache = []

            element.find('.jeg_block_loadmore').each(function () {
                var wrapperNav = $(this),
                    container = wrapperNav.parents('.jeg_postblock'),
                    unique = container.data('unique'),
                    blockData = window[unique],
                    loadLimit = blockData.pagination_scroll_limit,
                    parameter = {
                        'action': jbp_elements_option.block_prefix + blockData.class,
                        'data': {
                            'current_page': 1,
                            'attr': blockData
                        }
                    },
                    type = blockData.pagination_mode,
                    lockLoad = false

                if ('scrollload' === type) {
                    scrollHandler()
                }

                wrapperNav.find('a').on('click', function (e) {
                    e.preventDefault()
                    if (!lockLoad && !wrapperNav.hasClass('disabled')) {
                        requestAjax()
                    }
                })

                function scrollHandler() {
                    if (!lockLoad && !wrapperNav.hasClass('disabled')) {
                        if (loadLimit >= parameter.data.current_page || loadLimit == '0') {
                            wrapperNav.find('a').waypoint(function () {
                                requestAjax()
                                this.destroy()
                            }, {
                                offset: '100%',
                                context: window
                            });
                        }
                    }
                }

                function requestAjax() {
                    requestBeforeAjax()
                    parameter.data.current_page = parameter.data.current_page + 1
                    var result = getChace(parameter)

                    if (result) {
                        renderAjaxResponse(result)
                    } else {
                        $.ajax({
                            url: jbp_elements_ajax_url,
                            type: 'post',
                            dataType: 'json',
                            data: parameter,
                            success: function (response) {
                                renderAjaxResponse(response)
                                saveCache(parameter, response)
                            }
                        })
                    }
                }

                function saveCache(parameter, response) {
                    xhrCache.push({
                        param: JSON.stringify(parameter),
                        result: response
                    })
                }

                function getChace(parameter) {
                    var jsonparam = JSON.stringify(parameter)

                    for (var i = 0; i < xhrCache.length; i++) {
                        if (jsonparam === xhrCache[i].param) {
                            return prepareCache(xhrCache[i].result)
                        }
                    }
                }

                function prepareCache(result) {
                    result.content = '<div>' + result.content + '</div>'
                    var content = $(result.content)

                    content.find('img').each(function () {
                        var src = $(this).data('src')
                        $(this).attr('src', src).removeClass('lazyload').addClass('lazyloaded')
                    })

                    result.content = content.html()
                    return result
                }

                function renderAjaxResponse(response) {
                    var content = $(response.content),
                        count = 0

                    content.each(function () {
                        if ($(this).hasClass('jeg_post')) {
                            $(this).addClass('jeg_ajax_loaded anim_' + count)
                        }
                        count++
                    })

                    container.find('.jblog_ajax_flag').append(content)

                    if (!response.next) {
                        wrapperNav.addClass('disabled')
                    }

                    requestAfterAjax()
                    $(window).trigger('resize')

                    if ('scrollload' === type) {
                        setTimeout(function () {
                            scrollHandler()
                        }, 500);
                    }
                }

                function requestBeforeAjax() {
                    lockLoad = true
                    wrapperNav.addClass('loading')
                    wrapperNav.find('a').text(wrapperNav.find('a').data('loading'))
                }

                function requestAfterAjax() {
                    lockLoad = false
                    wrapperNav.removeClass('loading')
                    wrapperNav.find('a').text(wrapperNav.find('a').data('load'))
                }
            })
        })
    }

    $(document).ready($('body').jblog_block())
})(jQuery);

(function ($) {
    'use strict'

    window.onYouTubeIframeAPIReady = function () {
        $('.jblog_blocklink .jeg_videobg').each(function () {
            $(this).jvideo_background()
        })
    }

    $(document).ready(function () {
        $('.jblog-post-toggle-comment').on('click', function () {
            var element = $(this),
                hide = element.data('hide'),
                show = element.data('show'),
                comment = $('.jblog-post-comment')

            if (element.hasClass('hide')) {
                element.find('span').text(hide)
                comment.slideDown('slow')
            } else {
                element.find('span').text(show)
                comment.slideUp('slow')
            }

            element.toggleClass('hide')
        })
    })

})(jQuery);
