<?php

spl_autoload_register( function ( $class ) {
	$prefix  = 'JBP\\Elements\\';
	$baseDir = JBP_ELEMENTS_DIR . 'includes/class/';

	$len = strlen( $prefix );

	if ( strncmp( $prefix, $class, $len ) !== 0 ) {
		return;
	}

	$relativeClass = substr( $class, $len );

	$file = rtrim( $baseDir, '/' ) . '/' . str_replace( '\\', '/', $relativeClass ) . '.php';
	$file = str_replace( '_', '-', strtolower( $file ) );

	if ( is_link( $file ) ) {
		$file = readlink( $file );
	}

	if ( is_file( $file ) ) {
		require $file;
	}
} );
