<?php

namespace JBP\Elements\Archive;

use JBP\Elements\Init;
use Jeg\Element\Element;
use Jeg\Element\Elements\Elements_Manager;

/**
 * Class Archive
 * @package JBP\Elements\Util
 */
class Archive {
	/**
	 * Instance of Video_Thumbnail
	 *
	 * @var Archive
	 */
	private static $instance;

	/**
	 * Element Manager
	 *
	 * @var Elements_Manager;
	 */
	private $manager;


	const POST_TYPE = 'archive-template';

	/**
	 * Singleton for Video_Thumbnail Class
	 *
	 * @return Archive
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Video_Thumbnail constructor
	 */
	private function __construct() {
		$this->intiialize();
		$this->hook();
	}

	public function intiialize() {
		$this->manager = Element::instance()->manager;
	}

	/**
	 * Hook
	 */
	public function hook() {
		add_action( 'init', array( $this, 'post_type' ), 9 );
		add_action( 'jeg_archive_custom_template_header', array( $this, 'archive_template_header' ) );
		add_action( 'jeg_archive_custom_template_footer', array( $this, 'archive_template_footer' ) );
		add_action( 'jeg_render_archive', array( $this, 'render_archive' ), 1, 2 );
		add_filter( 'jeg_archive_template_post_type', array( $this, 'archive_template' ) );
		add_filter( 'template_include', array( $this, 'template_include' ) );
		add_filter( 'option_elementor_cpt_support', array( $this, 'force_add_cpt' ) );
		add_filter( 'jeg_category_hero_default', array( $this, 'default_hero' ) );
		add_filter( 'jeg_render_archive_hero', array( $this, 'render_hero' ), null, 4 );
	}

	public function default_hero() {
		return 'Hero_2';
	}


	public function render_hero( $total, $show, $template, $attr ) {
		if ( isset( $show ) && $show ) {
			$element_id          = 'jblog_' . strtolower( $template );
			$option              = $this->manager->get_element_option( $element_id );
			$number_post         = $option->get_number_post();
			$attr['number_post'] = $number_post;

			$view = $this->manager->get_element_view( $element_id );
			echo jblog_sanitize_output( $view->build_element( $attr ) );

			return $number_post;
		} else {
			$total = 0;
		}

		return $total;
	}

	/**
	 * @param $value
	 *
	 * @return int
	 */
	public function force_add_cpt( $value ) {
		array_push( $value, self::POST_TYPE );

		return $value;
	}

	/**
	 * Archive Template Header
	 */
	public function archive_template_header() {
		get_header();
	}

	/**
	 * Archive Template Footer
	 */
	public function archive_template_footer() {
		get_footer();
	}


	/**
	 * Template Include
	 *
	 * @param string $template
	 *
	 * @return mixed
	 */
	public function template_include( $template ) {
		if ( self::POST_TYPE === get_post_type() ) {
			return JBP_ELEMENTS_DIR . 'includes/class/templates/archive-template.php';
		}

		return $template;
	}


	/**
	 * Render Archive
	 */
	public function render_archive( $custom, $template_id ) {
		if ( $custom ) {
			remove_all_actions( 'jeg_render_archive' )
			?>
			<div class="jeg-container">
				<?php $this->render_custom_archive( $template_id ); ?>
			</div>
			<?php
			do_action( 'jeg_after_render_archive' );
		}
	}

	/**
	 * Render Custom Archive
	 *
	 * @param $template_id
	 */
	public function render_custom_archive( $template_id ) {
		if ( jeg_is_frontend_vc() || jeg_is_frontend_elementor() ) {
			the_post();
			the_content();
		} else {
			global $post;
			if ( $template_id ) {
				$post = get_post( $template_id );
				setup_postdata( $post );
				$this->archive_css( $post );
				the_content();
				wp_reset_postdata();
			}
		}
	}


	/**
	 * Render footer CSS
	 *
	 * @param object $post Footer post
	 *
	 * @return string
	 */
	protected function archive_css( $post ) {
		if ( get_post_meta( $post->ID, '_elementor_edit_mode', true ) === 'builder' ) {
			$style = get_post_meta( $post->ID, '_elementor_page_settings', true );

			if ( ! empty( $style['custom_css'] ) ) {
				echo '<style type="text/css" data-type="elementor_custom-css">' . $style['custom_css'] . '</style>';
			}
		} else {
			$post_custom_css = get_post_meta( $post->ID, '_wpb_post_custom_css', true );

			if ( ! empty( $post_custom_css ) ) {
				$post_custom_css = strip_tags( $post_custom_css );
				echo '<style type="text/css" data-type="vc_custom-css">';
				echo jeg_sanitize( $post_custom_css );
				echo '</style>';
			}

			$shortcodes_custom_css = get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );

			if ( ! empty( $shortcodes_custom_css ) ) {
				$shortcodes_custom_css = strip_tags( $shortcodes_custom_css );
				echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
				echo jeg_sanitize( $shortcodes_custom_css );
				echo '</style>';
			}
		}
	}


	/**
	 * Archive Template
	 */
	public function archive_template() {
		return self::POST_TYPE;
	}

	/**
	 * Post Type
	 */
	public function post_type() {
		register_post_type( self::POST_TYPE, array(
			'labels'          =>
				array(
					'name'               => esc_html__( 'Archive Template', 'jbp' ),
					'singular_name'      => esc_html__( 'Archive Template', 'jbp' ),
					'menu_name'          => esc_html__( 'Archive Template', 'jbp' ),
					'add_new'            => esc_html__( 'New Archive Template', 'jbp' ),
					'add_new_item'       => esc_html__( 'Build Archive Template', 'jbp' ),
					'edit_item'          => esc_html__( 'Edit Archive Template', 'jbp' ),
					'new_item'           => esc_html__( 'New Archive Template Entry', 'jbp' ),
					'view_item'          => esc_html__( 'View Archive Template', 'jbp' ),
					'search_items'       => esc_html__( 'Search Archive Template', 'jbp' ),
					'not_found'          => esc_html__( 'No entry found', 'jbp' ),
					'not_found_in_trash' => esc_html__( 'No Archive Template in Trash', 'jbp' ),
					'parent_item_colon'  => ''
				),
			'description'     => esc_html__( 'Single Archive Template', 'jbp' ),
			'public'          => true,
			'show_ui'         => true,
			'menu_position'   => 8,
			'menu_icon'       => 'dashicons-tag',
			'capability_type' => 'post',
			'hierarchical'    => false,
			'supports'        => array( 'title', 'editor' ),
			'map_meta_cap'    => true,
			'rewrite'         => array(
				'slug' => self::POST_TYPE
			)
		) );
	}
}
