<?php

namespace JBP\Elements\Archive;

use Jeg\Form\Form_Archive;

abstract class Options_Abstract {

	/**
	 * Get term ID
	 *
	 * @param $term
	 *
	 * @return null
	 */
	protected function get_id( $term ) {
		if ( ! empty( $term->term_id ) ) {
			return $term->term_id;
		} else {
			return null;
		}
	}

	/**
	 * Render archive options
	 *
	 * @param $tag
	 */
	public function render_archive_options( $tag ) {
		$id = $this->get_id( $tag );

		if ( null !== $id ) {
			$segments = $this->prepare_segments();
			$fields   = $this->prepare_fields( $id );
			$form_id  = 'archive-' . $id;

			Form_Archive::render_form( $form_id, $segments, $fields );
		}
	}

	/**
	 * Prepare option fields
	 *
	 * @param $term_id
	 *
	 * @return array
	 */
	public function prepare_fields( $term_id ) {
		$setting = [];
		$fields  = $this->get_archive_options();

		foreach ( $fields as $key => $field ) {
			$setting[ $key ]                = [];
			$setting[ $key ]['id']          = $key;
			$setting[ $key ]['fieldID']     = $key . '_' . $term_id;
			$setting[ $key ]['fieldName']   = $key;
			$setting[ $key ]['type']        = $field['type'];
			$setting[ $key ]['title']       = isset( $field['title'] ) ? $field['title'] : '';
			$setting[ $key ]['description'] = isset( $field['desc'] ) ? $field['desc'] : '';
			$setting[ $key ]['segment']     = isset( $field['segment'] ) ? sanitize_title_with_dashes( $field['segment'] ) : '';
			$setting[ $key ]['default']     = isset( $field['default'] ) ? $field['default'] : '';
			$setting[ $key ]['priority']    = isset( $field['priority'] ) ? $field['priority'] : 10;
			$setting[ $key ]['options']     = isset( $field['options'] ) ? $field['options'] : [];
			$setting[ $key ]['dependency']  = isset( $field['dependency'] ) ? $field['dependency'] : [];
			$setting[ $key ]['multiple']    = isset( $field['multiple'] ) ? $field['multiple'] : 1;
			$setting[ $key ]['ajax']        = isset( $field['ajax'] ) ? $field['ajax'] : '';
			$setting[ $key ]['nonce']       = isset( $field['nonce'] ) ? $field['nonce'] : '';
			$setting[ $key ]['fields']      = isset( $field['fields'] ) ? $field['fields'] : [];
			$setting[ $key ]['row_label']   = isset( $field['row_label'] ) ? $field['row_label'] : [];

			$setting[ $key ]['value'] = $this->get_value( $key, $term_id, $setting[ $key ]['default'] );
		}

		return $setting;
	}

	/**
	 * Get option value
	 *
	 * @param $key
	 * @param $term_id
	 * @param $default
	 *
	 * @return mixed
	 */
	public function get_value( $key, $term_id, $default ) {
		$value = get_option( $key, false );

		if ( isset( $value[ $term_id ] ) ) {
			return $value[ $term_id ];
		} else {
			return $default;
		}
	}

	/**
	 * Save option value handler
	 *
	 * @param $options
	 * @param $input
	 */
	protected function do_save( $options, $input ) {
		foreach ( $options as $key => $field ) {
			if ( isset( $field['items'] ) ) {
				foreach ( $field['items'] as $key1 => $value1 ) {
					$option = isset( $_POST[ $key1 ] ) ? $_POST[ $key1 ] : false;
					$this->save_value( $key1, $input, $option );
				}
			} else {
				$option = isset( $_POST[ $key ] ) ? $_POST[ $key ] : false;
				$this->save_value( $key, $input, $option );
			}
		}
	}

	/**
	 * Save option value
	 *
	 * @param $key
	 * @param $term_id
	 * @param $value
	 */
	protected function save_value( $key, $term_id, $value ) {
		$values             = get_option( $key, [] );
		$values[ $term_id ] = $value;
		update_option( $key, $values );
	}

	abstract protected function get_archive_options();

	abstract protected function prepare_segments();

	abstract protected function setup_hook();
}
