<?php

namespace JBP\Elements\Archive;

class Options_Author extends Options_Abstract {

	/**
	 * @var Options_Author
	 */
	protected static $instance;

	/**
	 * @return Options_Author
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Options_Author constructor.
	 */
	protected function __construct() {
		$this->setup_hook();
	}

	/**
	 * Register hook
	 */
	protected function setup_hook() {
		add_action( 'show_user_profile', [ $this, 'render_archive_options' ] );
		add_action( 'edit_user_profile', [ $this, 'render_archive_options' ] );

		add_action( 'edit_user_profile_update', [ $this, 'save_author' ] );
		add_action( 'personal_options_update',  [ $this, 'save_author' ] );
	}

	/**
	 * Get user ID
	 *
	 * @param $user
	 *
	 * @return null
	 */
	protected function get_id( $user ) {
		if ( ! isset( $user->ID ) || empty( $user->ID ) ) {
			return null;
		} else {
			return $user->ID;

		}
	}

	/**
	 * Save author options
	 */
	public function save_author( $user_id ) {
		if ( current_user_can( 'edit_user', $user_id ) ) {
			$options = $this->get_archive_options();
			$this->do_save( $options, $_POST['user_id'] );
		}
	}

	/**
	 * Prepare segment options
	 *
	 * @return array
	 */
	public function prepare_segments() {
		$segments = [];

		$segments[] = [
			'id'   => 'override-author-setting',
			'name' => esc_html__( 'Author Setting', 'jblog-elements' ),
		];

		return $segments;
	}

	/**
     * Get archive options
     *
	 * @return array
	 */
	public function get_archive_options() {
		$options   = [];
		$post_type = apply_filters( 'jeg_archive_template_post_type', '' );

		$options['jbp_author_override'] = [
			'segment' => 'override-author-setting',
			'title'   => esc_html__( 'Override Author Setting', 'jblog-elements' ),
			'desc'    => esc_html__( 'Override author general setting.', 'jblog-elements' ),
			'type'    => 'checkbox',
			'default' => false
		];

		$options['jbp_author_template'] = [
			'segment'    => 'override-author-setting',
			'title'      => esc_html__( 'Author Template', 'jblog-elements' ),
			'desc'       => wp_kses( sprintf( __( 'Create custom archive page template from <a href="%s" target="_blank">here</a>', 'jblog' ), get_admin_url() . 'edit.php?post_type=' . $post_type ), wp_kses_allowed_html() ),
			'type'       => 'select',
			'options'    => jblog_get_all_custom_post_type( $post_type ),
			'dependency' => [
				[
					'field'    => 'jbp_author_override',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$options['jbp_author_posts_per_page'] = [
			'segment'    => 'override-author-setting',
			'title'      => esc_html__( 'Number of Post', 'jblog-elements' ),
			'desc'       => esc_html__( 'Set the number of post per page on the author page.', 'jblog-elements' ),
			'type'       => 'number',
			'options'    => [
				'min'  => '0',
				'max'  => '50',
				'step' => '1'
			],
			'default'    => get_option( 'posts_per_page' ),
			'dependency' => [
				[
					'field'    => 'jbp_author_override',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		return $options;
	}
}
