<?php

namespace JBP\Elements\Archive;

class Options_Tag extends Options_Abstract {

	/**
	 * @var Options_Tag
	 */
	protected static $instance;

	/**
	 * @return Options_Tag
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Options_Tag constructor.
	 */
	protected function __construct() {
		$this->setup_hook();
	}

	/**
	 * Register hook
	 */
	protected function setup_hook() {
		add_action( 'edit_tag_form', [ $this, 'render_archive_options' ] );
		add_action( 'edit_post_tag', [ $this, 'save_tag' ] );
	}

	/**
	 * Save tag options
	 */
	public function save_tag() {
		if ( isset( $_POST['taxonomy'] ) && $_POST['taxonomy'] === 'post_tag' ) {
			$options = $this->get_archive_options();
			$this->do_save( $options, $_POST['tag_ID'] );
		}
	}

	/**
	 * Prepare segment options
	 *
	 * @return array
	 */
	public function prepare_segments() {
		$segments = [];

		$segments[] = [
			'id'   => 'override-tag-setting',
			'name' => esc_html__( 'Tag Setting', 'jblog-elements' ),
		];

		return $segments;
	}

	/**
     * Get archive options
     *
	 * @return array
	 */
	public function get_archive_options() {
		$options   = [];
		$post_type = apply_filters( 'jeg_archive_template_post_type', '' );

		$options['jbp_tag_override'] = [
			'segment' => 'override-tag-setting',
			'title'   => esc_html__( 'Override Tag Setting', 'jblog-elements' ),
			'desc'    => esc_html__( 'Override tag general setting.', 'jblog-elements' ),
			'type'    => 'checkbox',
			'default' => false
		];

		$options['jbp_tag_template'] = [
			'segment'    => 'override-tag-setting',
			'title'      => esc_html__( 'Tag Template', 'jblog-elements' ),
			'desc'       => wp_kses( sprintf( __( 'Create custom archive page template from <a href="%s" target="_blank">here</a>', 'jblog' ), get_admin_url() . 'edit.php?post_type=' . $post_type ), wp_kses_allowed_html() ),
			'type'       => 'select',
			'options'    => jblog_get_all_custom_post_type( $post_type ),
			'dependency' => [
				[
					'field'    => 'jbp_tag_override',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$options['jbp_tag_posts_per_page'] = [
			'segment'    => 'override-tag-setting',
			'title'      => esc_html__( 'Number of Post', 'jblog-elements' ),
			'desc'       => esc_html__( 'Set the number of post per page on the tag page.', 'jblog-elements' ),
			'type'       => 'number',
			'options'    => [
				'min'  => '0',
				'max'  => '50',
				'step' => '1'
			],
			'default'    => get_option( 'posts_per_page' ),
			'dependency' => [
				[
					'field'    => 'jbp_tag_override',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		return $options;
	}
}
