<?php

namespace JBP\Elements\Customizer;

use Jeg\Customizer\Customizer;

/**
 * Class Options
 * @package JBP\Elements\Customizer
 */
class Options {

	/**
	 * @var Options
	 */
	private static $instance;

	/**
	 * @return Options
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Options constructor.
	 */
	private function __construct() {
		add_action( 'jeg_register_customizer_option', [ $this, 'register_lazy_section' ], 91 );
		add_filter( 'jeg_register_lazy_section', [ $this, 'load_customizer' ] );
		add_filter( 'jeg_redirect_tag', [ $this, 'setup_redirect_tag' ], 99 );
	}

	/**
	 * @param $result
	 *
	 * @return mixed
	 */
	public function load_customizer( $result ) {
		$array = [ 'single_template', 'category_template', 'tag_template', 'author_template' ];

		$path = JBP_ELEMENTS_DIR . 'includes/class/customizer/sections/';

		foreach ( $array as $id ) {
			$result["jblog_{$id}_section"][] = "{$path}{$id}.php";
		}

		return $result;
	}

	/**
	 * Register option
	 */
	public function register_lazy_section() {
		$customizer = Customizer::get_instance();
		$this->option( $customizer );
	}

	/**
	 * @param $customizer Customizer
	 */
	protected function option( $customizer ) {
		$this->set_panel( $customizer );
		$this->set_section( $customizer );
	}

	/**
	 * Set panel
	 *
	 * @param $customizer
	 */
	protected function set_panel( $customizer ) {
		$customizer->add_panel( [
			'id'          => 'jblog_custom_template_panel',
			'title'       => esc_html__( 'JBlog : Custom Template', 'jblog-elements' ),
			'description' => esc_html__( 'Custom Template', 'jblog-elements' ),
			'priority'    => 171
		] );
	}

	/**
	 * Set section
	 *
	 * @param $customizer
	 */
	protected function set_section( $customizer ) {
		$customizer->add_section( [
			'id'       => 'jblog_single_template_section',
			'title'    => esc_html__( 'Single Template', 'jblog-elements' ),
			'panel'    => 'jblog_custom_template_panel',
			'priority' => 171,
			'type'     => 'jeg-lazy-section',
		] );

		$customizer->add_section( [
			'id'       => 'jblog_category_template_section',
			'title'    => esc_html__( 'Category Template', 'jblog-elements' ),
			'panel'    => 'jblog_custom_template_panel',
			'priority' => 171,
			'type'     => 'jeg-lazy-section',
		] );

		$customizer->add_section( [
			'id'       => 'jblog_tag_template_section',
			'title'    => esc_html__( 'Tag Template', 'jblog-elements' ),
			'panel'    => 'jblog_custom_template_panel',
			'priority' => 171,
			'type'     => 'jeg-lazy-section',
		] );

		$customizer->add_section( [
			'id'       => 'jblog_author_template_section',
			'title'    => esc_html__( 'Author Template', 'jblog-elements' ),
			'panel'    => 'jblog_custom_template_panel',
			'priority' => 171,
			'type'     => 'jeg-lazy-section',
		] );
	}

	/**
	 * Setup redirect tag for customizer
	 */
	public function setup_redirect_tag( $redirect ) {
		$redirect['single_tag'] = array(
			'url'  => $this->get_single_url(),
			'flag' => is_singular( 'post' ),
			'text' => esc_html__( 'Single Post', 'jblog-elements' ),
		);

		$redirect['category_tag'] = array(
			'url'  => $this->get_category_url(),
			'flag' => is_category(),
			'text' => esc_html__( 'Category Page', 'jblog' ),
		);

		$redirect['post_tag'] = array(
			'url'  => $this->get_tag_url(),
			'flag' => is_tag(),
			'text' => esc_html__( 'Tag Page', 'jblog' ),
		);

		$redirect['author_tag'] = array(
			'url'  => $this->get_author_url(),
			'flag' => is_author(),
			'text' => esc_html__( 'Author Page', 'jblog' ),
		);

		return $redirect;
	}

	/**
	 * Get random author page url
	 *
	 * @return string
	 */
	public function get_author_url() {
		$user = wp_get_current_user();

		return get_author_posts_url( $user->ID );
	}

	/**
	 * Get post tag url
	 *
	 * @return false|null|string
	 */
	public function get_tag_url() {
		$terms = get_terms( array(
			'taxonomy'   => 'post_tag',
			'hide_empty' => false,
			'number'     => 1,
		) );

		if ( $terms ) {
			return get_term_link( $terms[0]->term_id );
		} else {
			return null;
		}
	}

	/**
	 * Get category url
	 *
	 * @return false|null|string
	 */
	public function get_category_url() {
		$terms = get_terms( array(
			'taxonomy'   => 'category',
			'hide_empty' => false,
			'number'     => 1,
		) );

		if ( $terms ) {
			return get_term_link( $terms[0]->term_id );
		} else {
			return null;
		}
	}

	/**
	 * Get single post url
	 *
	 * @return false|null|string
	 */
	public function get_single_url() {
		$posts = get_posts( 'orderby=rand&numberposts=1&post_type=post' );

		if ( $posts ) {
			return get_permalink( $posts[0]->ID );
		} else {
			return null;
		}
	}
}
