<?php

$options   = [];
$post_type = apply_filters( 'jeg_archive_template_post_type', '' );

$options[] = [
	'id'          => 'jbp[author_template_custom]',
	'option_type' => 'option',
	'transport'   => 'postMessage',
	'default'     => '',
	'type'        => 'jeg-select',
	'label'       => esc_html__( 'Custom Author Template', 'jblog-elements' ),
	'description' => wp_kses( sprintf( __( 'You can create custom archive template from <a href="%s" target="_blank">here</a>.', 'jblog-elements' ), get_admin_url() . 'edit.php?post_type=' . $post_type ), wp_kses_allowed_html() ),
	'choices'     => jblog_get_all_custom_post_type( $post_type ),
	'postvar'     => [
		[
			'redirect' => 'author_tag',
			'refresh'  => true
		]
	]
];

$options[] = [
	'id'          => 'jbp[author_posts_per_page]',
	'option_type' => 'option',
	'transport'   => 'postMessage',
	'default'     => get_option( 'posts_per_page' ),
	'type'        => 'jeg-number',
	'label'       => esc_html__( 'Number of Post', 'jblog-elements' ),
	'description' => esc_html__( 'Set the number of post per page on the author page.', 'jblog-elements' ),
	'choices'     => [
		'min'  => '0',
		'max'  => '50',
		'step' => '1',
	],
	'postvar'     => [
		[
			'redirect' => 'author_tag',
			'refresh'  => true
		]
	]
];

return $options;
