<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Archive_Block_Option
 * @package JBP\Elements\Elements\Options
 */
class Archive_Block_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Archive Block', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Archive Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$small_block = $short_block = $long_block = [];

		foreach ( apply_filters( 'jeg_element_small_block', [] ) as $item ) {
			$small_block[ $item ] = esc_html__( 'JBlog - ' . str_replace( '_', ' - ', $item ), 'jblog-elements' );
		}

		foreach ( apply_filters( 'jeg_element_short_block', [] ) as $key => $item ) {
			$short_block[ $key ] = esc_html__( 'JBlog - ' . str_replace( '_', ' - ', $key ), 'jblog-elements' );
		}

		foreach ( apply_filters( 'jeg_element_long_block', [] ) as $key => $item ) {
			$long_block[ $key ] = esc_html__( 'JBlog - ' . str_replace( '_', ' - ', $key ), 'jblog-elements' );
		}

		$this->options['column'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Column Width', 'jblog-elements' ),
			'description' => esc_html__( 'Choose the column width base that you use for the block element.', 'jblog-elements' ),
			'options'     => [
				'4'  => esc_html__( '4 Columns', 'jblog-elements' ),
				'8'  => esc_html__( '8 Columns', 'jblog-elements' ),
				'12' => esc_html__( '12 Columns', 'jblog-elements' ),
			],
			'default'     => '12',
			'segment'     => 'general',
		];

		$this->options['small-block'] = [
			'type'        => 'select',
			'title'       => esc_html__( '4 Columns Block', 'jblog-elements' ),
			'description' => esc_html__( 'Choose the block element that you want to use.', 'jblog-elements' ),
			'options'     => $small_block,
			'default'     => 'Block_3',
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'column',
					'operator' => '==',
					'value'    => '4',
				],
			],
		];

		$this->options['medium-block'] = [
			'type'        => 'select',
			'title'       => esc_html__( '8 Columns Block', 'jblog-elements' ),
			'description' => esc_html__( 'Choose the block element that you want to use.', 'jblog-elements' ),
			'options'     => $short_block,
			'default'     => 'Block_1',
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'column',
					'operator' => '==',
					'value'    => '8',
				],
			],
		];

		$this->options['long-block'] = [
			'type'        => 'select',
			'title'       => esc_html__( '12 Columns Block', 'jblog-elements' ),
			'description' => esc_html__( 'Choose the block element that you want to use.', 'jblog-elements' ),
			'options'     => $long_block,
			'default'     => 'Block_4',
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'column',
					'operator' => '==',
					'value'    => '12',
				],
			],
		];

		$this->options['number_post'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Number of Post', 'jblog-element' ),
			'description' => esc_html__( 'Show number of post on this block.', 'jblog-element' ),
			'segment'     => 'general',
			'options'     => [
				'min'  => 1,
				'max'  => 30,
				'step' => 1,
			],
			'default'     => 3
		];

		$this->options['date_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post date type that you want to use.', 'jblog-elements' ),
			'default'     => 'published',
			'segment'     => 'general',
			'options'     => [
				'published' => esc_html__( 'Published Date', 'jblog-elements' ),
				'modified'  => esc_html__( 'Modified Date', 'jblog-elements' ),
				'both'      => esc_html__( 'Show Both', 'jblog-elements' ),
			],
		];

		$this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use for single post.', 'jblog-elements' ),
			'default'     => 'default',
			'segment'     => 'general',
			'options'     => [
				'ago'     => esc_attr__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_attr__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_attr__( 'Custom Format', 'jblog-elements' ),
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Post Date Custom Format', 'jblog-elements' ),
			'description' =>
				wp_kses(
					sprintf(
						__( 'Insert custom date format for single post meta. For more detail about this format, please refer to <a href="%s" target="_blank">Developer Codex</a>.', 'jblog-elements' ),
						'https://wordpress.org/support/article/formatting-date-and-time/'
					),
					wp_kses_allowed_html()
				),
			'default'     => get_option( 'date_format' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			]
		];
	}
}
