<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Archive_Title_Option
 * @package JBP\Elements\Elements\Options
 */
class Archive_Title_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Archive Title', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Archive Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['label'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Archive Label', 'jblog-elements' ),
			'description' => esc_html__( 'Insert some text as archive label.', 'jblog-elements' ),
			'default'     => esc_html__( 'Category: ', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['color'] = [
			'type'        => 'color',
			'title'       => esc_html__( 'Title Color', 'jblog-elements' ),
			'description' => esc_html__( 'Set the title color.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['font-size'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Font Size', 'jblog-elements' ),
			'description' => esc_html__( 'Set font size with unit (Ex: 36px or 4em).', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['align'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Title Align', 'jblog-elements' ),
			'description' => esc_html__( 'Set alignment for the archive title.', 'jblog-elements' ),
			'default'     => 'left',
			'segment'     => 'general',
			'options'     => [
				'left'   => esc_html__( 'Left Align', 'jblog-elements' ),
				'right'  => esc_html__( 'Right Align', 'jblog-elements' ),
				'center' => esc_html__( 'Center Align', 'jblog-elements' ),
			],
		];
	}
}
