<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Block_17_Option
 * @package JBP\Elements\Elements\Options
 */
class Block_17_Option extends Block_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 4;

	/**
	 * Default number of post ajax
	 *
	 * @var int
	 */
	protected $number_post_ajax = 4;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 8 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block 17', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '8 Columns', 'jblog-elements' );
	}
}
