<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Block_18_Option
 * @package JBP\Elements\Elements\Options
 */
class Block_18_Option extends Block_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 3;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 8 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block 18', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '8 Columns', 'jblog-elements' );
	}
}
