<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Block_23_Option
 * @package JBP\Elements\Elements\Options
 */
class Block_23_Option extends Block_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 3;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 12 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block 23', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '12 Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_content_filter_option( $this->number_post );
		$this->pagination_option( $this->number_post_ajax );
		$this->set_style_option();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->set_content_filter_segment();
		$this->set_pagination_segment();
		$this->set_style_segment();
	}
}
