<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Block_3_Option
 * @package JBP\Elements\Elements\Options
 */
class Block_3_Option extends Block_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 3;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 4 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block 3', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '4 Columns', 'jblog-elements' );
	}
}
