<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Block_Option_Abstract
 * @package JBP\Elements\Elements\Options
 */
abstract class Block_Option_Abstract extends Elements_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 3;

	/**
	 * Default number of post ajax
	 *
	 * @var int
	 */
	protected $number_post_ajax = 3;

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_content_filter_option( $this->number_post );
		$this->set_content_setting_option();
		$this->pagination_option( $this->number_post_ajax );
		$this->set_style_option();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->set_content_filter_segment();
		$this->set_content_setting_segment();
		$this->set_pagination_segment();
		$this->set_style_segment();
	}

	/**
	 * Content setting segment
	 */
	public function set_content_setting_segment() {
		$this->segments['content-setting'] = [
			'name'     => esc_html__( 'Content Setting', 'jblog-elements' ),
			'priority' => 20,
		];
	}

	/**
	 * Pagination segmnet
	 */
	public function set_pagination_segment() {
		$this->segments['pagination'] = [
			'name'     => esc_html__( 'Pagination', 'jblog-elements' ),
			'priority' => 20,
		];
	}

	/**
	 * Content setting option
	 */
	public function set_content_setting_option() {
		$this->options['date_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post date type that you want to use.', 'jblog-elements' ),
			'default'     => 'published',
			'segment'     => 'content-setting',
			'options'     => [
				'published' => esc_html__( 'Published Date', 'jblog-elements' ),
				'modified'  => esc_html__( 'Modified Date', 'jblog-elements' ),
				'both'      => esc_html__( 'Show Both', 'jblog-elements' ),
			],
		];

		$this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use for single post.', 'jblog-elements' ),
			'default'     => 'default',
			'segment'     => 'content-setting',
			'options'     => [
				'ago'     => esc_attr__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_attr__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_attr__( 'Custom Format', 'jblog-elements' ),
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Post Date Custom Format', 'jblog-elements' ),
			'description' =>
				wp_kses(
					sprintf(
						__( 'Insert custom date format for single post meta. For more detail about this format, please refer to <a href="%s" target="_blank">Developer Codex</a>.', 'jblog-elements' ),
						'https://wordpress.org/support/article/formatting-date-and-time/'
					),
					wp_kses_allowed_html()
				),
			'default'     => get_option( 'date_format' ),
			'segment'     => 'content-setting',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			]
		];
	}

	/**
	 * Pagination option
	 *
	 * @param $number
	 */
	public function pagination_option( $number ) {
		$this->options['pagination_mode'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Pagination Mode', 'jblog-elements' ),
			'description' => esc_html__( 'Choose pagination that you want to use for this block.', 'jblog-elements' ),
			'segment'     => 'pagination',
			'default'     => 'disable',
			'options'     => [
				'disable'    => esc_html__( 'No Pagination', 'jblog-elements' ),
				'loadmore'   => esc_html__( 'Load More', 'jblog-elements' ),
				'scrollload' => esc_html__( 'Auto Load on Scroll', 'jblog-elements' ),
			],
		];

		$this->options['pagination_number_post'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Pagination Post', 'jblog-elements' ),
			'description' => esc_html__( 'Number of posts loaded for ajax pagination.', 'jblog-elements' ),
			'segment'     => 'pagination',
			'options'     => [
				'min'  => 1,
				'max'  => 30,
				'step' => 1,
			],
			'default'     => $number,
			'dependency'  => [
				[
					'field'    => 'pagination_mode',
					'operator' => 'in',
					'value'    => [ 'loadmore', 'scrollload' ],
				],
			],
		];

		$this->options['pagination_scroll_limit'] = [
			'type'        => 'number',
			'title'       => esc_html__( 'Auto Load Limit', 'jblog-elements' ),
			'description' => esc_html__( 'Limit of auto load when scrolling, set to zero to always load until end of content.', 'jblog-elements' ),
			'segment'     => 'pagination',
			'options'     => [
				'min'  => 0,
				'max'  => 9999,
				'step' => 1,
			],
			'default'     => 0,
			'dependency'  => [
				[
					'field'    => 'pagination_mode',
					'operator' => '==',
					'value'    => [ 'scrollload' ],
				],
			],
		];
	}
}
