<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Block_Popular_Option
 * @package JBP\Elements\Elements\Options
 */
class Block_Popular_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 4 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Popular Post', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '4 Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	public function set_element_options() {
		$this->options['title'] = [
            'title'       => esc_html__( 'Title', 'jblog-elements' ),
            'description' => esc_html__( 'Insert text for the title.', 'jblog-elements' ),
            'type'        => 'text',
			'segment'     => 'general'
        ];

        $this->options['number_post'] = [
            'title'       => esc_html__( 'Post Number', 'jblog-elements' ),
            'description' => esc_html__( 'Set the number of post shown.', 'jblog-elements' ),
            'type'        => 'slider',
			'segment'     => 'general',
			'options'     => [
                'min'  => '2',
                'max'  => '10',
                'step' => '1',
            ],
            'default'     => 5,
        ];

        $this->options['category'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Show Post Category', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show the post category.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => false
		];

		$this->options['post_index'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Index', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show the post index.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => 'none',
			'options'     => [
				'none' => esc_html__( 'None', 'jblog-elements' ),
				'1'    => esc_html__( 'Style 1', 'jblog-elements' ),
				'2'    => esc_html__( 'Style 2', 'jblog-elements' ),
			],
		];

        $this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Content Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => 'ago',
			'options'     => [
				'ago'     => esc_html__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_html__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_html__( 'Custom Format', 'jblog-elements' ),
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Custom Date Format', 'jblog-elements' ),
			'description' => wp_kses( sprintf( __( 'Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'jblog-elements' ), 'https://codex.wordpress.org/Formatting_Date_and_Time' ), wp_kses_allowed_html() ),
			'segment'     => 'general',
			'default'     => 'Y/m/d',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			],
		];
	}
}
