<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Blockads_Option
 * @package JBP\Elements\Elements\Options
 */
class Blockads_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block Ads', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'All Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	public function set_element_options() {
		$this->options['ads_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Ads Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which ads type you want to use.', 'jblog-elements' ),
			'default'     => 'googleads',
			'segment'     => 'general',
			'options'     => [
				'image'     => esc_html__( 'Image Ads', 'jblog-elements' ),
				'code'      => esc_html__( 'Script Code', 'jblog-elements' ),
				'googleads' => esc_html__( 'Google Ads', 'jblog-elements' ),
			],
		];

		// Image Ads.
		$this->options['ads_image'] = [
			'type'        => 'image',
			'title'       => esc_html__( '[Image Ads] Ads Image Desktop', 'jblog-elements' ),
			'description' => esc_html__( 'Upload your ads image that will be shown on the desktop view.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		$this->options['ads_image_tablet'] = [
			'type'        => 'image',
			'title'       => esc_html__( '[Image Ads] Ads Image Tablet', 'jblog-elements' ),
			'description' => esc_html__( 'Upload your ads image that will be shown on the tablet view.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		$this->options['ads_image_phone'] = [
			'type'        => 'image',
			'title'       => esc_html__( '[Image Ads] Ads Image Phone', 'jblog-elements' ),
			'description' => esc_html__( 'Upload your ads image that will be shown on the phone view.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		$this->options['ads_image_link'] = [
			'type'        => 'text',
			'title'       => esc_html__( '[Image Ads] Ads Image Link', 'jblog-elements' ),
			'description' => esc_html__( 'Insert link of your image ads.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		$this->options['ads_image_alt'] = [
			'type'        => 'text',
			'title'       => esc_html__( '[Image Ads] Image Alternate Text', 'jblog-elements' ),
			'description' => esc_html__( 'Insert alternate of your ads image.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		$this->options['ads_image_new_tab'] = [
			'type'       => 'checkbox',
			'title'      => esc_html__( '[Image Ads] Open New Tab', 'jblog-elements' ),
			'value'      => [ 'Open in new tab when ads image clicked.' => 'yes' ],
			'segment'    => 'general',
			'dependency' => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'image',
				],
			],
		];

		// Google Ads.
		$this->options['google_publisher_id'] = [
			'type'        => 'text',
			'title'       => esc_html__( '[Google Ads] Publisher ID', 'jblog-elements' ),
			'description' => esc_html__( 'Insert data-ad-client / google_ad_client content.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'googleads',
				],
			],
		];

		$this->options['google_slot_id'] = [
			'type'        => 'text',
			'title'       => esc_html__( '[Google Ads] Ads Slot ID', 'jblog-elements' ),
			'description' => esc_html__( 'Insert data-ad-slot / google_ad_slot content.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'googleads',
				],
			],
		];

		$this->options['google_desktop'] = [
			'type'        => 'select',
			'title'       => esc_html__( '[Google Ads] Desktop Ads Size', 'jblog-elements' ),
			'description' => esc_html__( 'Choose ads size to show on desktop.', 'jblog-elements' ),
			'default'     => 'auto',
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'googleads',
				],
			],
			'options'     => jblog_get_ad_size(),
		];

		$this->options['google_tab'] = [
			'type'        => 'select',
			'title'       => esc_html__( '[Google Ads] Tab Ads Size', 'jblog-elements' ),
			'description' => esc_html__( 'Choose ads size to show on tab.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'googleads',
				],
			],
			'default'     => 'auto',
			'options'     => jblog_get_ad_size(),
		];

		$this->options['google_phone'] = [
			'type'        => 'select',
			'title'       => esc_html__( '[Google Ads] Phone Ads Size', 'jblog-elements' ),
			'description' => esc_html__( 'Choose ads size to show on phone.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'googleads',
				],
			],
			'default'     => 'auto',
			'options'     => jblog_get_ad_size(),
		];

		// Code Ads.
		$this->options['content'] = [
			'type'        => 'textarea_html',
			'title'       => esc_html__( '[Script Code] Ads Code', 'jblog-elements' ),
			'description' => esc_html__( 'Put your full ads script right here.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'ads_type',
					'operator' => '==',
					'value'    => 'code',
				],
			],
		];

		$this->options['ads_bottom_text'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Show Advertisement Text', 'jblog-elements' ),
			'description' => esc_html__( 'Show Advertisement Text on bottom of advertisement', 'jblog-elements' ),
			'segment'     => 'general',
		];
	}
}
