<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Blocklink_Option
 * @package JBP\Elements\Elements\Options
 */
class Blocklink_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Block Link', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'All Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	public function set_element_options() {
		$this->options['first_title'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Title', 'jblog-elements' ),
			'description' => esc_html__( 'Insert a text for block link title.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['second_title'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Second Title', 'jblog-elements' ),
			'description' => esc_html__( 'Sub title or short description.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['title_url'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Title URL', 'jblog-elements' ),
			'description' => esc_html__( 'Url of block link title.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['newtab'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Open New Tab', 'jblog-elements' ),
			'description' => esc_html__( 'Check this option to open link on new tab.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['image'] = [
			'type'        => 'attach_image',
			'title'       => esc_html__( 'Background Image', 'jblog-elements' ),
			'description' => esc_html__( 'Choose an image for block background.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['use_video_bg'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Use Video Background', 'jblog-elements' ),
			'description' => esc_html__( 'If checked, video will be used as background.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['video_url'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'YouTube Link', 'jblog-elements' ),
			'description' => esc_html__( 'Add YouTube video link to used as video background.', 'jblog-elements' ),
			'dependency'  => [
				[
					'field'    => 'use_video_bg',
					'operator' => '==',
					'value'    => true,
				]
			],
			'segment'     => 'general',
		];
	}
}
