<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Hero_1_Option
 * @package JBP\Elements\Elements\Options
 */
class Hero_1_Option extends Hero_Option_Abstract {

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 12 ];
	}

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 4;

	/**
	 * Post excerpt flag
	 *
	 * @var bool
	 */
	protected $show_excerpt = false;

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Hero 1', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '12 Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_element_options();
		$this->set_content_filter_option( $this->number_post );
		$this->set_hero_design_options();
		$this->set_style_option();

		unset( $this->options['column_width'] );
	}

	/**
	 * General options
	 */
	public function set_element_options() {
		$this->options['hero_margin'] = [
            'type'          => 'slider',
			'title'			=> esc_html__( 'Hero Margin', 'jblog-elements' ),
			'description'	=> esc_html__( 'Margin of each hero element.', 'jblog-elements' ),
			'options'		=> [
				'min'  => 0,
				'max'  => 30,
				'step' => 1,
			],
			'default'		=> 5,
			'segment'		=> 'general',
        ];

		$this->options['hero_style'] = [
			'type'        => 'radioimage',
			'title'       => esc_html__( 'Hero Style', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which hero style that you want to use.', 'jblog-elements' ),
			'default'     => 'jblog_hero_style_1',
			'segment'     => 'general',
			'options'     => [
				'jblog_hero_style_1' => JBP_ELEMENTS_URL . '/assets/img/admin/hero-1-style-1.png',
				'jblog_hero_style_2' => JBP_ELEMENTS_URL . '/assets/img/admin/hero-1-style-2.png'
			]
		];

        $this->options['link'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Custom Link', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option if you want to put custom link into the hero post content.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => false,
		];

		$this->options['label'] = [
            'type'          => 'text',
			'title'			=> esc_html__( 'URL Text', 'jblog-elements' ),
			'description'	=> esc_html__( 'Insert text url.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'link',
					'operator' => '==',
					'value'    => true,
				],
			],
        ];

        $this->options['url'] = [
            'type'          => 'text',
			'title'			=> esc_html__( 'URL Link', 'jblog-elements' ),
			'description'	=> esc_html__( 'Insert url.', 'jblog-elements' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'link',
					'operator' => '==',
					'value'    => true,
				],
			],
        ];

		$this->options['color'] = [
			'type'        => 'color',
			'title'       => esc_html__( 'Text Color', 'jblog-elements' ),
			'description' => esc_html__( 'Set text color.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => '#fff',
			'dependency'  => [
				[
					'field'    => 'link',
					'operator' => '==',
					'value'    => true,
				],
			],
		];

		$this->options['bgcolor'] = [
			'type'        => 'color',
			'title'       => esc_html__( 'Background Color', 'jblog-elements' ),
			'description' => esc_html__( 'Set background color.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => '#0058E6',
			'dependency'  => [
				[
					'field'    => 'link',
					'operator' => '==',
					'value'    => true,
				],
			],
		];

		$this->options['date_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post date type that you want to use.', 'jblog-elements' ),
			'default'     => 'published',
			'segment'     => 'general',
			'options'     => [
				'published' => esc_html__( 'Published Date', 'jblog-elements' ),
				'modified'  => esc_html__( 'Modified Date', 'jblog-elements' ),
				'both'      => esc_html__( 'Show Both', 'jblog-elements' ),
			],
		];

        $this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Content Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => 'ago',
			'options'     => [
				'ago'     => esc_html__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_html__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_html__( 'Custom Format', 'jblog-elements' ),
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Custom Date Format', 'jblog-elements' ),
			'description' => wp_kses( sprintf( __( 'Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'jblog-elements' ), 'https://codex.wordpress.org/Formatting_Date_and_Time' ), wp_kses_allowed_html() ),
			'segment'     => 'general',
			'default'     => 'Y/m/d',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Custom Date Format', 'jblog-elements' ),
			'description' => wp_kses( sprintf( __( 'Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'jblog-elements' ), 'https://codex.wordpress.org/Formatting_Date_and_Time' ), wp_kses_allowed_html() ),
			'segment'     => 'general',
			'default'     => 'Y/m/d',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			],
		];
	}
}
