<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Slider_Option_Abstract
 * @package JBP\Elements\Elements\Options
 */
abstract class Hero_Option_Abstract extends Elements_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 4;

	/**
	 * Get Hero Total Post Number
	 *
	 * @return int
	 */
	public function get_number_post() {
		return $this->number_post;
	}

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->set_content_filter_segment();
		$this->set_style_segment();

		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 9,
		];

		$this->segments['hero-design'] = [
			'name'     => esc_html__( 'Hero Design', 'jblog-elements' ),
			'priority' => 15,
		];
	}

	/**
	 * Hero design options
	 */
	public function set_hero_design_options() {
		$this->options['height_desktop'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on Dekstop', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];

		$this->options['height_1024'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on 1024px Width Screen', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];

		$this->options['height_768'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on 768px Width Screen', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];

		$this->options['height_667'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on 667px Width Screen', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];

		$this->options['height_568'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on 568px Width Screen', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];

		$this->options['height_480'] = [
			'type'          => 'text',
			'title'			=> esc_html__( 'Hero Height on 480px Width Screen', 'jblog-elements' ),
			'description'	=> esc_html__( 'Height on px (pixel), leave it empty to use the default number.', 'jblog-elements' ),
			'segment'		=> 'hero-design',
		];
	}
}
