<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Post_Featured_Option
 * @package JBP\Elements\Elements\Options
 */
class Post_Featured_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Post Featured', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Post Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['image_size'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Featured Image Size', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which feature image size.', 'jblog-elements' ),
			'default'     => 'jeg-800x400',
			'segment'     => 'general',
			'options'     => [
				'jeg-800x400'       => esc_attr__( '750x375', 'jblog-elements' ),
				'jeg-750x536'       => esc_attr__( '750x536', 'jblog-elements' ),
				'jeg-1140x570'      => esc_attr__( '1140x570', 'jblog-elements' ),
				'jeg-featured-750'  => esc_attr__( 'Width 750', 'jblog-elements' ),
				'jeg-featured-1140' => esc_attr__( 'Width 1140', 'jblog-elements' ),
				'full'              => esc_attr__( 'Fullwidth', 'jblog-elements' ),
			]
		];

		$this->options['caption'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Image Caption', 'jblog-elements' ),
			'description' => esc_html__( 'Set image caption position.', 'jblog-elements' ),
			'default'     => 'right',
			'segment'     => 'general',
			'options'     => [
				'right' => esc_attr__( 'Right Side', 'jblog-elements' ),
				'left'  => esc_attr__( 'Left Side', 'jblog-elements' ),
				'hide'  => esc_attr__( 'Hide', 'jblog-elements' )
			]
		];
	}
}
