<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Post_Meta_Option
 * @package JBP\Elements\Elements\Options
 */
class Post_Meta_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Post Meta', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Post Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['meta_style'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Meta Style', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post meta style that you want to use.', 'jblog-elements' ),
			'default'     => '1',
			'segment'     => 'general',
			'options'     => [
				'1' => esc_html__( 'Style 1', 'jblog-elements' ),
				'2' => esc_html__( 'Style 2', 'jblog-elements' ),
			]
		];

		$this->options['author'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Post Author', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show post author.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => true
		];

		$this->options['author_image'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Post Author Image', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show post author image.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => true,
			'dependency'  => [
				[
					'field'    => 'author',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$this->options['date'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Post Date', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show post date.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => true
		];

		$this->options['date_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post date type that you want to use.', 'jblog-elements' ),
			'default'     => 'published',
			'segment'     => 'general',
			'options'     => [
				'published' => esc_html__( 'Published Date', 'jblog-elements' ),
				'modified'  => esc_html__( 'Modified Date', 'jblog-elements' ),
				'both'      => esc_html__( 'Show Both', 'jblog-elements' ),
			],
			'dependency'  => [
				[
					'field'    => 'date',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use for single post.', 'jblog-elements' ),
			'default'     => 'default',
			'segment'     => 'general',
			'options'     => [
				'ago'     => esc_attr__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_attr__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_attr__( 'Custom Format', 'jblog-elements' ),
			],
			'dependency'  => [
				[
					'field'    => 'date',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$this->options['date_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Post Date Custom Format', 'jblog-elements' ),
			'description' =>
				wp_kses(
					sprintf(
						__( 'Insert custom date format for single post meta. For more detail about this format, please refer to <a href="%s" target="_blank">Developer Codex</a>.', 'jblog-elements' ),
						'https://wordpress.org/support/article/formatting-date-and-time/'
					),
					wp_kses_allowed_html()
				),
			'default'     => get_option( 'date_format' ),
			'segment'     => 'general',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
				[
					'field'    => 'date',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		$this->options['read'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Post Read Time', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show post read time.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => true
		];

		$this->options['comment'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Post Comment', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option to show post comment.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => true
		];

		$this->options['align'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Meta Align', 'jblog-elements' ),
			'description' => esc_html__( 'Set alignment for the post meta.', 'jblog-elements' ),
			'default'     => 'left',
			'segment'     => 'general',
			'options'     => [
				'left'   => esc_html__( 'Left Align', 'jblog-elements' ),
				'right'  => esc_html__( 'Right Align', 'jblog-elements' ),
				'center' => esc_html__( 'Center Align', 'jblog-elements' ),
			],
		];
	}
}
