<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Post_Related_Option
 * @package JBP\Elements\Elements\Options
 */
class Post_Related_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Post Related', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Post Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['label'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Title', 'jblog-elements' ),
			'description' => esc_html__( 'Insert some text for related post title.', 'jblog-elements' ),
			'default'     => esc_html__( 'Related Posts', 'jblog-elements' ),
			'segment'     => 'general'
		];

		$this->options['filter'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Related Filter', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which filter that you want to use as related post filter.', 'jblog-elements' ),
			'default'     => 'category',
			'segment'     => 'general',
			'options'     => [
				'category' => esc_html__( 'Category', 'jblog-elements' ),
				'tag'      => esc_html__( 'Post Tag', 'jblog-elements' ),
				'both'     => esc_html__( 'Both', 'jblog-elements' ),
			]
		];

		$this->options['block'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Related Block', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which block element that you want to use.', 'jblog-elements' ),
			'default'     => '27',
			'segment'     => 'general',
			'options'     => [
				'3'  => esc_html__( 'JBlog - Block 3 (4 Columns)', 'jblog-elements' ),
				'5'  => esc_html__( 'JBlog - Block 5 (4 Columns)', 'jblog-elements' ),
				'7'  => esc_html__( 'JBlog - Block 7 (4 Columns)', 'jblog-elements' ),
				'8'  => esc_html__( 'JBlog - Block 8 (4 Columns)', 'jblog-elements' ),
				'10' => esc_html__( 'JBlog - Block 10 (4 Columns)', 'jblog-elements' ),
				'15' => esc_html__( 'JBlog - Block 15 (4 Columns)', 'jblog-elements' ),
				'20' => esc_html__( 'JBlog - Block 20 (4 Columns)', 'jblog-elements' ),
				'1'  => esc_html__( 'JBlog - Block 1 (8 Columns)', 'jblog-elements' ),
				'2'  => esc_html__( 'JBlog - Block 2 (8 Columns)', 'jblog-elements' ),
				'6'  => esc_html__( 'JBlog - Block 6 (8 Columns)', 'jblog-elements' ),
				'9'  => esc_html__( 'JBlog - Block 9 (8 Columns)', 'jblog-elements' ),
				'11' => esc_html__( 'JBlog - Block 11 (8 Columns)', 'jblog-elements' ),
				'12' => esc_html__( 'JBlog - Block 12 (8 Columns)', 'jblog-elements' ),
				'13' => esc_html__( 'JBlog - Block 13 (8 Columns)', 'jblog-elements' ),
				'17' => esc_html__( 'JBlog - Block 17 (8 Columns)', 'jblog-elements' ),
				'18' => esc_html__( 'JBlog - Block 18 (8 Columns)', 'jblog-elements' ),
				'19' => esc_html__( 'JBlog - Block 19 (8 Columns)', 'jblog-elements' ),
				'24' => esc_html__( 'JBlog - Block 24 (8 Columns)', 'jblog-elements' ),
				'26' => esc_html__( 'JBlog - Block 26 (8 Columns)', 'jblog-elements' ),
				'4'  => esc_html__( 'JBlog - Block 4 (12 Columns)', 'jblog-elements' ),
				'14' => esc_html__( 'JBlog - Block 14 (12 Columns)', 'jblog-elements' ),
				'16' => esc_html__( 'JBlog - Block 16 (12 Columns)', 'jblog-elements' ),
				'21' => esc_html__( 'JBlog - Block 21 (12 Columns)', 'jblog-elements' ),
				'22' => esc_html__( 'JBlog - Block 22 (12 Columns)', 'jblog-elements' ),
				'23' => esc_html__( 'JBlog - Block 23 (12 Columns)', 'jblog-elements' ),
				'25' => esc_html__( 'JBlog - Block 25 (12 Columns)', 'jblog-elements' ),
				'27' => esc_html__( 'JBlog - Block 27 (12 Columns)', 'jblog-elements' ),
				'28' => esc_html__( 'JBlog - Block 28 (12 Columns)', 'jblog-elements' ),
				'29' => esc_html__( 'JBlog - Block 29 (12 Columns)', 'jblog-elements' )
			]
		];

		$this->options['number_post'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Number of Post', 'jblog-elements' ),
			'description' => esc_html__( 'Set the number of post for related post content.', 'jblog-elements' ),
			'options'     => [
				'min'  => 1,
				'max'  => 50,
				'step' => 1,
			],
			'default'     => 4,
			'segment'     => 'general',
		];
	}
}
