<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Post_Tag_Option
 * @package JBP\Elements\Elements\Options
 */
class Post_Tag_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Post Tag', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'Post Template', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['label'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Title', 'jblog-elements' ),
			'description' => esc_html__( 'Insert some text for tag title.', 'jblog-elements' ),
			'default'     => esc_html__( 'Tags: ', 'jblog-elements' ),
			'segment'     => 'general'
		];

		$this->options['style'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Tag Style', 'jblog-elements' ),
			'description' => esc_html__( 'Set style for the post tag.', 'jblog-elements' ),
			'default'     => '1',
			'segment'     => 'general',
			'options'     => [
				'1' => esc_html__( 'Style 1', 'jblog-elements' ),
				'2' => esc_html__( 'Style 2', 'jblog-elements' ),
				'3' => esc_html__( 'Style 3', 'jblog-elements' ),
			]
		];

		$this->options['align'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Tag Align', 'jblog-elements' ),
			'description' => esc_html__( 'Set alignment for the post tag.', 'jblog-elements' ),
			'default'     => 'left',
			'segment'     => 'general',
			'options'     => [
				'left'   => esc_html__( 'Left Align', 'jblog-elements' ),
				'right'  => esc_html__( 'Right Align', 'jblog-elements' ),
				'center' => esc_html__( 'Center Align', 'jblog-elements' ),
			]
		];
	}
}
