<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Slider_2_Option
 * @package JBP\Elements\Elements\Options
 */
class Slider_2_Option extends Slider_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 5;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 12 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Slider 2', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '12 Columns', 'jblog-elements' );
	}

	/**
	 * Set slider option
	 */
	public function set_element_option() {

		$this->options['enable_autoplay'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Enable Autoplay', 'jblog-elements' ),
			'description' => esc_html__( 'Check this option to enable auto play.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['autoplay_delay'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Autoplay Delay', 'jblog-elements' ),
			'description' => esc_html__( 'Set your autoplay delay (in millisecond).', 'jblog-elements' ),
			'default'     => 3000,
			'options'     => [
				'min'  => 1000,
				'max'  => 10000,
				'step' => 500,
			],
			'dependency'  => [
				[
					'field'    => 'enable_autoplay',
					'operator' => '==',
					'value'    => true,
				],
			],
			'segment'     => 'general',
		];

		$this->options['date_type'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Post Date Type', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which post date type that you want to use.', 'jblog-elements' ),
			'default'     => 'published',
			'segment'     => 'general',
			'options'     => [
				'published' => esc_html__( 'Published Date', 'jblog-elements' ),
				'modified'  => esc_html__( 'Modified Date', 'jblog-elements' ),
				'both'      => esc_html__( 'Show Both', 'jblog-elements' ),
			],
		];

		$this->options['date_format'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Content Date Format', 'jblog-elements' ),
			'description' => esc_html__( 'Choose which date format you want to use.', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => 'ago',
			'options'     => [
				'ago'     => esc_html__( 'Relative Date/Time Format (ago)', 'jblog-elements' ),
				'default' => esc_html__( 'WordPress Default Format', 'jblog-elements' ),
				'custom'  => esc_html__( 'Custom Format', 'jblog-elements' ),
			],
		];

		$this->options['date_format_custom'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Custom Date Format', 'jblog-elements' ),
			'description' => wp_kses( sprintf( __( 'Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'jblog-elements' ), 'https://codex.wordpress.org/Formatting_Date_and_Time' ), wp_kses_allowed_html() ),
			'segment'     => 'general',
			'default'     => 'Y/m/d',
			'dependency'  => [
				[
					'field'    => 'date_format',
					'operator' => '==',
					'value'    => 'custom',
				],
			],
		];
	}
}
