<?php

namespace JBP\Elements\Elements\Options;

/**
 * Class Slider_4_Option
 * @package JBP\Elements\Elements\Options
 */
class Slider_4_Option extends Slider_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 4;

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ 12 ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Slider 4', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( '12 Columns', 'jblog-elements' );
	}

	/**
	 * Set slider option
	 */
	public function set_element_option() {

		$this->options['enable_autoplay'] = [
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Enable Autoplay', 'jblog-elements' ),
			'description' => esc_html__( 'Check this option to enable auto play.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$this->options['autoplay_delay'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Autoplay Delay', 'jblog-elements' ),
			'description' => esc_html__( 'Set your autoplay delay (in millisecond).', 'jblog-elements' ),
			'default'     => 3000,
			'options'     => [
				'min'  => 1000,
				'max'  => 10000,
				'step' => 500,
			],
			'dependency'  => [
				[
					'field'    => 'enable_autoplay',
					'operator' => '==',
					'value'    => true,
				],
			],
			'segment'     => 'general',
		];

		$this->options['excerpt_length'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Excerpt Length', 'jblog-elements' ),
			'description' => esc_html__( 'Set word length of excerpt on post block.', 'jblog-elements' ),
			'segment'     => 'general',
			'options'     => [
				'min'  => 0,
				'max'  => 200,
				'step' => 1,
			],
			'default'     => 15,
		];

		$this->options['excerpt_ellipsis'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Excerpt Ellipsis', 'jblog-elements' ),
			'description' => esc_html__( 'Define excerpt ellipsis', 'jblog-elements' ),
			'segment'     => 'general',
			'default'     => '...',
		];
	}
}
