<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Slider_Option_Abstract
 * @package JBP\Elements\Elements\Options
 */
abstract class Slider_Option_Abstract extends Elements_Option_Abstract {

	/**
	 * Default number of post
	 *
	 * @var int
	 */
	protected $number_post = 3;

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_element_option();
		$this->set_content_filter_option( $this->number_post );
		$this->set_style_option();

		unset( $this->options['column_width'] );
	}

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->set_content_filter_segment();
		$this->set_style_segment();

		$segments = [
			[ 'general' => esc_html__( 'General', 'jblog-elements' ) ],
		];

		$priority = 9;

		foreach ( $segments as $segment ) {
			foreach ( $segment as $key => $value ) {
				$this->segments[ $key ] = [
					'name'     => $value,
					'priority' => $priority ++,
				];
			}
		}
	}

	/**
	 * Set slider option
	 */
	abstract public function set_element_option();
}
