<?php

namespace JBP\Elements\Elements\Options;

use Jeg\Element\Elements\Elements_Option_Abstract;

/**
 * Class Taxonomy_List_Option
 * @package JBP\Elements\Elements\Options
 */
class Taxonomy_List_Option extends Elements_Option_Abstract {

	/**
	 * Show color scheme flag for element.
	 *
	 * @return bool
	 */
	public function show_color_scheme() {
		return false;
	}

	/**
	 * Compatibility column
	 *
	 * @return array
	 */
	public function compatible_column() {
		return [ esc_html__( 'All Columns', 'jblog-elements' ) ];
	}

	/**
	 * Element name
	 *
	 * @return string
	 */
	public function get_element_name() {
		return esc_html__( 'JBlog - Taxonomy List', 'jblog-elements' );
	}

	/**
	 * Element category
	 *
	 * @return string
	 */
	public function get_category() {
		return esc_html__( 'All Columns', 'jblog-elements' );
	}

	/**
	 * Element options
	 */
	public function set_options() {
		$this->set_style_option();
		$this->set_element_options();

		unset( $this->options['column_width'] );
	}

	/**
	 * Option segments
	 */
	public function set_segments() {
		$this->segments['general'] = [
			'name'     => esc_html__( 'General', 'jblog-elements' ),
			'priority' => 10,
		];
		$this->set_style_segment();
	}

	/**
	 * Set element option
	 */
	public function set_element_options() {
		$this->options['label'] = [
			'type'        => 'text',
			'title'       => esc_html__( 'Title', 'jblog-elements' ),
			'description' => esc_html__( 'Insert some text for title.', 'jblog-elements' ),
			'segment'     => 'general',
		];

		$taxonomy_list = [
			'category' => esc_html__( 'Post Category', 'jblog-elements' ),
			'post_tag' => esc_html__( 'Post Tag', 'jblog-elements' ),
		];
		$custom_taxonomy_list = jeg_get_enabled_custom_taxonomy();

		if ( $custom_taxonomy_list && is_array( $custom_taxonomy_list ) ) {
			foreach ( $custom_taxonomy_list as $key => $item ) {
				$taxonomy_list[ $key ] = $item['name'];
			}
		}

		$this->options['taxonomy'] = [
			'type'        => 'select',
			'title'       => esc_html__( 'Taxonomy Slug', 'jblog-elements' ),
			'description' => esc_html__( 'Insert taxonomy slug.', 'jblog-elements' ),
			'default'     => 'category',
			'options'     => $taxonomy_list,
			'segment'     => 'general',
		];

		$this->options['number'] = [
			'type'        => 'slider',
			'title'       => esc_html__( 'Number of Item', 'jblog-elements' ),
			'description' => esc_html__( 'Leave 0 to show all items.', 'jblog-elements' ),
			'segment'     => 'general',
			'options'     => [
				'min'  => 0,
				'max'  => 100,
				'step' => 1,
			],
			'default'     => 3,
		];
	}
}
