<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Element;

/**
 * Class Archive_Block_View
 * @package JBP\Elements\Elements\Views
 */
class Archive_Block_View extends Archive_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return $this->build_content( $attr );
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return $this->build_content( $attr );
	}

	/**
	 * Build block content
	 *
	 * @param $attr
	 *
	 * @return bool
	 */
	public function build_content( $attr ) {
		add_filter( 'jeg_module_no_content', '__return_false' );

		if ( '12' === $attr['column'] ) {
			$block = $attr['long-block'];
		} elseif ( '8' === $attr['column'] ) {
			$block = $attr['medium-block'];
		} else {
			$block = $attr['small-block'];
		}

		$id      = 'jblog_' . strtolower( $block );
		$manager = Element::instance()->manager;
		$view    = $manager->get_element_view( $id );

		$attr['results'] = [
			'result'    => $this->get_result( $attr, $attr['number_post'] ),
			'next'       => false,
			'total_page' => false
		];

		return $view->build_element( $attr, '' );
	}
}
