<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Archive_Desc_View
 * @package JBP\Elements\Elements\Views
 */
class Archive_Desc_View extends Archive_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		$term  = $this->get_term();
		$desc  = isset( $term->description ) ? $term->description : '';

		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_desc ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<p ' . $this->generate_style( $attr ) . '>' . $desc . '</p>
				</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_desc ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<p ' . $this->generate_style( $attr ) . '>' . esc_html__( 'This is dummy text and will be replaced with the actual archive description on the frontend', 'jblog-elements' ) . '</p>
				</div>';
	}
}
