<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Element;

/**
 * Class Archive_Hero_View
 * @package JBP\Elements\Elements\Views
 */
class Archive_Hero_View extends Archive_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return $this->build_content( $attr );
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return $this->build_content( $attr );
	}

	/**
	 * Build hero content
	 *
	 * @param $attr
	 *
	 * @return bool
	 */
	public function build_content( $attr ) {
		if ( $attr['first_page'] && jblog_get_post_current_page() > 1 ) {
			return false;
		}

		$id      = 'jblog_' . strtolower( $attr['hero_type'] );
		$manager = Element::instance()->manager;
		$option  = $manager->get_element_option( $id );
		$view    = $manager->get_element_view( $id );
		$number  = $option->get_number_post();

		if ( $attr['link'] ) {
			$number = (int) $number - 1;
		}

		$attr['result'] = $this->get_result( $attr, $number );

		return $view->build_element( $attr, '' );
	}
}
