<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Archive_Pagination_View
 * @package JBP\Elements\Elements\Views
 */
class Archive_Pagination_View extends Archive_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_pagination ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->build_pagination() . '</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_pagination ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<span aria-current="page" class="page-numbers current">1</span>
					<a class="page-numbers" href="#">2</a>
					<a class="page-numbers" href="#">3</a>
					<a class="next page-numbers" href="#">
						<span>Next</span>
						<i class="jblog-icon-arrow-right"></i>
					</a>
				</div>';
	}

	/**
	 * Build pagination element
	 *
	 * @return array|string
	 */
	public function build_pagination() {
		return paginate_links( [
			'next_text' => sprintf( '<span>%s</span><i class="jblog-icon-arrow-right"></i>', esc_html__( 'Next', 'jblog-elements' ) ),
			'prev_text' => sprintf( '<i class="jblog-icon-arrow-left"></i><span>%s</span>', esc_html__( 'Previous', 'jblog-elements' ) ),
		] );
	}
}
