<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Archive_Title_View
 * @package JBP\Elements\Elements\Views
 */
class Archive_Title_View extends Archive_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		if ( is_category() ) {
			$title = single_cat_title( '', false );
		} elseif ( is_tag() ) {
			$title = single_tag_title( '', false );
		} elseif ( is_author() ) {
			$title = get_the_author_meta( 'display_name', get_queried_object()->ID );
		} elseif ( is_year() ) {
			$title = get_the_date( 'Y' );
		} elseif ( is_month() ) {
			$title = get_the_date( 'F Y' );
		} elseif ( is_day() ) {
			$title = get_the_date( 'F j, Y' );
		}

		if ( ! empty( $attr['label'] ) ) {
			$title = $attr['label'] . $title;
		}

		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_title ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h1 ' . $this->generate_style( $attr ) . '>' . $title . '</h1>
				</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_archive_title ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h1 ' . $this->generate_style( $attr ) . '>' . $attr['label'] . esc_html__( 'Archive Title', 'jblog-elements' ) . '</h1>
				</div>';
	}
}
