<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Query;

/**
 * Class Archive_View_Abstract
 * @package JBP\Elements\Elements\Views
 */
abstract class Archive_View_Abstract extends View_Abstract {

	/**
	 * Term ID
	 */
	protected static $term;

	/**
	 * Post result
	 */
	protected static $result = [];

	/**
	 * Index number of post
	 */
	protected static $index;

	/**
	 * Post per page
	 */
	protected static $post_per_page;

	/**
	 * @return Int|object
	 */
	public function get_term() {
		if ( ! self::$term ) {
			self::$term = get_queried_object();
		}

		return self::$term;
	}

	/**
	 * Render post element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		if ( $this->is_on_editor() ) {
			return $this->render_backend( $attr, $column_class );
		} else {
			return $this->render_frontend( $attr, $column_class );
		}
	}

	/**
	 * Editor page checking
	 *
	 * @return bool
	 */
	protected function is_on_editor() {
		return jeg_is_frontend_vc() || jeg_is_editor_elementor();
	}

	/**
	 * Generate style
	 *
	 * @param $attr
	 *
	 * @return string
	 */
	public function generate_style( $attr ) {
		$output = '';

		if ( isset( $attr['color'] ) && $attr['color'] ) {
			$output .= 'color: ' . $attr['color'] . ';';
		}

		if ( isset( $attr['font-size'] ) && $attr['font-size'] ) {
			$output .= 'font-size: ' . $attr['font-size'] . ';';
		}

		if ( $output ) {
			$output = 'style="' . $output . '"';
		}

		return $output;
	}

	/**
	 * Handle post result
	 *
	 * @param $attr
	 * @param $number_post
	 *
	 * @return array
	 */
	protected function get_result( $attr, $number_post ) {
		$result = $this->do_query( $attr );

		if ( ! empty( $result['result'] ) && is_array( $result['result'] ) ) {

			if ( isset( $number_post['size'] ) ) {
				$number_post = $number_post['size'];
			}

			if ( $number_post ) {
				$result['result'] = array_slice( $result['result'], self::$index, $number_post );
			} else {
				$result['result'] = array_slice( $result['result'], self::$index );
			}

			if ( ! is_admin() ) {
				self::$index += $number_post;
			}
		}

		return $result['result'];
	}

	/**
	 * Get post per page
	 *
	 * @return int
	 */
	public function get_post_per_page() {
		if ( ! self::$post_per_page ) {
			self::$post_per_page = get_option( 'posts_per_page' );
		}

		return self::$post_per_page;
	}

	/**
	 * Query handler
	 *
	 * @param $attr
	 *
	 * @return array
	 */
	protected function do_query( $attr ) {
		if ( ! self::$result ) {

			if ( is_category() ) {
				$term = $this->get_term();

				if ( isset( $term->term_id ) ) {
					$attr['include_category'] = $term->term_id;
				}
			}

			if ( is_tag() ) {
				$term = $this->get_term();

				if ( isset( $term->term_id ) ) {
					$attr['include_tag'] = $term->term_id;
				}
			}

			if ( is_author() ) {
				$user = get_userdata( get_query_var( 'author' ) );

				if ( isset( $user->ID ) ) {
					$attr['include_author'] = $user->ID;
				}
			}

			$attr['sort_by']                = 'latest';
			$attr['post_type']              = 'post';
			$attr['post_offset']            = 0;
			$attr['number_post']            = $this->get_post_per_page();
			$attr['pagination_number_post'] = $this->get_post_per_page();
			$attr['paged']                  = jblog_get_post_current_page();

			$result = Query::get( $attr );

			if ( isset( $result['result'] ) ) {
				self::$result = $result;
			}
		}

		return self::$result;
	}

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public abstract function render_frontend( $attr, $column_class );

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public abstract function render_backend( $attr, $column_class );
}
