<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Block_1_View
 * @package JBP\Elements\Elements\Views
 */
class Block_1_View extends Block_View_Abstract {

	/**
	 * Post excerpt
	 *
	 * @var bool
	 */
	protected $post_excerpt = false;

	/**
	 * Build column type 1 method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function build_column( $results ) {
		$first_block = '';
		$size        = count( $results );

		for ( $i = 0; $i < $size; $i ++ ) {
			$first_block .= $this->render_block_type_1( $results[ $i ], 'jeg-370x296' );
		}

		return $first_block;
	}

	/**
	 * Render block type 1 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_1( $post, $image_size ) {
		$thumbnail        = $this->get_thumbnail( $post->ID, $image_size );
		$primary_category = $this->get_primary_category( $post->ID );
		$comment          = jblog_get_comments_number( $post->ID );
		$excerpt          = $this->post_excerpt ?
			'<div class="jeg_post_excerpt">
                <p>' . $this->get_excerpt( $post ) . '</p>
            </div>' : '';

		$output =
			'<article ' . jeg_post_class( 'jeg_post', $post->ID ) . '>
                <div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                </div>
                <div class="jeg_postblock_content">
                	<div class="jeg_post_category">
                        <span>' . $primary_category . '</span>
                    </div>
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    ' . $this->post_meta_1( $post ) . '
                    ' . $excerpt . '
                    <div class="jeg_post_meta_bottom">
                    	<div class="jeg_meta_readmore">
                    		<a href="' . get_the_permalink( $post ) . '" class="jeg_readmore">' . esc_html__( 'Read more', 'jblog-elements' ) . ' <i class="jblog-icon-arrow-right"></i></a>
                    	</div>
                    	<div class="jeg_meta_comment">
                    		<a href="' . jblog_get_respond_link( $post->ID ) . '" >
                    		    <i class="jblog-icon-comment"></i> <span>' . $comment . '</span>
                    		</a>
                    	</div>
					</div>
                </div>
            </article>';

		return $output;
	}

	/**
	 * Render block type 2 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_2( $post, $image_size ) {
		$thumbnail        = $this->get_thumbnail( $post->ID, $image_size );
		$primary_category = $this->get_primary_category( $post->ID );
		$excerpt          = $this->post_excerpt ?
			'<div class="jeg_post_excerpt">
                <p>' . $this->get_excerpt( $post ) . '</p>
            </div>' : '';

		$output =
			'<article ' . jeg_post_class( 'jeg_post jeg_large_block', $post->ID ) . '>
                <div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                </div>
                <div class="jeg_postblock_content">
                	<div class="jeg_post_category">
                        <span>' . $primary_category . '</span>
                    </div>
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    ' . $this->post_meta_1( $post ) . '
                    ' . $excerpt . '
                    <div class="jeg_post_meta_bottom">
                    	<div class="jeg_meta_readmore">
                    		<a href="' . get_the_permalink( $post ) . '" class="jeg_readmore">' . esc_html__( 'Read more', 'jblog-elements' ) . ' <i class="jblog-icon-arrow-right"></i></a>
                    	</div>
					</div>
                </div>
            </article>';

		return $output;
	}
}
