<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Image\Image_Normal_Load;

/**
 * Class Block_20_View
 * @package JBP\Elements\Elements\Views
 */
class Block_20_View extends Block_View_Abstract {

	/**
	 * Build column type 1 method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function build_column( $results ) {
		$first_block = '';
		$size        = count( $results );

		for ( $i = 0; $i < $size; $i ++ ) {
			$first_block .= $this->render_block_type_1( $results[ $i ], 'jeg-featured-750' );
		}

		return $first_block;
	}

	/**
	 * Render block type 1 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_1( $post, $image_size ) {
		$image            = new Image_Normal_Load();
		$thumbnail        = $image->image_thumbnail( $post->ID, $image_size );
		$additional_class = ( ! has_post_thumbnail( $post->ID ) ) ? ' no_thumbnail' : '';
		$primary_category = $this->get_primary_category( $post->ID );

		$output =
			'<article ' . jeg_post_class( 'jeg_post' . $additional_class, $post->ID ) . '>
				<div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                </div>
                <div class="jeg_postblock_content">
                	<div class="jeg_post_category">
                        <span>' . $primary_category . '</span>
                    </div>
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    ' . $this->post_meta_1( $post ) . '
                </div>
            </article>';

		return $output;
	}
}
