<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Block_21_View
 * @package JBP\Elements\Elements\Views
 */
class Block_21_View extends Block_View_Abstract {

	/**
	 * Build column type 1 method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function build_column( $results ) {
		$first_block = '';
		$size        = count( $results );

		for ( $i = 0; $i < $size; $i ++ ) {
			$first_block .= $this->render_block_type_1( $results[ $i ], 'jeg-750x536' );
		}

		return $first_block;
	}

	/**
	 * Render block type 1 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_1( $post, $image_size ) {
		$primary_category = $this->get_primary_category( $post->ID );
		$thumbnail        = $this->get_thumbnail( $post->ID, $image_size );

		$output =
			'<article ' . jeg_post_class( 'jeg_post', $post->ID ) . '>
				<div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                </div>
                <div class="jeg_postblock_content">
                	<div class="jeg_post_category">
                        <span>' . $primary_category . '</span>
                    </div>
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    ' . $this->post_meta_1( $post ) . '
                </div>
            </article>';

		return $output;
	}
}
